/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag.eager;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import com.hubspot.algebra.Result;
import com.hubspot.jinjava.interpret.AutoCloseableSupplier;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.interpret.errorcategory.BasicTemplateErrorCategory;
import com.hubspot.jinjava.lib.tag.ImportTag;
import com.hubspot.jinjava.lib.tag.eager.EagerStateChangingTag;
import com.hubspot.jinjava.lib.tag.eager.importing.EagerImportingStrategy;
import com.hubspot.jinjava.lib.tag.eager.importing.EagerImportingStrategyFactory;
import com.hubspot.jinjava.lib.tag.eager.importing.ImportingData;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.parse.TagToken;
import com.hubspot.jinjava.util.EagerReconstructionUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@Beta
public class EagerImportTag
extends EagerStateChangingTag<ImportTag> {
    public EagerImportTag() {
        super(new ImportTag());
    }

    public EagerImportTag(ImportTag importTag) {
        super(importTag);
    }

    @Override
    public String getEagerTagImage(TagToken tagToken, JinjavaInterpreter interpreter) {
        ImportingData importingData = EagerImportingStrategyFactory.getImportingData(tagToken, interpreter);
        EagerImportingStrategy eagerImportingStrategy = EagerImportingStrategyFactory.create(importingData);
        Object templateFileResult = ImportTag.getTemplateFileWithWrapper(importingData.getHelpers(), tagToken, interpreter).get();
        try {
            String string = (String)((Result)((AutoCloseableSupplier.AutoCloseableImpl)templateFileResult).value()).match(err -> {
                String path = StringUtils.trimToEmpty((String)importingData.getHelpers().get(0));
                interpreter.addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.EXCEPTION, TemplateError.ErrorItem.TAG, "Import cycle detected for path: '" + path + "'", null, tagToken.getLineNumber(), tagToken.getStartPosition(), (Exception)err, BasicTemplateErrorCategory.IMPORT_CYCLE_DETECTED, (Map<String, String>)ImmutableMap.of((Object)"path", (Object)path)));
                return "";
            }, templateFile -> {
                try (Object node = ImportTag.parseTemplateAsNode(interpreter, templateFile).get();){
                    String output;
                    JinjavaInterpreter child = interpreter.getConfig().getInterpreterFactory().newInstance(interpreter);
                    child.getContext().put("import_resource_path", templateFile);
                    try (Object a = JinjavaInterpreter.closeablePushCurrent(child).get();){
                        eagerImportingStrategy.setup(child);
                        output = child.render((Node)((AutoCloseableSupplier.AutoCloseableImpl)node).value());
                    }
                    interpreter.addAllChildErrors((String)templateFile, (Collection<TemplateError>)child.getErrorsCopy());
                    Map<String, Object> childBindings = child.getContext().getSessionBindings();
                    if (!child.getContext().getDeferredNodes().isEmpty() || interpreter.getContext().isDeferredExecutionMode() && !child.getContext().getGlobalMacros().isEmpty()) {
                        ImportTag.handleDeferredNodesDuringImport((Node)((AutoCloseableSupplier.AutoCloseableImpl)node).value(), ImportTag.getContextVar(importingData.getHelpers()), childBindings, child, interpreter);
                        throw new DeferredValueException((String)templateFile, tagToken.getLineNumber(), tagToken.getStartPosition());
                    }
                    eagerImportingStrategy.integrateChild(child);
                    if (child.getContext().getDeferredTokens().isEmpty() || output == null) {
                        String string = "";
                        return string;
                    }
                    String string = EagerReconstructionUtils.wrapInTag(EagerReconstructionUtils.wrapPathAroundText(eagerImportingStrategy.getFinalOutput(output, child), templateFile, interpreter), "do", interpreter, true);
                    return string;
                }
                catch (IOException e) {
                    throw new InterpretException(e.getMessage(), (Throwable)e, tagToken.getLineNumber(), tagToken.getStartPosition());
                }
            });
            if (templateFileResult != null) {
                ((AutoCloseableSupplier.AutoCloseableImpl)templateFileResult).close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (templateFileResult != null) {
                    try {
                        ((AutoCloseableSupplier.AutoCloseableImpl)templateFileResult).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (DeferredValueException e) {
                return eagerImportingStrategy.handleDeferredTemplateFile(e);
            }
        }
    }
}

