/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag.eager;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import com.hubspot.algebra.Result;
import com.hubspot.jinjava.interpret.AutoCloseableSupplier;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TagCycleException;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.interpret.errorcategory.BasicTemplateErrorCategory;
import com.hubspot.jinjava.lib.fn.eager.EagerMacroFunction;
import com.hubspot.jinjava.lib.tag.FromTag;
import com.hubspot.jinjava.lib.tag.eager.DeferredToken;
import com.hubspot.jinjava.lib.tag.eager.EagerStateChangingTag;
import com.hubspot.jinjava.lib.tag.eager.importing.EagerImportingStrategyFactory;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.parse.TagToken;
import com.hubspot.jinjava.util.EagerReconstructionUtils;
import com.hubspot.jinjava.util.PrefixToPreserveState;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Beta
public class EagerFromTag
extends EagerStateChangingTag<FromTag> {
    public EagerFromTag() {
        super(new FromTag());
    }

    public EagerFromTag(FromTag fromTag) {
        super(fromTag);
    }

    @Override
    public String getEagerTagImage(TagToken tagToken, JinjavaInterpreter interpreter) {
        AutoCloseableSupplier<Result<String, TagCycleException>> maybeTemplateFileSupplier;
        String initialPathSetter = EagerImportingStrategyFactory.getSetTagForCurrentPath(interpreter);
        List<String> helper = FromTag.getHelpers(tagToken);
        Map<String, String> imports = FromTag.getImportMap(helper);
        try {
            maybeTemplateFileSupplier = FromTag.getTemplateFileWithWrapper(helper, tagToken, interpreter);
        }
        catch (DeferredValueException e) {
            imports.values().forEach(value -> {
                EagerMacroFunction deferredMacro = new EagerMacroFunction(null, (String)value, null, false, null, tagToken.getLineNumber(), tagToken.getStartPosition());
                deferredMacro.setDeferred(true);
                interpreter.getContext().addGlobalMacro(deferredMacro);
            });
            return initialPathSetter + String.valueOf((Object)new PrefixToPreserveState(EagerReconstructionUtils.handleDeferredTokenAndReconstructReferences(interpreter, DeferredToken.builderFromToken(tagToken).addUsedDeferredWords(Stream.of(helper.get(0))).addUsedDeferredWords(imports.keySet()).addSetDeferredWords(imports.values()).build()))) + tagToken.getImage();
        }
        try (Object maybeTemplateFile = maybeTemplateFileSupplier.get();){
            String string = (String)((Result)((AutoCloseableSupplier.AutoCloseableImpl)maybeTemplateFile).value()).match(err -> {
                interpreter.addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.EXCEPTION, TemplateError.ErrorItem.TAG, "From cycle detected for path: '" + err.getPath() + "'", null, tagToken.getLineNumber(), tagToken.getStartPosition(), (Exception)err, BasicTemplateErrorCategory.FROM_CYCLE_DETECTED, (Map<String, String>)ImmutableMap.of((Object)"path", (Object)err.getPath())));
                return "";
            }, templateFile -> {
                try {
                    Object output;
                    String template = interpreter.getResource((String)templateFile);
                    Node node = interpreter.parse(template);
                    JinjavaInterpreter child = interpreter.getConfig().getInterpreterFactory().newInstance(interpreter);
                    child.getContext().put("import_resource_path", templateFile);
                    try (Object a = JinjavaInterpreter.closeablePushCurrent(child).get();){
                        output = child.render(node);
                    }
                    interpreter.addAllChildErrors((String)templateFile, (Collection<TemplateError>)child.getErrorsCopy());
                    if (!child.getContext().getDeferredNodes().isEmpty()) {
                        FromTag.handleDeferredNodesDuringImport(tagToken, templateFile, imports, child, interpreter);
                    }
                    FromTag.integrateChild(imports, child, interpreter);
                    Map<String, String> newToOldImportNames = EagerFromTag.getNewToOldWithoutMacros(imports, interpreter);
                    if (child.getContext().getDeferredTokens().isEmpty() || output == null) {
                        return "";
                    }
                    if (newToOldImportNames.size() > 0) {
                        output = (String)output + EagerReconstructionUtils.buildSetTag(newToOldImportNames, interpreter, true);
                    }
                    return EagerReconstructionUtils.wrapInTag((String)output, "do", interpreter, true);
                }
                catch (IOException e) {
                    throw new InterpretException(e.getMessage(), (Throwable)e, tagToken.getLineNumber(), tagToken.getStartPosition());
                }
            });
            return string;
        }
    }

    private static Map<String, String> getNewToOldWithoutMacros(Map<String, String> oldToNewImportNames, JinjavaInterpreter interpreter) {
        return oldToNewImportNames.entrySet().stream().filter(e -> !((String)e.getKey()).equals(e.getValue())).filter(e -> interpreter.getContext().containsKey(e.getValue()) || !interpreter.getContext().isGlobalMacro((String)e.getValue())).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }
}

