/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag.eager;

import com.google.common.annotations.Beta;
import com.hubspot.jinjava.interpret.CannotReconstructValueException;
import com.hubspot.jinjava.interpret.Context;
import com.hubspot.jinjava.interpret.DeferredValue;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.tag.ForTag;
import com.hubspot.jinjava.lib.tag.eager.DeferredToken;
import com.hubspot.jinjava.lib.tag.eager.EagerExecutionResult;
import com.hubspot.jinjava.lib.tag.eager.EagerTagDecorator;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.tree.parse.TagToken;
import com.hubspot.jinjava.util.EagerContextWatcher;
import com.hubspot.jinjava.util.EagerExpressionResolver;
import com.hubspot.jinjava.util.EagerReconstructionUtils;
import com.hubspot.jinjava.util.LengthLimitingStringBuilder;
import com.hubspot.jinjava.util.LengthLimitingStringJoiner;
import com.hubspot.jinjava.util.PrefixToPreserveState;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

@Beta
public class EagerForTag
extends EagerTagDecorator<ForTag> {
    public EagerForTag() {
        super(new ForTag());
    }

    public EagerForTag(ForTag forTag) {
        super(forTag);
    }

    @Override
    public String innerInterpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        Pair<List<String>, String> loopVarsAndExpression = ((ForTag)this.getTag()).getLoopVarsAndExpression((TagToken)tagNode.getMaster());
        EagerExecutionResult collectionResult = EagerContextWatcher.executeInChildContext(eagerInterpreter -> EagerExpressionResolver.resolveExpression("[" + (String)loopVarsAndExpression.getRight() + "]", interpreter), interpreter, EagerContextWatcher.EagerChildContextConfig.newBuilder().withCheckForContextChanges(!interpreter.getContext().isDeferredExecutionMode()).build());
        if (collectionResult.getResult().isFullyResolved()) {
            HashSet<DeferredToken> addedTokens = new HashSet<DeferredToken>();
            EagerExecutionResult result = EagerContextWatcher.executeInChildContext(eagerInterpreter -> {
                EagerExpressionResolver.EagerExpressionResult expressionResult = EagerExpressionResolver.EagerExpressionResult.fromSupplier(() -> {
                    try {
                        interpreter.getContext().addNonMetaContextVariables((Collection)loopVarsAndExpression.getLeft());
                        String string = ((ForTag)this.getTag()).renderForCollection(tagNode, (JinjavaInterpreter)eagerInterpreter, (List)loopVarsAndExpression.getLeft(), !collectionResult.getResult().toList().isEmpty() ? collectionResult.getResult().toList().get(0) : Collections.emptyList());
                        return string;
                    }
                    finally {
                        interpreter.getContext().removeNonMetaContextVariables((Collection)loopVarsAndExpression.getLeft());
                    }
                }, eagerInterpreter);
                addedTokens.addAll(eagerInterpreter.getContext().getDeferredTokens());
                return expressionResult;
            }, interpreter, EagerContextWatcher.EagerChildContextConfig.newBuilder().build());
            if (result.getResult().getResolutionState() == EagerExpressionResolver.EagerExpressionResult.ResolutionState.NONE) {
                EagerReconstructionUtils.resetSpeculativeBindings(interpreter, collectionResult);
                EagerReconstructionUtils.resetSpeculativeBindings(interpreter, result);
                interpreter.getContext().removeDeferredTokens(addedTokens);
                throw new DeferredValueException(result.getResult().toString(true));
            }
            if (result.getResult().isFullyResolved()) {
                return result.getResult().toString(true);
            }
            return String.valueOf((Object)result.getPrefixToPreserveState().withAllInFront((Map<String, String>)((Object)collectionResult.getPrefixToPreserveState()))) + EagerReconstructionUtils.wrapInChildScope(result.getResult().toString(true), interpreter);
        }
        EagerReconstructionUtils.resetSpeculativeBindings(interpreter, collectionResult);
        throw new DeferredValueException(collectionResult.getResult().toString(true));
    }

    @Override
    public String eagerInterpret(TagNode tagNode, JinjavaInterpreter interpreter, InterpretException e) {
        if (e instanceof CannotReconstructValueException) {
            throw e;
        }
        LengthLimitingStringBuilder result = new LengthLimitingStringBuilder(interpreter.getConfig().getMaxOutputSize());
        try (Context.TemporaryValueClosable<Boolean> c = interpreter.getContext().withDeferLargeObjects("Loop too large".equals(e.getMessage()) || interpreter.getContext().isDeferLargeObjects());){
            result.append(EagerContextWatcher.executeInChildContext(eagerInterpreter -> EagerExpressionResolver.EagerExpressionResult.fromString(this.getEagerImage(this.buildToken(tagNode, e, interpreter.getLineNumber(), interpreter.getPosition()), (JinjavaInterpreter)eagerInterpreter)), interpreter, EagerContextWatcher.EagerChildContextConfig.newBuilder().build()).asTemplateString());
        }
        EagerExecutionResult firstRunResult = this.runLoopOnce(tagNode, interpreter, true);
        PrefixToPreserveState prefixToPreserveState = firstRunResult.getPrefixToPreserveState().withAllInFront((Map<String, String>)((Object)EagerReconstructionUtils.resetAndDeferSpeculativeBindings(interpreter, firstRunResult)));
        EagerExecutionResult secondRunResult = this.runLoopOnce(tagNode, interpreter, false);
        if (secondRunResult.getSpeculativeBindings().keySet().stream().anyMatch(key -> !firstRunResult.getSpeculativeBindings().containsKey(key))) {
            throw new DeferredValueException("Modified values in deferred for loop: " + String.join((CharSequence)", ", secondRunResult.getSpeculativeBindings().keySet()));
        }
        result.append(secondRunResult.asTemplateString());
        result.append(EagerReconstructionUtils.reconstructEnd(tagNode));
        return prefixToPreserveState.toString() + String.valueOf(result);
    }

    private EagerExecutionResult runLoopOnce(TagNode tagNode, JinjavaInterpreter interpreter, boolean clearDeferredWords) {
        return EagerContextWatcher.executeInChildContext(eagerInterpreter -> {
            if (!(eagerInterpreter.getContext().get("loop") instanceof DeferredValue)) {
                eagerInterpreter.getContext().put("loop", DeferredValue.instance());
            }
            List loopVars = (List)((ForTag)this.getTag()).getLoopVarsAndExpression((TagToken)tagNode.getMaster()).getLeft();
            interpreter.getContext().addNonMetaContextVariables(loopVars);
            loopVars.forEach(var -> interpreter.getContext().put(var, DeferredValue.instance()));
            try {
                EagerExpressionResolver.EagerExpressionResult eagerExpressionResult = EagerExpressionResolver.EagerExpressionResult.fromString(this.renderChildren(tagNode, (JinjavaInterpreter)eagerInterpreter));
                return eagerExpressionResult;
            }
            finally {
                interpreter.getContext().removeNonMetaContextVariables(loopVars);
                if (clearDeferredWords) {
                    interpreter.getContext().removeDeferredTokens(interpreter.getContext().getDeferredTokens());
                }
            }
        }, interpreter, EagerContextWatcher.EagerChildContextConfig.newBuilder().withForceDeferredExecutionMode(true).build());
    }

    @Override
    public String getEagerTagImage(TagToken tagToken, JinjavaInterpreter interpreter) {
        Pair<List<String>, String> loopVarsAndExpression = ((ForTag)this.getTag()).getLoopVarsAndExpression(tagToken);
        List loopVars = (List)loopVarsAndExpression.getLeft();
        String loopExpression = (String)loopVarsAndExpression.getRight();
        EagerExpressionResolver.EagerExpressionResult eagerExpressionResult = EagerExpressionResolver.resolveExpression(loopExpression, interpreter);
        LengthLimitingStringJoiner joiner = new LengthLimitingStringJoiner(interpreter.getConfig().getMaxOutputSize(), " ");
        joiner.add(tagToken.getSymbols().getExpressionStartWithTag()).add(tagToken.getTagName()).add(String.join((CharSequence)", ", loopVars)).add("in").add(eagerExpressionResult.toString()).add(tagToken.getSymbols().getExpressionEndWithTag());
        PrefixToPreserveState prefixToPreserveState = EagerReconstructionUtils.hydrateReconstructionFromContextBeforeDeferring(new PrefixToPreserveState(), eagerExpressionResult.getDeferredWords(), interpreter);
        prefixToPreserveState.withAllInFront(EagerReconstructionUtils.handleDeferredTokenAndReconstructReferences(interpreter, DeferredToken.builderFromImage(joiner.toString(), tagToken).addUsedDeferredWords(eagerExpressionResult.getDeferredWords()).build()));
        return String.valueOf((Object)prefixToPreserveState) + joiner.toString();
    }
}

