/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.doc.annotations.JinjavaTextMateSnippet;
import com.hubspot.jinjava.interpret.DeferredValue;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.tag.FlexibleTag;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.objects.Namespace;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.tree.parse.TagToken;
import com.hubspot.jinjava.util.DeferredValueUtils;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@JinjavaDoc(value="Assigns the value or result of a statement to a variable", params={@JinjavaParam(value="var", type="variable identifier", desc="The name of the variable"), @JinjavaParam(value="expr", type="expression", desc="The value stored in the variable (string, number, boolean, or sequence")}, snippets={@JinjavaSnippet(desc="Set a variable in with a set statement and print the variable in a expression", code="{% set primaryColor = \"#F7761F\" %}\n{{ primaryColor }}\n"), @JinjavaSnippet(desc="You can combine multiple values or variables into a sequence variable", code="{% set var_one = \"String 1\" %}\n{% set var_two = \"String 2\" %}\n{% set sequence = [var_one,  var_two] %}"), @JinjavaSnippet(desc="You can set a value to the string value within a block", code="{% set name = 'Jack' %}\n{% set message %}\nMy name is {{ name }}\n{% endset %}")})
@JinjavaTextMateSnippet(code="{% set ${1:var} = ${2:expr} %}")
public class SetTag
implements Tag,
FlexibleTag {
    public static final String TAG_NAME = "set";
    public static final String IGNORED_VARIABLE_NAME = "__ignored__";
    private static final long serialVersionUID = -8558479410226781539L;

    @Override
    public String getName() {
        return TAG_NAME;
    }

    @Override
    public String interpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        if (!tagNode.getHelpers().contains("=")) {
            return this.interpretBlockSet(tagNode, interpreter);
        }
        int eqPos = tagNode.getHelpers().indexOf(61);
        String var = tagNode.getHelpers().substring(0, eqPos).trim();
        String expr = tagNode.getHelpers().substring(eqPos + 1);
        if (var.length() == 0) {
            throw new TemplateSyntaxException(tagNode.getMaster().getImage(), "Tag 'set' requires a var name to assign to", tagNode.getLineNumber(), tagNode.getStartPosition());
        }
        if (StringUtils.isBlank((CharSequence)expr)) {
            throw new TemplateSyntaxException(tagNode.getMaster().getImage(), "Tag 'set' requires an expression to assign to a var", tagNode.getLineNumber(), tagNode.getStartPosition());
        }
        String[] varTokens = var.split(",");
        try {
            List exprVals = (List)interpreter.resolveELExpression("[" + expr + "]", tagNode.getMaster().getLineNumber());
            this.executeSet((TagToken)tagNode.getMaster(), interpreter, varTokens, exprVals, false);
        }
        catch (DeferredValueException e) {
            DeferredValueUtils.deferVariables(varTokens, interpreter.getContext());
            throw e;
        }
        return "";
    }

    private String interpretBlockSet(TagNode tagNode, JinjavaInterpreter interpreter) {
        int filterPos = tagNode.getHelpers().indexOf(124);
        String var = tagNode.getHelpers().trim();
        if (filterPos >= 0) {
            var = tagNode.getHelpers().substring(0, filterPos).trim();
        }
        String result = SetTag.renderChildren(tagNode, interpreter, var);
        try {
            this.executeSetBlock(tagNode, var, result, filterPos >= 0, interpreter);
        }
        catch (DeferredValueException e) {
            DeferredValueUtils.deferVariables(new String[]{var}, interpreter.getContext());
            throw e;
        }
        return "";
    }

    public static String renderChildren(TagNode tagNode, JinjavaInterpreter interpreter, String var) {
        String result;
        if (IGNORED_VARIABLE_NAME.equals(var)) {
            result = SetTag.renderChildren(tagNode, interpreter);
        } else {
            try (JinjavaInterpreter.InterpreterScopeClosable c = interpreter.enterScope();){
                result = SetTag.renderChildren(tagNode, interpreter);
            }
        }
        return result;
    }

    private static String renderChildren(TagNode tagNode, JinjavaInterpreter interpreter) {
        StringBuilder sb = new StringBuilder();
        for (Node child : tagNode.getChildren()) {
            sb.append(child.render(interpreter));
        }
        String result = sb.toString();
        return result;
    }

    private void executeSetBlock(TagNode tagNode, String var, String resolvedBlock, boolean hasFilterOp, JinjavaInterpreter interpreter) {
        String[] varAsArray = new String[]{var};
        this.executeSet((TagToken)tagNode.getMaster(), interpreter, varAsArray, Collections.singletonList(resolvedBlock), false);
        if (hasFilterOp) {
            Object finalVal = interpreter.resolveELExpression(tagNode.getHelpers().trim(), tagNode.getMaster().getLineNumber());
            this.executeSet((TagToken)tagNode.getMaster(), interpreter, varAsArray, Collections.singletonList(finalVal), false);
        }
    }

    public void executeSet(TagToken tagToken, JinjavaInterpreter interpreter, String[] varTokens, List<?> resolvedList, boolean allowDeferredValueOverride) {
        if (varTokens.length > 1) {
            if (resolvedList == null || varTokens.length != resolvedList.size()) {
                throw new TemplateSyntaxException(tagToken.getImage(), "Tag 'set' declares an uneven number of variables and assigned values", tagToken.getLineNumber(), tagToken.getStartPosition());
            }
            for (int i = 0; i < varTokens.length; ++i) {
                String varItem = varTokens[i].trim();
                if (interpreter.getContext().containsKey(varItem) && !allowDeferredValueOverride && interpreter.getContext().get(varItem) instanceof DeferredValue) {
                    throw new DeferredValueException(varItem);
                }
                interpreter.getContext().put(varItem, resolvedList.get(i));
            }
        } else {
            if (interpreter.getContext().containsKey(varTokens[0]) && !allowDeferredValueOverride && interpreter.getContext().get(varTokens[0]) instanceof DeferredValue) {
                throw new DeferredValueException(varTokens[0]);
            }
            this.setVariable(interpreter, varTokens[0], resolvedList != null && resolvedList.size() > 0 ? resolvedList.get(0) : null);
        }
    }

    private void setVariable(JinjavaInterpreter interpreter, String var, Object value) {
        if (var.contains(".")) {
            String[] varArray = var.split("\\.", 2);
            Object namespace = interpreter.getContext().get(varArray[0]);
            if (namespace instanceof Namespace) {
                ((Namespace)namespace).put(varArray[1], value);
                return;
            }
            if (namespace instanceof DeferredValue) {
                throw new DeferredValueException("Deferred Namespace");
            }
        }
        if (!IGNORED_VARIABLE_NAME.equals(var)) {
            interpreter.getContext().put(var, value);
        }
    }

    @Override
    public String getEndTagName() {
        return "endset";
    }

    @Override
    public boolean hasEndTag(TagToken tagToken) {
        return !tagToken.getHelpers().contains("=");
    }
}

