/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag;

import com.google.common.collect.ImmutableMap;
import com.hubspot.algebra.Result;
import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.doc.annotations.JinjavaTextMateSnippet;
import com.hubspot.jinjava.interpret.AutoCloseableSupplier;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.interpret.errorcategory.BasicTemplateErrorCategory;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.util.HelperStringTokenizer;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@JinjavaDoc(value="includes multiple files in one template or stylesheet", params={@JinjavaParam(value="path", desc="Design Manager path to the file that you would like to include")}, snippets={@JinjavaSnippet(code="{% include \"custom/page/web_page_basic/my_footer.html\" %}"), @JinjavaSnippet(code="{% include \"generated_global_groups/2781996615.html\" %}"), @JinjavaSnippet(code="{% include \"hubspot/styles/patches/recommended.css\" %}")})
@JinjavaTextMateSnippet(code="{% include '${1:path}' %}")
public class IncludeTag
implements Tag {
    public static final String TAG_NAME = "include";
    private static final long serialVersionUID = -8391753639874726854L;

    @Override
    public String interpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        HelperStringTokenizer helper = new HelperStringTokenizer(tagNode.getHelpers());
        if (!helper.hasNext()) {
            throw new TemplateSyntaxException(tagNode.getMaster().getImage(), "Tag 'include' expects template path", tagNode.getLineNumber(), tagNode.getStartPosition());
        }
        String path = StringUtils.trimToEmpty((String)((String)helper.next()));
        String templateFile = interpreter.resolveString(path, tagNode.getLineNumber(), tagNode.getStartPosition());
        String finalTemplateFile = templateFile = interpreter.resolveResourceLocation(templateFile);
        TagNode finalTagNode = tagNode;
        try (Object includeStackWrapper = interpreter.getContext().getIncludePathStack().closeablePush(finalTemplateFile, tagNode.getLineNumber(), tagNode.getStartPosition()).get();){
            Object currentPathWrapper = interpreter.getContext().getCurrentPathStack().closeablePush(finalTemplateFile, interpreter.getLineNumber(), interpreter.getPosition()).get();
            try {
                String string = (String)((Result)((AutoCloseableSupplier.AutoCloseableImpl)includeStackWrapper).value()).match(err -> {
                    interpreter.addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.EXCEPTION, TemplateError.ErrorItem.TAG, "Include cycle detected for path: '" + finalTemplateFile + "'", null, finalTagNode.getLineNumber(), finalTagNode.getStartPosition(), (Exception)err, BasicTemplateErrorCategory.INCLUDE_CYCLE_DETECTED, (Map<String, String>)ImmutableMap.of((Object)"path", (Object)finalTemplateFile)));
                    return "";
                }, arg_0 -> IncludeTag.lambda$interpret$3((AutoCloseableSupplier.AutoCloseableImpl)currentPathWrapper, interpreter, finalTemplateFile, finalTagNode, arg_0));
                if (currentPathWrapper != null) {
                    ((AutoCloseableSupplier.AutoCloseableImpl)currentPathWrapper).close();
                }
                return string;
            }
            catch (Throwable throwable) {
                if (currentPathWrapper != null) {
                    try {
                        ((AutoCloseableSupplier.AutoCloseableImpl)currentPathWrapper).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    @Override
    public String getEndTagName() {
        return null;
    }

    @Override
    public String getName() {
        return TAG_NAME;
    }

    private static /* synthetic */ String lambda$interpret$3(AutoCloseableSupplier.AutoCloseableImpl currentPathWrapper, JinjavaInterpreter interpreter, String finalTemplateFile, TagNode finalTagNode, String includeStackPath) {
        return (String)((Result)currentPathWrapper.value()).match(err -> {
            interpreter.addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.EXCEPTION, TemplateError.ErrorItem.TAG, "Include cycle detected for path: '" + finalTemplateFile + "'", null, finalTagNode.getLineNumber(), finalTagNode.getStartPosition(), (Exception)err, BasicTemplateErrorCategory.INCLUDE_CYCLE_DETECTED, (Map<String, String>)ImmutableMap.of((Object)"path", (Object)finalTemplateFile)));
            return "";
        }, currentPath -> {
            try {
                String template = interpreter.getResource(finalTemplateFile);
                Node node = interpreter.parse(template);
                interpreter.getContext().addDependency("coded_files", finalTemplateFile);
                return interpreter.render(node, false);
            }
            catch (IOException e) {
                throw new InterpretException(e.getMessage(), (Throwable)e, finalTagNode.getLineNumber(), finalTagNode.getStartPosition());
            }
        });
    }
}

