/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag;

import com.google.common.collect.ImmutableMap;
import com.hubspot.algebra.Result;
import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.doc.annotations.JinjavaTextMateSnippet;
import com.hubspot.jinjava.interpret.AutoCloseableSupplier;
import com.hubspot.jinjava.interpret.DeferredValue;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TagCycleException;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.interpret.errorcategory.BasicTemplateErrorCategory;
import com.hubspot.jinjava.lib.fn.MacroFunction;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.tree.parse.TagToken;
import com.hubspot.jinjava.util.HelperStringTokenizer;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@JinjavaDoc(value="Allows you to access and use macros from a different template", params={@JinjavaParam(value="path", desc="Design Manager path to file to import"), @JinjavaParam(value="import_name", desc="Give a name to the imported file to access macros from")}, snippets={@JinjavaSnippet(desc="This example uses an html file containing two macros.", code="{% macro header(tag, title_text) %}\n<header> <{{ tag }}>{{ title_text }} </{{tag}}> </header>\n{% endmacro %}\n{% macro footer(tag, footer_text) %}\n<footer> <{{ tag }}>{{ footer_text }} </{{tag}}> </footer>\n{% endmacro %}"), @JinjavaSnippet(desc="The macro html file is imported from a different template. Macros are then accessed from the name given to the import.", code="{% import 'custom/page/web_page_basic/my_macros.html' as header_footer %}\n{{ header_footer.header('h1', 'My page title') }}\n{{ header_footer.footer('h3', 'Company footer info') }}")})
@JinjavaTextMateSnippet(code="{% import '${1:path}' ${2: as ${3:import_name}} %}")
public class ImportTag
implements Tag {
    public static final String TAG_NAME = "import";
    private static final long serialVersionUID = 8433638845398005260L;

    @Override
    public String getName() {
        return TAG_NAME;
    }

    @Override
    public String interpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        List<String> helper = ImportTag.getHelpers((TagToken)tagNode.getMaster());
        String contextVar = ImportTag.getContextVar(helper);
        try (Object templateFileResult = ImportTag.getTemplateFileWithWrapper(helper, (TagToken)tagNode.getMaster(), interpreter).get();){
            String string = (String)((Result)((AutoCloseableSupplier.AutoCloseableImpl)templateFileResult).value()).match(err -> {
                String path = StringUtils.trimToEmpty((String)((String)helper.get(0)));
                interpreter.addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.EXCEPTION, TemplateError.ErrorItem.TAG, "Import cycle detected for path: '" + path + "'", null, ((TagToken)tagNode.getMaster()).getLineNumber(), ((TagToken)tagNode.getMaster()).getStartPosition(), (Exception)err, BasicTemplateErrorCategory.IMPORT_CYCLE_DETECTED, (Map<String, String>)ImmutableMap.of((Object)"path", (Object)path)));
                return "";
            }, templateFile -> {
                Object node = ImportTag.parseTemplateAsNode(interpreter, templateFile).get();
                try {
                    JinjavaInterpreter child = interpreter.getConfig().getInterpreterFactory().newInstance(interpreter);
                    child.getContext().put("import_resource_path", templateFile);
                    try (Object a = JinjavaInterpreter.closeablePushCurrent(child).get();){
                        child.render((Node)((AutoCloseableSupplier.AutoCloseableImpl)node).value());
                    }
                    interpreter.addAllChildErrors((String)templateFile, (Collection<TemplateError>)child.getErrorsCopy());
                    Map<String, Object> childBindings = child.getContext().getSessionBindings();
                    if (!child.getContext().getDeferredNodes().isEmpty()) {
                        ImportTag.handleDeferredNodesDuringImport((Node)((AutoCloseableSupplier.AutoCloseableImpl)node).value(), contextVar, childBindings, child, interpreter);
                        throw new DeferredValueException((String)templateFile, tagNode.getLineNumber(), tagNode.getStartPosition());
                    }
                    ImportTag.integrateChild(contextVar, childBindings, child, interpreter);
                    String string = "";
                    if (node != null) {
                        ((AutoCloseableSupplier.AutoCloseableImpl)node).close();
                    }
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        if (node != null) {
                            try {
                                ((AutoCloseableSupplier.AutoCloseableImpl)node).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new InterpretException(e.getMessage(), (Throwable)e, tagNode.getLineNumber(), tagNode.getStartPosition());
                    }
                }
            });
            return string;
        }
    }

    public static void integrateChild(String contextVar, Map<String, Object> childBindings, JinjavaInterpreter child, JinjavaInterpreter parent) {
        if (StringUtils.isBlank((CharSequence)contextVar)) {
            for (MacroFunction macro : child.getContext().getGlobalMacros().values()) {
                parent.getContext().addGlobalMacro(macro);
            }
            childBindings.remove("__macros__");
            parent.getContext().putAll(ImportTag.getChildBindingsWithoutImportResourcePath(childBindings));
        } else {
            childBindings.putAll(child.getContext().getGlobalMacros());
            childBindings.remove("__macros__");
            parent.getContext().put(contextVar, childBindings);
        }
    }

    public static Map<String, Object> getChildBindingsWithoutImportResourcePath(Map<String, Object> childBindings) {
        HashMap<String, Object> filteredMap = new HashMap<String, Object>();
        childBindings.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("import_resource_path")).forEach(entry -> filteredMap.put((String)entry.getKey(), entry.getValue()));
        return filteredMap;
    }

    public static void handleDeferredNodesDuringImport(Node node, String contextVar, Map<String, Object> childBindings, JinjavaInterpreter child, JinjavaInterpreter interpreter) {
        node.getChildren().forEach(deferredChild -> interpreter.getContext().handleDeferredNode((Node)deferredChild));
        if (StringUtils.isBlank((CharSequence)contextVar)) {
            for (MacroFunction macro : child.getContext().getGlobalMacros().values()) {
                macro.setDeferred(true);
                interpreter.getContext().addGlobalMacro(macro);
            }
            childBindings.remove("__macros__");
            childBindings.keySet().forEach(key -> interpreter.getContext().put(key, DeferredValue.instance()));
        } else {
            for (Map.Entry<String, MacroFunction> macroEntry : child.getContext().getGlobalMacros().entrySet()) {
                MacroFunction macro = macroEntry.getValue();
                macro.setDeferred(true);
                childBindings.put(macroEntry.getKey(), macro);
            }
            childBindings.remove("__macros__");
            interpreter.getContext().put(contextVar, DeferredValue.instance(childBindings));
        }
    }

    public static AutoCloseableSupplier<Node> parseTemplateAsNode(JinjavaInterpreter interpreter, String templateFile) throws IOException {
        String template = interpreter.getResource(templateFile);
        return interpreter.getContext().getCurrentPathStack().closeablePush(templateFile, interpreter.getLineNumber(), interpreter.getPosition()).map(currentPath -> interpreter.parse(template));
    }

    public static AutoCloseableSupplier<Result<String, TagCycleException>> getTemplateFileWithWrapper(List<String> helper, TagToken tagToken, JinjavaInterpreter interpreter) {
        String path = StringUtils.trimToEmpty((String)helper.get(0));
        String templateFile = interpreter.resolveString(path, tagToken.getLineNumber(), tagToken.getStartPosition());
        templateFile = interpreter.resolveResourceLocation(templateFile);
        interpreter.getContext().addDependency("coded_files", templateFile);
        return interpreter.getContext().getImportPathStack().closeablePush(templateFile, tagToken.getLineNumber(), tagToken.getStartPosition());
    }

    @Deprecated
    public static Optional<String> getTemplateFile(List<String> helper, TagToken tagToken, JinjavaInterpreter interpreter) {
        return (Optional)ImportTag.getTemplateFileWithWrapper(helper, tagToken, interpreter).dangerouslyGetWithoutClosing().match(err -> {
            String path = StringUtils.trimToEmpty((String)((String)helper.get(0)));
            interpreter.addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.EXCEPTION, TemplateError.ErrorItem.TAG, "Import cycle detected for path: '" + path + "'", null, tagToken.getLineNumber(), tagToken.getStartPosition(), (Exception)err, BasicTemplateErrorCategory.IMPORT_CYCLE_DETECTED, (Map<String, String>)ImmutableMap.of((Object)"path", (Object)path)));
            return Optional.empty();
        }, ok -> Optional.of(ok));
    }

    public static String getContextVar(List<String> helper) {
        String contextVar = "";
        if (helper.size() > 2 && "as".equals(helper.get(1))) {
            contextVar = helper.get(2);
        }
        return contextVar;
    }

    public static List<String> getHelpers(TagToken tagToken) {
        List<String> helper = new HelperStringTokenizer(tagToken.getHelpers()).allTokens();
        if (helper.isEmpty()) {
            throw new TemplateSyntaxException(tagToken.getImage(), "Tag 'import' expects 1 helper, was: " + helper.size(), tagToken.getLineNumber(), tagToken.getStartPosition());
        }
        return helper;
    }

    @Override
    public String getEndTagName() {
        return null;
    }
}

