/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag;

import com.google.common.collect.Lists;
import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaHasCodeBody;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.doc.annotations.JinjavaTextMateSnippet;
import com.hubspot.jinjava.el.ext.DeferredParsingException;
import com.hubspot.jinjava.interpret.DeferredValue;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.NullValue;
import com.hubspot.jinjava.interpret.OutputTooBigException;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.objects.DummyObject;
import com.hubspot.jinjava.objects.collections.PyList;
import com.hubspot.jinjava.tree.ExpressionNode;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.tree.parse.TagToken;
import com.hubspot.jinjava.util.ForLoop;
import com.hubspot.jinjava.util.HelperStringTokenizer;
import com.hubspot.jinjava.util.LengthLimitingStringBuilder;
import com.hubspot.jinjava.util.ObjectIterator;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;

@JinjavaDoc(value="Outputs the inner content for each item in the given iterable", params={@JinjavaParam(value="items_to_iterate", desc="Specifies the name of a single item in the sequence or dict.")}, snippets={@JinjavaSnippet(code="{% for item in items %}\n    {{ item }}\n{% endfor %}"), @JinjavaSnippet(desc="Iterating over dictionary values", code="{% for value in dictionary %}\n    {{ value }}\n{% endfor %}"), @JinjavaSnippet(desc="Iterating over dictionary entries", code="{% for key, value in dictionary.items() %}\n    {{ key }}: {{ value }}\n{% endfor %}"), @JinjavaSnippet(desc="Standard blog listing loop", code="{% for content in contents %}\n    Post content variables\n{% endfor %}")})
@JinjavaHasCodeBody
@JinjavaTextMateSnippet(code="{% for ${1:items} in ${2:list} %}\n$0\n{% endfor %}")
public class ForTag
implements Tag {
    public static final String TAG_NAME = "for";
    public static final String LOOP = "loop";
    private static final long serialVersionUID = 6175143875754966497L;
    private static final Pattern IN_PATTERN = Pattern.compile("\\sin\\s");
    public static final String TOO_LARGE_EXCEPTION_MESSAGE = "Loop too large";

    @Override
    public boolean isRenderedInValidationMode() {
        return true;
    }

    @Override
    public String interpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        long numDeferredNodesBefore = interpreter.getContext().getDeferredNodes().stream().filter(n -> !(n instanceof ExpressionNode)).count();
        String result = this.interpretUnchecked(tagNode, interpreter);
        if (interpreter.getContext().getDeferredNodes().stream().filter(n -> !(n instanceof ExpressionNode)).count() > numDeferredNodesBefore) {
            throw new DeferredValueException("for loop", interpreter.getLineNumber(), interpreter.getPosition());
        }
        return result;
    }

    public String interpretUnchecked(TagNode tagNode, JinjavaInterpreter interpreter) {
        Object collection;
        Pair<List<String>, String> loopVarsAndExpression = this.getLoopVarsAndExpression((TagToken)tagNode.getMaster());
        List loopVars = (List)loopVarsAndExpression.getLeft();
        String loopExpression = (String)loopVarsAndExpression.getRight();
        try {
            collection = interpreter.resolveELExpression(loopExpression, tagNode.getLineNumber());
        }
        catch (DeferredParsingException e) {
            throw new DeferredParsingException(String.format("%s in %s", String.join((CharSequence)", ", loopVars), e.getDeferredEvalResult()));
        }
        return this.renderForCollection(tagNode, interpreter, loopVars, collection);
    }

    /*
     * WARNING - void declaration
     */
    public String renderForCollection(TagNode tagNode, JinjavaInterpreter interpreter, List<String> loopVars, Object collection) {
        ForLoop loop = ObjectIterator.getLoop(collection);
        JinjavaInterpreter.InterpreterScopeClosable c = interpreter.enterScope();
        try {
            if (interpreter.isValidationMode() && !loop.hasNext()) {
                loop = ObjectIterator.getLoop(new DummyObject());
                interpreter.getContext().setValidationMode(true);
            }
            interpreter.getContext().put(LOOP, loop);
            LengthLimitingStringBuilder buff = new LengthLimitingStringBuilder(interpreter.getConfig().getMaxOutputSize());
            while (loop.hasNext()) {
                Object val;
                try {
                    val = interpreter.wrap(loop.next());
                }
                catch (ConcurrentModificationException e) {
                    interpreter.addError(new TemplateError(TemplateError.ErrorType.FATAL, TemplateError.ErrorReason.SYNTAX_ERROR, TemplateError.ErrorItem.TAG, "Concurrent Modification Error: Cannot modify collection in 'for' loop", "", interpreter.getLineNumber(), interpreter.getPosition(), e));
                    break;
                }
                if (loopVars.size() == 1) {
                    if (val == null && interpreter.getContext().get(loopVars.get(0)) != null && interpreter.getConfig().getLegacyOverrides().isKeepNullableLoopValues()) {
                        interpreter.getContext().put(loopVars.get(0), NullValue.INSTANCE);
                    } else {
                        interpreter.getContext().put(loopVars.get(0), val);
                    }
                } else {
                    block13: for (int loopVarIndex = 0; loopVarIndex < loopVars.size(); ++loopVarIndex) {
                        String loopVar = loopVars.get(loopVarIndex);
                        if (val == null) {
                            if (interpreter.getContext().get(loopVar) != null && interpreter.getConfig().getLegacyOverrides().isKeepNullableLoopValues()) {
                                interpreter.getContext().put(loopVar, NullValue.INSTANCE);
                                continue;
                            }
                            interpreter.getContext().put(loopVar, null);
                            continue;
                        }
                        if (Map.Entry.class.isAssignableFrom(val.getClass())) {
                            void var12_22;
                            Map.Entry entry = (Map.Entry)val;
                            Object var12_19 = null;
                            if (loopVars.indexOf(loopVar) == 0) {
                                Object k = entry.getKey();
                            } else if (loopVars.indexOf(loopVar) == 1) {
                                Object v = entry.getValue();
                            }
                            interpreter.getContext().put(loopVar, var12_22);
                            continue;
                        }
                        if (List.class.isAssignableFrom(val.getClass())) {
                            void var12_25;
                            List<Object> entries = ((PyList)val).toList();
                            Object var12_23 = null;
                            if (entries.size() >= loopVarIndex) {
                                Object object = entries.get(loopVarIndex);
                            }
                            interpreter.getContext().put(loopVar, var12_25);
                            continue;
                        }
                        try {
                            PropertyDescriptor[] valProps;
                            for (PropertyDescriptor valProp : valProps = Introspector.getBeanInfo(val.getClass()).getPropertyDescriptors()) {
                                if (!loopVar.equals(valProp.getName())) continue;
                                interpreter.getContext().put(loopVar, valProp.getReadMethod().invoke(val, new Object[0]));
                                continue block13;
                            }
                            continue;
                        }
                        catch (Exception e) {
                            throw new InterpretException(e.getMessage(), (Throwable)e, tagNode.getLineNumber(), tagNode.getStartPosition());
                        }
                    }
                }
                for (Node node : tagNode.getChildren()) {
                    if (interpreter.getContext().isValidationMode()) {
                        node.render(interpreter);
                        continue;
                    }
                    try {
                        buff.append(node.render(interpreter));
                    }
                    catch (OutputTooBigException e) {
                        if (interpreter.getConfig().getExecutionMode().useEagerParser()) {
                            throw new DeferredValueException(TOO_LARGE_EXCEPTION_MESSAGE);
                        }
                        interpreter.addError(TemplateError.fromOutputTooBigException(e));
                        String string = this.checkLoopVariable(interpreter, buff);
                        if (c != null) {
                            c.close();
                        }
                        return string;
                    }
                    if (!loop.isContinued()) continue;
                    break;
                }
                if (interpreter.getConfig().getMaxNumDeferredTokens() >= loop.getLength() * interpreter.getContext().getDeferredTokens().size() / loop.getIndex()) continue;
                throw new DeferredValueException(TOO_LARGE_EXCEPTION_MESSAGE);
            }
            String string = this.checkLoopVariable(interpreter, buff);
            return string;
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private String checkLoopVariable(JinjavaInterpreter interpreter, LengthLimitingStringBuilder buff) {
        if (interpreter.getContext().get(LOOP) instanceof DeferredValue) {
            throw new DeferredValueException("loop variable deferred", interpreter.getLineNumber(), interpreter.getPosition());
        }
        return buff.toString();
    }

    public Pair<List<String>, String> getLoopVarsAndExpression(TagToken tagToken) {
        List<String> helperTokens = new HelperStringTokenizer(tagToken.getHelpers()).splitComma(true).allTokens();
        List<String> loopVars = this.getLoopVars(helperTokens);
        Optional<String> maybeLoopExpr = this.getLoopExpression(tagToken.getHelpers());
        if (loopVars.size() >= helperTokens.size() || !maybeLoopExpr.isPresent()) {
            throw new TemplateSyntaxException(tagToken.getHelpers().trim(), "Tag 'for' expects valid 'in' clause, got: " + tagToken.getHelpers(), tagToken.getLineNumber(), tagToken.getStartPosition());
        }
        return Pair.of(loopVars, (Object)maybeLoopExpr.get());
    }

    private Optional<String> getLoopExpression(String helpers) {
        Matcher matcher = IN_PATTERN.matcher(helpers);
        if (matcher.find()) {
            return Optional.of(helpers.substring(matcher.end()).trim());
        }
        return Optional.empty();
    }

    private List<String> getLoopVars(List<String> helper) {
        String val;
        ArrayList loopVars = Lists.newArrayList();
        while (loopVars.size() < helper.size() && !"in".equals(val = helper.get(loopVars.size()))) {
            loopVars.add(val);
        }
        return loopVars;
    }

    @Override
    public String getName() {
        return TAG_NAME;
    }
}

