/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.fn.eager;

import com.google.common.annotations.Beta;
import com.hubspot.jinjava.el.ext.AstMacroFunction;
import com.hubspot.jinjava.el.ext.DeferredInvocationResolutionException;
import com.hubspot.jinjava.el.ext.eager.MacroFunctionTempVariable;
import com.hubspot.jinjava.interpret.AutoCloseableSupplier;
import com.hubspot.jinjava.interpret.Context;
import com.hubspot.jinjava.interpret.DeferredMacroValueImpl;
import com.hubspot.jinjava.interpret.DeferredValue;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.fn.MacroFunction;
import com.hubspot.jinjava.lib.tag.eager.EagerExecutionResult;
import com.hubspot.jinjava.objects.serialization.PyishObjectMapper;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.util.EagerContextWatcher;
import com.hubspot.jinjava.util.EagerExpressionResolver;
import com.hubspot.jinjava.util.EagerReconstructionUtils;
import com.hubspot.jinjava.util.PrefixToPreserveState;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@Beta
public class EagerMacroFunction
extends MacroFunction {
    private AtomicInteger callCount = new AtomicInteger();
    private AtomicBoolean reconstructing = new AtomicBoolean();

    public EagerMacroFunction(List<Node> content, String name, LinkedHashMap<String, Object> argNamesWithDefaults, boolean caller, Context localContextScope, int lineNumber, int startPosition) {
        super(content, name, argNamesWithDefaults, caller, localContextScope, lineNumber, startPosition);
    }

    EagerMacroFunction(MacroFunction source, String name) {
        super(source, name);
    }

    @Override
    public Object doEvaluate(Map<String, Object> argMap, Map<String, Object> kwargMap, List<Object> varArgs) {
        JinjavaInterpreter interpreter = JinjavaInterpreter.getCurrent();
        if (this.reconstructing.get()) {
            try (JinjavaInterpreter.InterpreterScopeClosable c = interpreter.enterScope();){
                Object importFile = this.getImportFileWithWrapper(interpreter).get();
                try {
                    EagerExecutionResult result = this.eagerEvaluateInDeferredExecutionMode(() -> this.getEvaluationResultDirectly(argMap, kwargMap, varArgs, interpreter), interpreter);
                    if (!result.getResult().isFullyResolved()) {
                        interpreter.getContext().removeDeferredTokens(interpreter.getContext().getDeferredTokens());
                        result = this.eagerEvaluateInDeferredExecutionMode(() -> this.getEvaluationResultDirectly(argMap, kwargMap, varArgs, interpreter), interpreter);
                    }
                    String string = result.asTemplateString();
                    if (importFile != null) {
                        ((AutoCloseableSupplier.AutoCloseableImpl)importFile).close();
                    }
                    return string;
                }
                catch (Throwable result) {
                    if (importFile != null) {
                        try {
                            ((AutoCloseableSupplier.AutoCloseableImpl)importFile).close();
                        }
                        catch (Throwable throwable) {
                            result.addSuppressed(throwable);
                        }
                    }
                    throw result;
                }
            }
        }
        int currentCallCount = this.callCount.getAndIncrement();
        EagerExecutionResult eagerExecutionResult = this.eagerEvaluate(() -> super.doEvaluate(argMap, kwargMap, varArgs).toString(), EagerContextWatcher.EagerChildContextConfig.newBuilder().withCheckForContextChanges(!interpreter.getContext().isDeferredExecutionMode()).withTakeNewValue(true).build(), interpreter);
        if (!(eagerExecutionResult.getResult().isFullyResolved() || interpreter.getContext().isPartialMacroEvaluation() && eagerExecutionResult.getSpeculativeBindings().isEmpty() && !interpreter.getContext().isDeferredExecutionMode())) {
            PrefixToPreserveState prefixToPreserveState = EagerReconstructionUtils.resetAndDeferSpeculativeBindings(interpreter, eagerExecutionResult);
            String tempVarName = MacroFunctionTempVariable.getVarName(this.getName(), this.hashCode(), currentCallCount);
            interpreter.getContext().getParent().put(tempVarName, new MacroFunctionTempVariable(String.valueOf((Object)prefixToPreserveState) + eagerExecutionResult.asTemplateString()));
            throw new DeferredInvocationResolutionException(tempVarName);
        }
        if (!eagerExecutionResult.getResult().isFullyResolved()) {
            return EagerReconstructionUtils.wrapInChildScope(eagerExecutionResult.getResult().toString(true), interpreter);
        }
        return eagerExecutionResult.getResult().toString(true);
    }

    private String getEvaluationResultDirectly(Map<String, Object> argMap, Map<String, Object> kwargMap, List<Object> varArgs, JinjavaInterpreter interpreter) {
        String evaluationResult = this.getEvaluationResult(argMap, kwargMap, varArgs, interpreter);
        interpreter.getContext().getScope().remove("kwargs");
        interpreter.getContext().getScope().remove("varargs");
        return evaluationResult;
    }

    private EagerExecutionResult eagerEvaluateInDeferredExecutionMode(Supplier<String> stringSupplier, JinjavaInterpreter interpreter) {
        return this.eagerEvaluate(stringSupplier, EagerContextWatcher.EagerChildContextConfig.newBuilder().withForceDeferredExecutionMode(true).withTakeNewValue(true).withCheckForContextChanges(true).build(), interpreter);
    }

    private EagerExecutionResult eagerEvaluate(Supplier<String> stringSupplier, EagerContextWatcher.EagerChildContextConfig eagerChildContextConfig, JinjavaInterpreter interpreter) {
        return EagerContextWatcher.executeInChildContext(eagerInterpreter -> EagerExpressionResolver.EagerExpressionResult.fromSupplier(stringSupplier, eagerInterpreter), interpreter, eagerChildContextConfig);
    }

    private String getStartTag(String fullName, JinjavaInterpreter interpreter) {
        StringJoiner argJoiner = new StringJoiner(", ");
        for (String arg : this.getArguments()) {
            if (this.getDefaults().get(arg) != null) {
                argJoiner.add(String.format("%s=%s", arg, PyishObjectMapper.getAsPyishString(this.getDefaults().get(arg))));
                continue;
            }
            argJoiner.add(arg);
        }
        return new StringJoiner(" ").add(interpreter.getConfig().getTokenScannerSymbols().getExpressionStartWithTag()).add("macro").add(String.format("%s(%s)", fullName, argJoiner.toString())).add(interpreter.getConfig().getTokenScannerSymbols().getExpressionEndWithTag()).toString();
    }

    private String getEndTag(JinjavaInterpreter interpreter) {
        return new StringJoiner(" ").add(interpreter.getConfig().getTokenScannerSymbols().getExpressionStartWithTag()).add(String.format("end%s", "macro")).add(interpreter.getConfig().getTokenScannerSymbols().getExpressionEndWithTag()).toString();
    }

    @Override
    public String reconstructImage() {
        return this.reconstructImage(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String reconstructImage(String fullName) {
        String prefix = "";
        StringBuilder result = new StringBuilder();
        String setTagForAliasedVariables = this.getSetTagForAliasedVariables(fullName);
        String suffix = "";
        JinjavaInterpreter interpreter = JinjavaInterpreter.getCurrent();
        Optional<String> importFile = Optional.ofNullable((String)this.localContextScope.get("import_resource_path"));
        Object currentDeferredImportResource = null;
        if (importFile.isPresent()) {
            currentDeferredImportResource = interpreter.getContext().get("deferred_import_resource_path");
            if (currentDeferredImportResource instanceof DeferredValue) {
                currentDeferredImportResource = ((DeferredValue)currentDeferredImportResource).getOriginalValue();
            }
            prefix = EagerReconstructionUtils.buildBlockOrInlineSetTag("deferred_import_resource_path", importFile.get(), interpreter);
            interpreter.getContext().put("deferred_import_resource_path", importFile.get());
            suffix = EagerReconstructionUtils.buildBlockOrInlineSetTag("deferred_import_resource_path", currentDeferredImportResource, interpreter);
        }
        if (interpreter.getContext().getMacroStack().contains(this.getName()) && !this.differentMacroWithSameNameExists(interpreter)) {
            return "";
        }
        try (AutoCloseableSupplier.AutoCloseableImpl<Boolean> shouldReconstruct = this.shouldDoReconstruction(fullName, interpreter);){
            if (!shouldReconstruct.value().booleanValue()) {
                String string = "";
                return string;
            }
            try (JinjavaInterpreter.InterpreterScopeClosable c = interpreter.enterScope();){
                this.reconstructing.set(true);
                String evaluation = (String)this.evaluate(this.getArguments().stream().map(arg -> DeferredMacroValueImpl.instance()).toArray());
                result.append(this.getStartTag(fullName, interpreter)).append(setTagForAliasedVariables).append(evaluation).append(this.getEndTag(interpreter));
            }
            catch (DeferredValueException e) {
                if (StringUtils.isNotEmpty((CharSequence)setTagForAliasedVariables)) {
                    throw new DeferredValueException("Aliased variables in not eagerly reconstructible macro function");
                }
                result.append(super.reconstructImage());
            }
            finally {
                this.reconstructing.set(false);
                interpreter.getContext().put("deferred_import_resource_path", currentDeferredImportResource);
            }
        }
        return prefix + String.valueOf(result) + suffix;
    }

    private AutoCloseableSupplier.AutoCloseableImpl<Boolean> shouldDoReconstruction(String fullName, JinjavaInterpreter interpreter) {
        return (this.isCaller() ? AutoCloseableSupplier.of(true) : AstMacroFunction.checkAndPushMacroStackWithWrapper(interpreter, fullName).map(result -> (Boolean)result.match(err -> false, ok -> true))).get();
    }

    private String getSetTagForAliasedVariables(String fullName) {
        int lastDotIdx = fullName.lastIndexOf(46);
        if (lastDotIdx > 0) {
            String aliasName = fullName.substring(0, lastDotIdx + 1);
            Map<String, String> namesToAlias = this.localContextScope.getCombinedScope().entrySet().stream().filter(entry -> entry.getValue() instanceof DeferredValue).map(Map.Entry::getKey).collect(Collectors.toMap(Function.identity(), name -> aliasName + name));
            return EagerReconstructionUtils.buildSetTag(namesToAlias, JinjavaInterpreter.getCurrent(), false);
        }
        return "";
    }

    private boolean differentMacroWithSameNameExists(JinjavaInterpreter interpreter) {
        Context context = interpreter.getContext();
        if (context.getParent() == null) {
            return false;
        }
        MacroFunction mostRecent = context.getGlobalMacro(this.getName());
        if (this != mostRecent) {
            return true;
        }
        while (!context.getGlobalMacros().containsKey(this.getName()) && context.getParent().getParent() != null) {
            context = context.getParent();
        }
        MacroFunction secondMostRecent = context.getParent().getGlobalMacro(this.getName());
        return secondMostRecent != null && secondMostRecent != this;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public EagerMacroFunction cloneWithNewName(String name) {
        return new EagerMacroFunction(this, name);
    }
}

