/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.googlecode.ipv6.IPv6Network;
import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.interpret.InvalidArgumentException;
import com.hubspot.jinjava.interpret.InvalidReason;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.Importable;
import com.hubspot.jinjava.lib.filter.Filter;
import com.hubspot.jinjava.util.ForLoop;
import com.hubspot.jinjava.util.ObjectIterator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.util.SubnetUtils;

@JinjavaDoc(value="Evaluates to true if the value is a valid IPv4 or IPv6 address", input={@JinjavaParam(value="value", type="string", desc="String to check IP Address", required=true)}, params={@JinjavaParam(value="function", type="string", defaultValue="prefix", desc="Name of function. Supported functions: 'prefix', 'netmask', 'network', 'address', 'broadcast'")}, snippets={@JinjavaSnippet(desc="This example shows how to test if a string is a valid ip address", code="{% set ip = '1.0.0.1' %}\n{% if ip|ipaddr %}\n    The string is a valid IP address\n{% endif %}"), @JinjavaSnippet(desc="This example shows how to filter list of ip addresses", code="{{ ['192.108.0.1', null, True, 13, '2000::'] | ipaddr }}", output="['192.108.0.1', '2000::']")})
public class IpAddrFilter
implements Filter {
    private static final Pattern IP4_PATTERN = Pattern.compile("(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])");
    private static final Pattern IP6_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IP6_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");
    private static final Splitter PREFIX_SPLITTER = Splitter.on((char)'/');
    private static final String PREFIX_STRING = "prefix";
    private static final String NETMASK_STRING = "netmask";
    private static final String ADDRESS_STRING = "address";
    private static final String BROADCAST_STRING = "broadcast";
    private static final String NETWORK_STRING = "network";
    private static final String GATEWAY_STRING = "gateway";
    private static final String PUBLIC_STRING = "public";
    private static final String PRIVATE_STRING = "private";
    private static final String AVAILABLE_FUNCTIONS = Joiner.on((String)", ").join((Object)"prefix", (Object)"netmask", new Object[]{"address", "broadcast", "network", "gateway", "public", "private"});

    @Override
    public Object filter(Object object, JinjavaInterpreter interpreter, String ... args) {
        if (object == null) {
            return false;
        }
        String parameter = this.getParameter(args);
        if (object instanceof Map) {
            return this.getMapOfFilteredItems(interpreter, parameter, object);
        }
        if (object instanceof Iterable) {
            return this.getFilteredItems(interpreter, parameter, object);
        }
        if (object instanceof String) {
            return this.getValue(interpreter, object, parameter);
        }
        return false;
    }

    private String getParameter(String ... args) {
        if (args.length > 0) {
            return args[0].trim();
        }
        return null;
    }

    private Object getMapOfFilteredItems(JinjavaInterpreter interpreter, String parameter, Object map) {
        Iterator iterator = ((Map)map).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item = iterator.next();
            String filteredItem = this.filterItem(interpreter, parameter, item.getValue());
            if (filteredItem != null) {
                item.setValue(filteredItem);
                continue;
            }
            iterator.remove();
        }
        return map;
    }

    private List<String> getFilteredItems(JinjavaInterpreter interpreter, String parameter, Object object) {
        ArrayList<String> filteredItems = new ArrayList<String>();
        ForLoop loop = ObjectIterator.getLoop(object);
        while (loop.hasNext()) {
            String filteredItem = this.filterItem(interpreter, parameter, loop.next());
            if (filteredItem == null) continue;
            filteredItems.add(filteredItem);
        }
        return filteredItems;
    }

    private String filterItem(JinjavaInterpreter interpreter, String parameter, Object item) {
        Object value;
        try {
            value = this.getValue(interpreter, item, parameter);
        }
        catch (InvalidArgumentException exception) {
            return null;
        }
        if (value instanceof String || value instanceof Integer) {
            return String.valueOf(value);
        }
        if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
            return (String)item;
        }
        return null;
    }

    private Object getValue(JinjavaInterpreter interpreter, Object object, String parameter) {
        Integer prefix;
        if (!(object instanceof String)) {
            return null;
        }
        String fullAddress = ((String)object).trim();
        if (StringUtils.isEmpty((CharSequence)parameter)) {
            return this.validIp(fullAddress);
        }
        ArrayList<String> parts = PREFIX_SPLITTER.splitToList((CharSequence)fullAddress);
        if (parts.size() == 1 && (parameter.equalsIgnoreCase(PUBLIC_STRING) || parameter.equalsIgnoreCase(PRIVATE_STRING))) {
            parts = new ArrayList<String>(parts);
            parts.add("0");
        }
        if (parts.size() > 2) {
            return null;
        }
        String ipAddress = (String)parts.get(0);
        if (!this.validIp(ipAddress)) {
            return null;
        }
        if (parameter.equalsIgnoreCase(ADDRESS_STRING)) {
            return ipAddress;
        }
        if (parts.size() != 2) {
            return null;
        }
        String prefixString = (String)parts.get(1);
        try {
            prefix = Integer.parseInt(prefixString);
        }
        catch (NumberFormatException ex) {
            throw new InvalidArgumentException(interpreter, (Importable)this, InvalidReason.NUMBER_FORMAT, 0, prefixString);
        }
        boolean isv4 = IP4_PATTERN.matcher(ipAddress).matches();
        switch (parameter) {
            case "prefix": {
                return prefix;
            }
            case "netmask": {
                return isv4 ? this.getSubnetUtils(interpreter, fullAddress).getInfo().getNetmask() : this.getIpv6Network(interpreter, fullAddress).getNetmask().asAddress().toString();
            }
            case "broadcast": {
                return isv4 ? this.getSubnetUtils(interpreter, fullAddress).getInfo().getBroadcastAddress() : this.getIpv6Network(interpreter, fullAddress).getLast().toString();
            }
            case "network": {
                return isv4 ? this.getSubnetUtils(interpreter, fullAddress).getInfo().getNetworkAddress() : this.getIpv6Network(interpreter, fullAddress).toString().split("/")[0];
            }
            case "gateway": {
                return isv4 ? this.getSubnetUtils(interpreter, fullAddress).getInfo().getLowAddress() : this.getIpv6Network(interpreter, fullAddress).getFirst().add(1).toString();
            }
            case "public": {
                return !this.isIpAddressPrivate(this.getInetAddress(ipAddress), isv4);
            }
            case "private": {
                return this.isIpAddressPrivate(this.getInetAddress(ipAddress), isv4);
            }
        }
        throw new InvalidArgumentException(interpreter, (Importable)this, InvalidReason.ENUM, 1, parameter, AVAILABLE_FUNCTIONS);
    }

    private SubnetUtils getSubnetUtils(JinjavaInterpreter interpreter, String address) {
        try {
            return new SubnetUtils(address);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidArgumentException(interpreter, (Importable)this, InvalidReason.CIDR, 0, address);
        }
    }

    private IPv6Network getIpv6Network(JinjavaInterpreter interpreter, String address) {
        try {
            return IPv6Network.fromString((String)address);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidArgumentException(interpreter, this.getName(), e.getMessage());
        }
    }

    private InetAddress getInetAddress(String ipAddress) {
        try {
            return InetAddress.getByName(ipAddress);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    private boolean isIpAddressPrivate(InetAddress inetAddress, boolean isv4) {
        if (inetAddress == null) {
            return false;
        }
        return isv4 ? inetAddress.isSiteLocalAddress() : inetAddress.isSiteLocalAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isLoopbackAddress();
    }

    protected boolean validIp(String address) {
        return this.validIpv4(address) || this.validIpv6(address);
    }

    protected boolean validIpv4(String address) {
        return IP4_PATTERN.matcher(address).matches();
    }

    protected boolean validIpv6(String address) {
        return IP6_PATTERN.matcher(address).matches() || IP6_COMPRESSED_PATTERN.matcher(address).matches();
    }

    @Override
    public boolean preserveSafeString() {
        return false;
    }

    @Override
    public String getName() {
        return "ipaddr";
    }
}

