/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.lib.filter.Filter;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JinjavaDoc(value="Formats a given number based on the locale passed in as a parameter.", input={@JinjavaParam(value="value", desc="The number to be formatted based on locale", required=true)}, params={@JinjavaParam(value="locale", desc="Locale in which to format the number. The default is the page's locale."), @JinjavaParam(value="max decimal precision", type="number", desc="A number input that determines the decimal precision of the formatted value. If the number of decimal digits from the input value is less than the decimal precision number, use the number of decimal digits from the input value. Otherwise, use the decimal precision number. The default is the number of decimal digits from the input value.")}, snippets={@JinjavaSnippet(code="{{ number|format_number }}"), @JinjavaSnippet(code="{{ number|format_number(\"en-US\") }}"), @JinjavaSnippet(code="{{ number|format_number(\"en-US\", 3) }}")})
public class FormatNumberFilter
implements Filter {
    private static final String FORMAT_NUMBER_FILTER_NAME = "format_number";

    @Override
    public String getName() {
        return FORMAT_NUMBER_FILTER_NAME;
    }

    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, String ... args) {
        BigDecimal number;
        Locale locale = args.length > 0 && !Strings.isNullOrEmpty((String)args[0]) ? Locale.forLanguageTag(args[0]) : interpreter.getConfig().getLocale();
        try {
            number = this.parseInput(var);
        }
        catch (Exception e) {
            if (interpreter.getContext().isValidationMode()) {
                return "";
            }
            interpreter.addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.INVALID_INPUT, TemplateError.ErrorItem.FILTER, "Input value '" + String.valueOf(var) + "' could not be parsed.", null, interpreter.getLineNumber(), e, null, (Map<String, String>)ImmutableMap.of((Object)"value", (Object)Objects.toString(var))));
            return var;
        }
        Optional<Integer> maxDecimalPrecision = args.length > 1 ? Optional.of(Integer.parseInt(args[1])) : Optional.empty();
        return this.formatNumber(locale, number, maxDecimalPrecision);
    }

    private BigDecimal parseInput(Object input) throws Exception {
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance();
        df.setParseBigDecimal(true);
        return (BigDecimal)df.parseObject(Objects.toString(input));
    }

    private String formatNumber(Locale locale, BigDecimal number, Optional<Integer> maxDecimalPrecision) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        int numDecimalPlacesInInput = Math.max(0, number.scale());
        numberFormat.setMaximumFractionDigits(Math.min(numDecimalPlacesInInput, maxDecimalPrecision.isPresent() ? maxDecimalPrecision.get() : numDecimalPlacesInInput));
        return numberFormat.format(number);
    }
}

