/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.interpret;

import com.google.common.annotations.Beta;
import com.hubspot.jinjava.interpret.Context;
import java.util.Objects;

@Beta
public class MetaContextVariables {
    public static final String TEMPORARY_META_CONTEXT_PREFIX = "__temp_meta_";
    private static final String TEMPORARY_IMPORT_ALIAS_PREFIX = "__temp_meta_import_alias_";
    private static final String TEMPORARY_IMPORT_ALIAS_FORMAT = "__temp_meta_import_alias_%d__";
    private static final String TEMP_CURRENT_PATH_PREFIX = "__temp_meta_current_path_";
    private static final String TEMP_CURRENT_PATH_FORMAT = "__temp_meta_current_path_%d__";

    public static boolean isMetaContextVariable(String varName, Context context) {
        if (MetaContextVariables.isTemporaryMetaContextVariable(varName)) {
            return true;
        }
        return context.getMetaContextVariables().contains(varName) && !context.getNonMetaContextVariables().contains(varName);
    }

    private static boolean isTemporaryMetaContextVariable(String varName) {
        return varName.startsWith(TEMPORARY_META_CONTEXT_PREFIX);
    }

    public static boolean isTemporaryImportAlias(String varName) {
        return varName.startsWith(TEMPORARY_IMPORT_ALIAS_PREFIX);
    }

    public static String getTemporaryImportAlias(String fullAlias) {
        return String.format(TEMPORARY_IMPORT_ALIAS_FORMAT, Math.abs(Objects.hashCode(fullAlias)));
    }

    public static String getTemporaryCurrentPathVarName(String newPath) {
        return String.format(TEMP_CURRENT_PATH_FORMAT, Math.abs(Objects.hash(newPath, TEMPORARY_META_CONTEXT_PREFIX) >> 1));
    }
}

