/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.interpret;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.jinjava.interpret.ContextConfigurationIF;
import com.hubspot.jinjava.interpret.DynamicVariableResolver;
import com.hubspot.jinjava.interpret.ErrorHandlingStrategy;
import com.hubspot.jinjava.lib.expression.ExpressionStrategy;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ContextConfigurationIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ContextConfiguration
implements ContextConfigurationIF {
    private final ExpressionStrategy expressionStrategy;
    @Nullable
    private final DynamicVariableResolver dynamicVariableResolver;
    private final boolean validationMode;
    private final boolean deferredExecutionMode;
    private final boolean deferLargeObjects;
    private final boolean partialMacroEvaluation;
    private final boolean unwrapRawOverride;
    private final ErrorHandlingStrategy errorHandlingStrategy;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ContextConfiguration INSTANCE = ContextConfiguration.validate(new ContextConfiguration());

    private ContextConfiguration() {
        this.dynamicVariableResolver = null;
        this.expressionStrategy = this.initShim.getExpressionStrategy();
        this.validationMode = this.initShim.isValidationMode();
        this.deferredExecutionMode = this.initShim.isDeferredExecutionMode();
        this.deferLargeObjects = this.initShim.isDeferLargeObjects();
        this.partialMacroEvaluation = this.initShim.isPartialMacroEvaluation();
        this.unwrapRawOverride = this.initShim.isUnwrapRawOverride();
        this.errorHandlingStrategy = this.initShim.getErrorHandlingStrategy();
        this.initShim = null;
    }

    private ContextConfiguration(Builder builder) {
        this.dynamicVariableResolver = builder.dynamicVariableResolver;
        if (builder.expressionStrategy != null) {
            this.initShim.setExpressionStrategy(builder.expressionStrategy);
        }
        if (builder.validationModeIsSet()) {
            this.initShim.setValidationMode(builder.validationMode);
        }
        if (builder.deferredExecutionModeIsSet()) {
            this.initShim.setDeferredExecutionMode(builder.deferredExecutionMode);
        }
        if (builder.deferLargeObjectsIsSet()) {
            this.initShim.setDeferLargeObjects(builder.deferLargeObjects);
        }
        if (builder.partialMacroEvaluationIsSet()) {
            this.initShim.setPartialMacroEvaluation(builder.partialMacroEvaluation);
        }
        if (builder.unwrapRawOverrideIsSet()) {
            this.initShim.setUnwrapRawOverride(builder.unwrapRawOverride);
        }
        if (builder.errorHandlingStrategy != null) {
            this.initShim.setErrorHandlingStrategy(builder.errorHandlingStrategy);
        }
        this.expressionStrategy = this.initShim.getExpressionStrategy();
        this.validationMode = this.initShim.isValidationMode();
        this.deferredExecutionMode = this.initShim.isDeferredExecutionMode();
        this.deferLargeObjects = this.initShim.isDeferLargeObjects();
        this.partialMacroEvaluation = this.initShim.isPartialMacroEvaluation();
        this.unwrapRawOverride = this.initShim.isUnwrapRawOverride();
        this.errorHandlingStrategy = this.initShim.getErrorHandlingStrategy();
        this.initShim = null;
    }

    private ContextConfiguration(ExpressionStrategy expressionStrategy, @Nullable DynamicVariableResolver dynamicVariableResolver, boolean validationMode, boolean deferredExecutionMode, boolean deferLargeObjects, boolean partialMacroEvaluation, boolean unwrapRawOverride, ErrorHandlingStrategy errorHandlingStrategy) {
        this.expressionStrategy = expressionStrategy;
        this.dynamicVariableResolver = dynamicVariableResolver;
        this.validationMode = validationMode;
        this.deferredExecutionMode = deferredExecutionMode;
        this.deferLargeObjects = deferLargeObjects;
        this.partialMacroEvaluation = partialMacroEvaluation;
        this.unwrapRawOverride = unwrapRawOverride;
        this.errorHandlingStrategy = errorHandlingStrategy;
        this.initShim = null;
    }

    private ExpressionStrategy getExpressionStrategyInitialize() {
        return ContextConfigurationIF.super.getExpressionStrategy();
    }

    private boolean isValidationModeInitialize() {
        return ContextConfigurationIF.super.isValidationMode();
    }

    private boolean isDeferredExecutionModeInitialize() {
        return ContextConfigurationIF.super.isDeferredExecutionMode();
    }

    private boolean isDeferLargeObjectsInitialize() {
        return ContextConfigurationIF.super.isDeferLargeObjects();
    }

    private boolean isPartialMacroEvaluationInitialize() {
        return ContextConfigurationIF.super.isPartialMacroEvaluation();
    }

    private boolean isUnwrapRawOverrideInitialize() {
        return ContextConfigurationIF.super.isUnwrapRawOverride();
    }

    private ErrorHandlingStrategy getErrorHandlingStrategyInitialize() {
        return ContextConfigurationIF.super.getErrorHandlingStrategy();
    }

    @Override
    @JsonProperty
    public ExpressionStrategy getExpressionStrategy() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getExpressionStrategy() : this.expressionStrategy;
    }

    @Override
    @JsonProperty
    @Nullable
    public DynamicVariableResolver getDynamicVariableResolver() {
        return this.dynamicVariableResolver;
    }

    @Override
    @JsonProperty
    public boolean isValidationMode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isValidationMode() : this.validationMode;
    }

    @Override
    @JsonProperty
    public boolean isDeferredExecutionMode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isDeferredExecutionMode() : this.deferredExecutionMode;
    }

    @Override
    @JsonProperty
    public boolean isDeferLargeObjects() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isDeferLargeObjects() : this.deferLargeObjects;
    }

    @Override
    @JsonProperty
    public boolean isPartialMacroEvaluation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isPartialMacroEvaluation() : this.partialMacroEvaluation;
    }

    @Override
    @JsonProperty
    public boolean isUnwrapRawOverride() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isUnwrapRawOverride() : this.unwrapRawOverride;
    }

    @Override
    @JsonProperty
    public ErrorHandlingStrategy getErrorHandlingStrategy() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getErrorHandlingStrategy() : this.errorHandlingStrategy;
    }

    public final ContextConfiguration withExpressionStrategy(ExpressionStrategy value) {
        if (this.expressionStrategy == value) {
            return this;
        }
        ExpressionStrategy newValue = Objects.requireNonNull(value, "expressionStrategy");
        return ContextConfiguration.validate(new ContextConfiguration(newValue, this.dynamicVariableResolver, this.validationMode, this.deferredExecutionMode, this.deferLargeObjects, this.partialMacroEvaluation, this.unwrapRawOverride, this.errorHandlingStrategy));
    }

    public final ContextConfiguration withDynamicVariableResolver(@Nullable DynamicVariableResolver value) {
        if (this.dynamicVariableResolver == value) {
            return this;
        }
        return ContextConfiguration.validate(new ContextConfiguration(this.expressionStrategy, value, this.validationMode, this.deferredExecutionMode, this.deferLargeObjects, this.partialMacroEvaluation, this.unwrapRawOverride, this.errorHandlingStrategy));
    }

    public final ContextConfiguration withValidationMode(boolean value) {
        if (this.validationMode == value) {
            return this;
        }
        return ContextConfiguration.validate(new ContextConfiguration(this.expressionStrategy, this.dynamicVariableResolver, value, this.deferredExecutionMode, this.deferLargeObjects, this.partialMacroEvaluation, this.unwrapRawOverride, this.errorHandlingStrategy));
    }

    public final ContextConfiguration withDeferredExecutionMode(boolean value) {
        if (this.deferredExecutionMode == value) {
            return this;
        }
        return ContextConfiguration.validate(new ContextConfiguration(this.expressionStrategy, this.dynamicVariableResolver, this.validationMode, value, this.deferLargeObjects, this.partialMacroEvaluation, this.unwrapRawOverride, this.errorHandlingStrategy));
    }

    public final ContextConfiguration withDeferLargeObjects(boolean value) {
        if (this.deferLargeObjects == value) {
            return this;
        }
        return ContextConfiguration.validate(new ContextConfiguration(this.expressionStrategy, this.dynamicVariableResolver, this.validationMode, this.deferredExecutionMode, value, this.partialMacroEvaluation, this.unwrapRawOverride, this.errorHandlingStrategy));
    }

    public final ContextConfiguration withPartialMacroEvaluation(boolean value) {
        if (this.partialMacroEvaluation == value) {
            return this;
        }
        return ContextConfiguration.validate(new ContextConfiguration(this.expressionStrategy, this.dynamicVariableResolver, this.validationMode, this.deferredExecutionMode, this.deferLargeObjects, value, this.unwrapRawOverride, this.errorHandlingStrategy));
    }

    public final ContextConfiguration withUnwrapRawOverride(boolean value) {
        if (this.unwrapRawOverride == value) {
            return this;
        }
        return ContextConfiguration.validate(new ContextConfiguration(this.expressionStrategy, this.dynamicVariableResolver, this.validationMode, this.deferredExecutionMode, this.deferLargeObjects, this.partialMacroEvaluation, value, this.errorHandlingStrategy));
    }

    public final ContextConfiguration withErrorHandlingStrategy(ErrorHandlingStrategy value) {
        if (this.errorHandlingStrategy == value) {
            return this;
        }
        ErrorHandlingStrategy newValue = Objects.requireNonNull(value, "errorHandlingStrategy");
        return ContextConfiguration.validate(new ContextConfiguration(this.expressionStrategy, this.dynamicVariableResolver, this.validationMode, this.deferredExecutionMode, this.deferLargeObjects, this.partialMacroEvaluation, this.unwrapRawOverride, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ContextConfiguration && this.equalTo(0, (ContextConfiguration)another);
    }

    private boolean equalTo(int synthetic, ContextConfiguration another) {
        return this.expressionStrategy.equals(another.expressionStrategy) && Objects.equals(this.dynamicVariableResolver, another.dynamicVariableResolver) && this.validationMode == another.validationMode && this.deferredExecutionMode == another.deferredExecutionMode && this.deferLargeObjects == another.deferLargeObjects && this.partialMacroEvaluation == another.partialMacroEvaluation && this.unwrapRawOverride == another.unwrapRawOverride && this.errorHandlingStrategy.equals(another.errorHandlingStrategy);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.expressionStrategy.hashCode();
        h += (h << 5) + Objects.hashCode(this.dynamicVariableResolver);
        h += (h << 5) + Booleans.hashCode((boolean)this.validationMode);
        h += (h << 5) + Booleans.hashCode((boolean)this.deferredExecutionMode);
        h += (h << 5) + Booleans.hashCode((boolean)this.deferLargeObjects);
        h += (h << 5) + Booleans.hashCode((boolean)this.partialMacroEvaluation);
        h += (h << 5) + Booleans.hashCode((boolean)this.unwrapRawOverride);
        h += (h << 5) + this.errorHandlingStrategy.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ContextConfiguration").omitNullValues().add("expressionStrategy", (Object)this.expressionStrategy).add("dynamicVariableResolver", (Object)this.dynamicVariableResolver).add("validationMode", this.validationMode).add("deferredExecutionMode", this.deferredExecutionMode).add("deferLargeObjects", this.deferLargeObjects).add("partialMacroEvaluation", this.partialMacroEvaluation).add("unwrapRawOverride", this.unwrapRawOverride).add("errorHandlingStrategy", (Object)this.errorHandlingStrategy).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ContextConfiguration fromJson(Json json) {
        Builder builder = ContextConfiguration.builder();
        if (json.expressionStrategy != null) {
            builder.setExpressionStrategy(json.expressionStrategy);
        }
        if (json.dynamicVariableResolver != null) {
            builder.setDynamicVariableResolver(json.dynamicVariableResolver);
        }
        if (json.validationModeIsSet) {
            builder.setValidationMode(json.validationMode);
        }
        if (json.deferredExecutionModeIsSet) {
            builder.setDeferredExecutionMode(json.deferredExecutionMode);
        }
        if (json.deferLargeObjectsIsSet) {
            builder.setDeferLargeObjects(json.deferLargeObjects);
        }
        if (json.partialMacroEvaluationIsSet) {
            builder.setPartialMacroEvaluation(json.partialMacroEvaluation);
        }
        if (json.unwrapRawOverrideIsSet) {
            builder.setUnwrapRawOverride(json.unwrapRawOverride);
        }
        if (json.errorHandlingStrategy != null) {
            builder.setErrorHandlingStrategy(json.errorHandlingStrategy);
        }
        return builder.build();
    }

    public static ContextConfiguration of() {
        return INSTANCE;
    }

    private static ContextConfiguration validate(ContextConfiguration instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ContextConfiguration copyOf(ContextConfigurationIF instance) {
        if (instance instanceof ContextConfiguration) {
            return (ContextConfiguration)instance;
        }
        return ContextConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ContextConfigurationIF", generator="Immutables")
    private final class InitShim {
        private byte expressionStrategyBuildStage = 0;
        private ExpressionStrategy expressionStrategy;
        private byte validationModeBuildStage = 0;
        private boolean validationMode;
        private byte deferredExecutionModeBuildStage = 0;
        private boolean deferredExecutionMode;
        private byte deferLargeObjectsBuildStage = 0;
        private boolean deferLargeObjects;
        private byte partialMacroEvaluationBuildStage = 0;
        private boolean partialMacroEvaluation;
        private byte unwrapRawOverrideBuildStage = 0;
        private boolean unwrapRawOverride;
        private byte errorHandlingStrategyBuildStage = 0;
        private ErrorHandlingStrategy errorHandlingStrategy;

        private InitShim() {
        }

        ExpressionStrategy getExpressionStrategy() {
            if (this.expressionStrategyBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.expressionStrategyBuildStage == 0) {
                this.expressionStrategyBuildStage = (byte)-1;
                this.expressionStrategy = Objects.requireNonNull(ContextConfiguration.this.getExpressionStrategyInitialize(), "expressionStrategy");
                this.expressionStrategyBuildStage = 1;
            }
            return this.expressionStrategy;
        }

        void setExpressionStrategy(ExpressionStrategy expressionStrategy) {
            this.expressionStrategy = expressionStrategy;
            this.expressionStrategyBuildStage = 1;
        }

        boolean isValidationMode() {
            if (this.validationModeBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.validationModeBuildStage == 0) {
                this.validationModeBuildStage = (byte)-1;
                this.validationMode = ContextConfiguration.this.isValidationModeInitialize();
                this.validationModeBuildStage = 1;
            }
            return this.validationMode;
        }

        void setValidationMode(boolean validationMode) {
            this.validationMode = validationMode;
            this.validationModeBuildStage = 1;
        }

        boolean isDeferredExecutionMode() {
            if (this.deferredExecutionModeBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.deferredExecutionModeBuildStage == 0) {
                this.deferredExecutionModeBuildStage = (byte)-1;
                this.deferredExecutionMode = ContextConfiguration.this.isDeferredExecutionModeInitialize();
                this.deferredExecutionModeBuildStage = 1;
            }
            return this.deferredExecutionMode;
        }

        void setDeferredExecutionMode(boolean deferredExecutionMode) {
            this.deferredExecutionMode = deferredExecutionMode;
            this.deferredExecutionModeBuildStage = 1;
        }

        boolean isDeferLargeObjects() {
            if (this.deferLargeObjectsBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.deferLargeObjectsBuildStage == 0) {
                this.deferLargeObjectsBuildStage = (byte)-1;
                this.deferLargeObjects = ContextConfiguration.this.isDeferLargeObjectsInitialize();
                this.deferLargeObjectsBuildStage = 1;
            }
            return this.deferLargeObjects;
        }

        void setDeferLargeObjects(boolean deferLargeObjects) {
            this.deferLargeObjects = deferLargeObjects;
            this.deferLargeObjectsBuildStage = 1;
        }

        boolean isPartialMacroEvaluation() {
            if (this.partialMacroEvaluationBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.partialMacroEvaluationBuildStage == 0) {
                this.partialMacroEvaluationBuildStage = (byte)-1;
                this.partialMacroEvaluation = ContextConfiguration.this.isPartialMacroEvaluationInitialize();
                this.partialMacroEvaluationBuildStage = 1;
            }
            return this.partialMacroEvaluation;
        }

        void setPartialMacroEvaluation(boolean partialMacroEvaluation) {
            this.partialMacroEvaluation = partialMacroEvaluation;
            this.partialMacroEvaluationBuildStage = 1;
        }

        boolean isUnwrapRawOverride() {
            if (this.unwrapRawOverrideBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.unwrapRawOverrideBuildStage == 0) {
                this.unwrapRawOverrideBuildStage = (byte)-1;
                this.unwrapRawOverride = ContextConfiguration.this.isUnwrapRawOverrideInitialize();
                this.unwrapRawOverrideBuildStage = 1;
            }
            return this.unwrapRawOverride;
        }

        void setUnwrapRawOverride(boolean unwrapRawOverride) {
            this.unwrapRawOverride = unwrapRawOverride;
            this.unwrapRawOverrideBuildStage = 1;
        }

        ErrorHandlingStrategy getErrorHandlingStrategy() {
            if (this.errorHandlingStrategyBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.errorHandlingStrategyBuildStage == 0) {
                this.errorHandlingStrategyBuildStage = (byte)-1;
                this.errorHandlingStrategy = Objects.requireNonNull(ContextConfiguration.this.getErrorHandlingStrategyInitialize(), "errorHandlingStrategy");
                this.errorHandlingStrategyBuildStage = 1;
            }
            return this.errorHandlingStrategy;
        }

        void setErrorHandlingStrategy(ErrorHandlingStrategy errorHandlingStrategy) {
            this.errorHandlingStrategy = errorHandlingStrategy;
            this.errorHandlingStrategyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.expressionStrategyBuildStage == -1) {
                attributes.add("expressionStrategy");
            }
            if (this.validationModeBuildStage == -1) {
                attributes.add("validationMode");
            }
            if (this.deferredExecutionModeBuildStage == -1) {
                attributes.add("deferredExecutionMode");
            }
            if (this.deferLargeObjectsBuildStage == -1) {
                attributes.add("deferLargeObjects");
            }
            if (this.partialMacroEvaluationBuildStage == -1) {
                attributes.add("partialMacroEvaluation");
            }
            if (this.unwrapRawOverrideBuildStage == -1) {
                attributes.add("unwrapRawOverride");
            }
            if (this.errorHandlingStrategyBuildStage == -1) {
                attributes.add("errorHandlingStrategy");
            }
            return "Cannot build ContextConfiguration, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="ContextConfigurationIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_VALIDATION_MODE = 1L;
        private static final long OPT_BIT_DEFERRED_EXECUTION_MODE = 2L;
        private static final long OPT_BIT_DEFER_LARGE_OBJECTS = 4L;
        private static final long OPT_BIT_PARTIAL_MACRO_EVALUATION = 8L;
        private static final long OPT_BIT_UNWRAP_RAW_OVERRIDE = 16L;
        private long optBits;
        @Nullable
        private ExpressionStrategy expressionStrategy;
        @Nullable
        private DynamicVariableResolver dynamicVariableResolver;
        private boolean validationMode;
        private boolean deferredExecutionMode;
        private boolean deferLargeObjects;
        private boolean partialMacroEvaluation;
        private boolean unwrapRawOverride;
        @Nullable
        private ErrorHandlingStrategy errorHandlingStrategy;

        private Builder() {
        }

        public final Builder from(ContextConfigurationIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setExpressionStrategy(instance.getExpressionStrategy());
            DynamicVariableResolver dynamicVariableResolverValue = instance.getDynamicVariableResolver();
            if (dynamicVariableResolverValue != null) {
                this.setDynamicVariableResolver(dynamicVariableResolverValue);
            }
            this.setValidationMode(instance.isValidationMode());
            this.setDeferredExecutionMode(instance.isDeferredExecutionMode());
            this.setDeferLargeObjects(instance.isDeferLargeObjects());
            this.setPartialMacroEvaluation(instance.isPartialMacroEvaluation());
            this.setUnwrapRawOverride(instance.isUnwrapRawOverride());
            this.setErrorHandlingStrategy(instance.getErrorHandlingStrategy());
            return this;
        }

        public final Builder setExpressionStrategy(ExpressionStrategy expressionStrategy) {
            this.expressionStrategy = Objects.requireNonNull(expressionStrategy, "expressionStrategy");
            return this;
        }

        public final Builder setDynamicVariableResolver(@Nullable DynamicVariableResolver dynamicVariableResolver) {
            this.dynamicVariableResolver = dynamicVariableResolver;
            return this;
        }

        public final Builder setValidationMode(boolean validationMode) {
            this.validationMode = validationMode;
            this.optBits |= 1L;
            return this;
        }

        public final Builder setDeferredExecutionMode(boolean deferredExecutionMode) {
            this.deferredExecutionMode = deferredExecutionMode;
            this.optBits |= 2L;
            return this;
        }

        public final Builder setDeferLargeObjects(boolean deferLargeObjects) {
            this.deferLargeObjects = deferLargeObjects;
            this.optBits |= 4L;
            return this;
        }

        public final Builder setPartialMacroEvaluation(boolean partialMacroEvaluation) {
            this.partialMacroEvaluation = partialMacroEvaluation;
            this.optBits |= 8L;
            return this;
        }

        public final Builder setUnwrapRawOverride(boolean unwrapRawOverride) {
            this.unwrapRawOverride = unwrapRawOverride;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder setErrorHandlingStrategy(ErrorHandlingStrategy errorHandlingStrategy) {
            this.errorHandlingStrategy = Objects.requireNonNull(errorHandlingStrategy, "errorHandlingStrategy");
            return this;
        }

        public ContextConfiguration build() {
            return ContextConfiguration.validate(new ContextConfiguration(this));
        }

        private boolean validationModeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean deferredExecutionModeIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean deferLargeObjectsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean partialMacroEvaluationIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean unwrapRawOverrideIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ContextConfigurationIF", generator="Immutables")
    static final class Json
    implements ContextConfigurationIF {
        @Nullable
        ExpressionStrategy expressionStrategy;
        @Nullable
        DynamicVariableResolver dynamicVariableResolver;
        boolean validationMode;
        boolean validationModeIsSet;
        boolean deferredExecutionMode;
        boolean deferredExecutionModeIsSet;
        boolean deferLargeObjects;
        boolean deferLargeObjectsIsSet;
        boolean partialMacroEvaluation;
        boolean partialMacroEvaluationIsSet;
        boolean unwrapRawOverride;
        boolean unwrapRawOverrideIsSet;
        @Nullable
        ErrorHandlingStrategy errorHandlingStrategy;

        Json() {
        }

        @JsonProperty
        public void setExpressionStrategy(ExpressionStrategy expressionStrategy) {
            this.expressionStrategy = expressionStrategy;
        }

        @JsonProperty
        public void setDynamicVariableResolver(@Nullable DynamicVariableResolver dynamicVariableResolver) {
            this.dynamicVariableResolver = dynamicVariableResolver;
        }

        @JsonProperty
        public void setValidationMode(boolean validationMode) {
            this.validationMode = validationMode;
            this.validationModeIsSet = true;
        }

        @JsonProperty
        public void setDeferredExecutionMode(boolean deferredExecutionMode) {
            this.deferredExecutionMode = deferredExecutionMode;
            this.deferredExecutionModeIsSet = true;
        }

        @JsonProperty
        public void setDeferLargeObjects(boolean deferLargeObjects) {
            this.deferLargeObjects = deferLargeObjects;
            this.deferLargeObjectsIsSet = true;
        }

        @JsonProperty
        public void setPartialMacroEvaluation(boolean partialMacroEvaluation) {
            this.partialMacroEvaluation = partialMacroEvaluation;
            this.partialMacroEvaluationIsSet = true;
        }

        @JsonProperty
        public void setUnwrapRawOverride(boolean unwrapRawOverride) {
            this.unwrapRawOverride = unwrapRawOverride;
            this.unwrapRawOverrideIsSet = true;
        }

        @JsonProperty
        public void setErrorHandlingStrategy(ErrorHandlingStrategy errorHandlingStrategy) {
            this.errorHandlingStrategy = errorHandlingStrategy;
        }

        @Override
        public ExpressionStrategy getExpressionStrategy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DynamicVariableResolver getDynamicVariableResolver() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isValidationMode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDeferredExecutionMode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDeferLargeObjects() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPartialMacroEvaluation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isUnwrapRawOverride() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ErrorHandlingStrategy getErrorHandlingStrategy() {
            throw new UnsupportedOperationException();
        }
    }
}

