/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.interpret;

import com.google.common.annotations.Beta;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.hubspot.jinjava.interpret.AutoCloseableSupplier;
import com.hubspot.jinjava.interpret.CallStack;
import com.hubspot.jinjava.interpret.ContextConfiguration;
import com.hubspot.jinjava.interpret.ContextConfigurationIF;
import com.hubspot.jinjava.interpret.DeferredValue;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.DynamicVariableResolver;
import com.hubspot.jinjava.interpret.ErrorHandlingStrategy;
import com.hubspot.jinjava.interpret.ExtendsTagCycleException;
import com.hubspot.jinjava.interpret.FromTagCycleException;
import com.hubspot.jinjava.interpret.ImportTagCycleException;
import com.hubspot.jinjava.interpret.IncludeTagCycleException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.MacroTagCycleException;
import com.hubspot.jinjava.interpret.TagCycleException;
import com.hubspot.jinjava.lib.Importable;
import com.hubspot.jinjava.lib.expression.ExpressionStrategy;
import com.hubspot.jinjava.lib.exptest.ExpTest;
import com.hubspot.jinjava.lib.exptest.ExpTestLibrary;
import com.hubspot.jinjava.lib.filter.Filter;
import com.hubspot.jinjava.lib.filter.FilterLibrary;
import com.hubspot.jinjava.lib.fn.ELFunctionDefinition;
import com.hubspot.jinjava.lib.fn.FunctionLibrary;
import com.hubspot.jinjava.lib.fn.MacroFunction;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.lib.tag.TagLibrary;
import com.hubspot.jinjava.lib.tag.eager.DeferredToken;
import com.hubspot.jinjava.mode.EagerExecutionMode;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.util.DeferredValueUtils;
import com.hubspot.jinjava.util.ScopeMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class Context
extends ScopeMap<String, Object> {
    public static final String GLOBAL_MACROS_SCOPE_KEY = "__macros__";
    public static final String IMPORT_RESOURCE_PATH_KEY = "import_resource_path";
    public static final String DEFERRED_IMPORT_RESOURCE_PATH_KEY = "deferred_import_resource_path";
    public static final String IMPORT_RESOURCE_ALIAS_KEY = "import_resource_alias";
    private SetMultimap<String, String> dependencies = HashMultimap.create();
    private Map<Library, Set<String>> disabled;
    private final CallStack extendPathStack;
    private final CallStack importPathStack;
    private final CallStack includePathStack;
    private final CallStack macroStack;
    private final CallStack fromStack;
    private final CallStack currentPathStack;
    private final Set<String> resolvedExpressions = new HashSet<String>();
    private final Set<String> resolvedValues = new HashSet<String>();
    private final Set<String> resolvedFunctions = new HashSet<String>();
    private Set<Node> deferredNodes = new HashSet<Node>();
    @Beta
    private Set<DeferredToken> deferredTokens = new HashSet<DeferredToken>();
    private final ExpTestLibrary expTestLibrary;
    private final FilterLibrary filterLibrary;
    private final FunctionLibrary functionLibrary;
    private final TagLibrary tagLibrary;
    private final Context parent;
    private int renderDepth = -1;
    private Boolean autoEscape;
    private List<? extends Node> superBlock;
    private final Stack<String> renderStack = new Stack();
    private ContextConfiguration contextConfiguration = ContextConfiguration.of();
    private final Set<String> metaContextVariables;
    private final Set<String> overriddenNonMetaContextVariables;
    private Node currentNode;

    public boolean isValidationMode() {
        return this.contextConfiguration.isValidationMode();
    }

    public Context setValidationMode(boolean validationMode) {
        this.contextConfiguration = this.contextConfiguration.withValidationMode(validationMode);
        return this;
    }

    public Context() {
        this(null, null, null, true);
    }

    public Context(Context parent) {
        this(parent, null, null, true);
    }

    public Context(Context parent, Map<String, ?> bindings) {
        this(parent, bindings, null, true);
    }

    public Context(Context parent, Map<String, ?> bindings, Map<Library, Set<String>> disabled) {
        this(parent, bindings, disabled, true);
    }

    public Context(Context parent, Map<String, ?> bindings, Map<Library, Set<String>> disabled, boolean makeNewCallStacks) {
        super(parent);
        this.disabled = disabled;
        if (bindings != null) {
            this.putAll(bindings);
        }
        this.parent = parent;
        CallStack callStack = makeNewCallStacks ? new CallStack(parent == null ? null : parent.getExtendPathStack(), ExtendsTagCycleException.class) : (this.extendPathStack = parent == null ? null : parent.getExtendPathStack());
        CallStack callStack2 = makeNewCallStacks ? new CallStack(parent == null ? null : parent.getImportPathStack(), ImportTagCycleException.class) : (this.importPathStack = parent == null ? null : parent.getImportPathStack());
        CallStack callStack3 = makeNewCallStacks ? new CallStack(parent == null ? null : parent.getIncludePathStack(), IncludeTagCycleException.class) : (this.includePathStack = parent == null ? null : parent.getIncludePathStack());
        CallStack callStack4 = makeNewCallStacks ? new CallStack(parent == null ? null : parent.getMacroStack(), MacroTagCycleException.class) : (this.macroStack = parent == null ? null : parent.getMacroStack());
        CallStack callStack5 = makeNewCallStacks ? new CallStack(parent == null ? null : parent.getFromStack(), FromTagCycleException.class) : (this.fromStack = parent == null ? null : parent.getFromStack());
        CallStack callStack6 = makeNewCallStacks ? new CallStack(parent == null ? null : parent.getCurrentPathStack(), TagCycleException.class) : (this.currentPathStack = parent == null ? null : parent.getCurrentPathStack());
        if (disabled == null) {
            disabled = new HashMap<Library, Set<String>>();
        }
        this.expTestLibrary = new ExpTestLibrary(parent == null, disabled.get((Object)Library.EXP_TEST));
        this.filterLibrary = new FilterLibrary(parent == null, disabled.get((Object)Library.FILTER));
        this.tagLibrary = new TagLibrary(parent == null, disabled.get((Object)Library.TAG));
        this.functionLibrary = new FunctionLibrary(parent == null, disabled.get((Object)Library.FUNCTION));
        this.metaContextVariables = parent == null ? new HashSet() : parent.metaContextVariables;
        Set<Object> set = this.overriddenNonMetaContextVariables = parent == null ? new HashSet() : parent.overriddenNonMetaContextVariables;
        if (parent != null) {
            this.contextConfiguration = parent.contextConfiguration;
        }
    }

    public void reset() {
        this.resolvedExpressions.clear();
        this.resolvedValues.clear();
        this.resolvedFunctions.clear();
        this.dependencies = HashMultimap.create();
        this.deferredNodes = new HashSet<Node>();
        this.deferredTokens = new HashSet<DeferredToken>();
    }

    public Context getParent() {
        return this.parent;
    }

    public Map<String, Object> getSessionBindings() {
        return this.getScope();
    }

    public Map<String, MacroFunction> getGlobalMacros() {
        HashMap macros = (HashMap)this.getScope().get(GLOBAL_MACROS_SCOPE_KEY);
        if (macros == null) {
            macros = new HashMap();
            this.getScope().put(GLOBAL_MACROS_SCOPE_KEY, macros);
        }
        return macros;
    }

    public void addGlobalMacro(MacroFunction macro) {
        this.getGlobalMacros().put(macro.getName(), macro);
    }

    public MacroFunction getGlobalMacro(String identifier) {
        MacroFunction fn = this.getGlobalMacros().get(identifier);
        if (fn == null && this.parent != null) {
            fn = this.parent.getGlobalMacro(identifier);
        }
        return fn;
    }

    public boolean isGlobalMacro(String identifier) {
        return this.getGlobalMacro(identifier) != null;
    }

    public Optional<MacroFunction> getLocalMacro(String fullName) {
        String[] nameArray = fullName.split("\\.", 2);
        if (nameArray.length != 2) {
            return Optional.empty();
        }
        String localKey = nameArray[0];
        String macroName = nameArray[1];
        Object localValue = this.get(localKey);
        if (localValue instanceof DeferredValue) {
            localValue = ((DeferredValue)localValue).getOriginalValue();
        }
        if (!(localValue instanceof Map)) {
            return Optional.empty();
        }
        Object possibleMacroFunction = ((Map)localValue).get(macroName);
        if (possibleMacroFunction instanceof MacroFunction) {
            return Optional.of((MacroFunction)possibleMacroFunction);
        }
        return Optional.empty();
    }

    public boolean isAutoEscape() {
        if (this.autoEscape != null) {
            return this.autoEscape;
        }
        if (this.parent != null) {
            return this.parent.isAutoEscape();
        }
        return false;
    }

    public void setAutoEscape(Boolean autoEscape) {
        this.autoEscape = autoEscape;
    }

    public void addResolvedExpression(String expression) {
        this.resolvedExpressions.add(expression);
        if (this.getParent() != null) {
            this.getParent().addResolvedExpression(expression);
        }
    }

    public Set<String> getResolvedExpressions() {
        return ImmutableSet.copyOf(this.resolvedExpressions);
    }

    public boolean wasExpressionResolved(String expression) {
        return this.resolvedExpressions.contains(expression);
    }

    public void addResolvedValue(String value) {
        this.resolvedValues.add(value);
        if (this.getParent() != null) {
            this.getParent().addResolvedValue(value);
        }
    }

    public Set<String> getResolvedValues() {
        return ImmutableSet.copyOf(this.resolvedValues);
    }

    public boolean wasValueResolved(String value) {
        return this.resolvedValues.contains(value);
    }

    public Set<String> getResolvedFunctions() {
        return ImmutableSet.copyOf(this.resolvedFunctions);
    }

    public void addResolvedFunction(String function) {
        this.resolvedFunctions.add(function);
        if (this.getParent() != null) {
            this.getParent().addResolvedFunction(function);
        }
    }

    @Deprecated
    @Beta
    public Set<String> getMetaContextVariables() {
        return this.metaContextVariables;
    }

    @Beta
    Set<String> getComputedMetaContextVariables() {
        return Sets.difference(this.metaContextVariables, this.overriddenNonMetaContextVariables);
    }

    @Beta
    public void addMetaContextVariables(Collection<String> variables) {
        this.metaContextVariables.addAll(variables);
    }

    Set<String> getNonMetaContextVariables() {
        return this.overriddenNonMetaContextVariables;
    }

    @Beta
    public void addNonMetaContextVariables(Collection<String> variables) {
        this.overriddenNonMetaContextVariables.addAll(variables.stream().filter(var -> !EagerExecutionMode.STATIC_META_CONTEXT_VARIABLES.contains(var)).collect(Collectors.toList()));
    }

    @Beta
    public void removeNonMetaContextVariables(Collection<String> variables) {
        this.overriddenNonMetaContextVariables.removeAll(variables);
    }

    public void handleDeferredNode(Node node) {
        if (JinjavaInterpreter.getCurrentMaybe().map(interpreter -> interpreter.getConfig().getExecutionMode().useEagerParser()).orElse(false).booleanValue()) {
            this.addDeferredNodeRecursively(node);
        } else {
            this.handleDeferredNodeAndDeferVariables(node);
        }
    }

    private void addDeferredNodeRecursively(Node node) {
        Context parent;
        this.deferredNodes.add(node);
        if (this.getParent() != null && (parent = this.getParent()).getParent() != null) {
            this.getParent().handleDeferredNode(node);
        }
    }

    private void handleDeferredNodeAndDeferVariables(Node node) {
        Context parent;
        this.deferredNodes.add(node);
        Set<String> deferredProps = DeferredValueUtils.findAndMarkDeferredProperties(this, node);
        if (this.getParent() != null && (parent = this.getParent()).getParent() != null) {
            deferredProps.stream().filter(key -> !parent.containsKey(key)).forEach((? super T key) -> parent.put(key, this.get(key)));
            this.getParent().handleDeferredNode(node);
        }
    }

    public Set<Node> getDeferredNodes() {
        return ImmutableSet.copyOf(this.deferredNodes);
    }

    @Beta
    public void checkNumberOfDeferredTokens() {
        Context secondToLastContext = this;
        if (this.parent != null) {
            while (secondToLastContext.parent.parent != null) {
                secondToLastContext = secondToLastContext.parent;
            }
        }
        int currentNumDeferredTokens = secondToLastContext.deferredTokens.size();
        JinjavaInterpreter.getCurrentMaybe().map(i -> i.getConfig().getMaxNumDeferredTokens()).filter(maxNumDeferredTokens -> currentNumDeferredTokens >= maxNumDeferredTokens).ifPresent(maxNumDeferredTokens -> {
            throw new DeferredValueException("Too many Deferred Tokens, max is " + maxNumDeferredTokens);
        });
    }

    @Beta
    public void handleDeferredToken(DeferredToken deferredToken) {
        deferredToken.addTo(this);
    }

    @Beta
    public void removeDeferredTokens(Collection<DeferredToken> toRemove) {
        Context parent;
        if (this.getParent() != null && (parent = this.getParent()).getParent() != null) {
            parent.removeDeferredTokens(toRemove);
        }
        this.deferredTokens.removeAll(toRemove);
    }

    @Beta
    public Set<DeferredToken> getDeferredTokens() {
        return this.deferredTokens;
    }

    public Map<String, Object> getCombinedScope() {
        HashMap<String, Object> scopeMap = new HashMap<String, Object>(this.getScope());
        Context parent = this.parent;
        while (parent != null && parent.currentPathStack == this.currentPathStack) {
            parent.getScope().forEach(scopeMap::putIfAbsent);
            parent = parent.parent;
        }
        return scopeMap;
    }

    public Context getPenultimateParent() {
        Context secondToLastContext = this;
        if (this.parent != null) {
            while (secondToLastContext.parent.parent != null) {
                secondToLastContext = secondToLastContext.parent;
            }
        }
        return secondToLastContext;
    }

    public List<? extends Node> getSuperBlock() {
        if (this.superBlock != null) {
            return this.superBlock;
        }
        if (this.parent != null) {
            return this.parent.getSuperBlock();
        }
        return null;
    }

    public void setSuperBlock(List<? extends Node> superBlock) {
        this.superBlock = superBlock;
    }

    public void removeSuperBlock() {
        this.superBlock = null;
    }

    public void addResolvedFrom(Context context) {
        context.getResolvedExpressions().forEach(this::addResolvedExpression);
        context.getResolvedFunctions().forEach(this::addResolvedFunction);
        context.getResolvedValues().forEach(this::addResolvedValue);
    }

    @SafeVarargs
    public final void registerClasses(Class<? extends Importable> ... classes) {
        for (Class<? extends Importable> c : classes) {
            if (ExpTest.class.isAssignableFrom(c)) {
                this.expTestLibrary.registerClasses(c);
                continue;
            }
            if (Filter.class.isAssignableFrom(c)) {
                this.filterLibrary.registerClasses(c);
                continue;
            }
            if (!Tag.class.isAssignableFrom(c)) continue;
            this.tagLibrary.registerClasses(c);
        }
    }

    public Collection<ExpTest> getAllExpTests() {
        ArrayList<ExpTest> expTests = new ArrayList<ExpTest>(this.expTestLibrary.entries());
        if (this.parent != null) {
            expTests.addAll(this.parent.getAllExpTests());
        }
        return expTests;
    }

    public ExpTest getExpTest(String name) {
        ExpTest t = this.expTestLibrary.getExpTest(name);
        if (t != null) {
            return t;
        }
        if (this.parent != null) {
            return this.parent.getExpTest(name);
        }
        return null;
    }

    public void registerExpTest(ExpTest t) {
        this.expTestLibrary.addExpTest(t);
    }

    public Collection<Filter> getAllFilters() {
        ArrayList<Filter> filters = new ArrayList<Filter>(this.filterLibrary.entries());
        if (this.parent != null) {
            filters.addAll(this.parent.getAllFilters());
        }
        return filters;
    }

    public Filter getFilter(String name) {
        Filter f = this.filterLibrary.getFilter(name);
        if (f != null) {
            return f;
        }
        if (this.parent != null) {
            return this.parent.getFilter(name);
        }
        return null;
    }

    public void registerFilter(Filter f) {
        this.filterLibrary.addFilter(f);
    }

    public boolean isFunctionDisabled(String name) {
        return this.disabled != null && this.disabled.getOrDefault((Object)Library.FUNCTION, Collections.emptySet()).contains(name);
    }

    public ELFunctionDefinition getFunction(String name) {
        ELFunctionDefinition f = this.functionLibrary.getFunction(name);
        if (f != null) {
            return f;
        }
        if (this.parent != null) {
            return this.parent.getFunction(name);
        }
        return null;
    }

    public Collection<ELFunctionDefinition> getAllFunctions() {
        ArrayList fns = new ArrayList(this.functionLibrary.entries());
        if (this.parent != null) {
            fns.addAll(this.parent.getAllFunctions());
        }
        HashSet disabledFunctions = this.disabled == null ? new HashSet() : (Set)this.disabled.getOrDefault((Object)Library.FUNCTION, new HashSet());
        return fns.stream().filter(f -> !disabledFunctions.contains(f.getName())).collect(Collectors.toList());
    }

    public void registerFunction(ELFunctionDefinition f) {
        this.functionLibrary.addFunction(f);
    }

    public Collection<Tag> getAllTags() {
        ArrayList<Tag> tags = new ArrayList<Tag>(this.tagLibrary.entries());
        if (this.parent != null) {
            tags.addAll(this.parent.getAllTags());
        }
        return tags;
    }

    public Tag getTag(String name) {
        Tag t = this.tagLibrary.getTag(name);
        if (t != null) {
            return t;
        }
        if (this.parent != null) {
            return this.parent.getTag(name);
        }
        return null;
    }

    public void registerTag(Tag t) {
        this.tagLibrary.addTag(t);
    }

    public DynamicVariableResolver getDynamicVariableResolver() {
        return this.contextConfiguration.getDynamicVariableResolver();
    }

    public void setDynamicVariableResolver(DynamicVariableResolver dynamicVariableResolver) {
        this.contextConfiguration = this.contextConfiguration.withDynamicVariableResolver(dynamicVariableResolver);
    }

    public ExpressionStrategy getExpressionStrategy() {
        return this.contextConfiguration.getExpressionStrategy();
    }

    public void setExpressionStrategy(ExpressionStrategy expressionStrategy) {
        this.contextConfiguration = this.contextConfiguration.withExpressionStrategy(expressionStrategy);
    }

    public Optional<String> getImportResourceAlias() {
        return Optional.ofNullable(this.get(IMPORT_RESOURCE_ALIAS_KEY)).map(Object::toString);
    }

    public CallStack getExtendPathStack() {
        return this.extendPathStack;
    }

    public CallStack getImportPathStack() {
        return this.importPathStack;
    }

    public CallStack getFromPathStack() {
        return this.fromStack;
    }

    public CallStack getIncludePathStack() {
        return this.includePathStack;
    }

    private CallStack getFromStack() {
        return this.fromStack;
    }

    public CallStack getMacroStack() {
        return this.macroStack;
    }

    public CallStack getCurrentPathStack() {
        return this.currentPathStack;
    }

    @Deprecated
    public void pushFromStack(String path, int lineNumber, int startPosition) {
        this.fromStack.push(path, lineNumber, startPosition);
    }

    @Deprecated
    public void popFromStack() {
        this.fromStack.pop();
    }

    public int getRenderDepth() {
        if (this.renderDepth != -1) {
            return this.renderDepth;
        }
        if (this.parent != null) {
            return this.parent.getRenderDepth();
        }
        return 0;
    }

    public void setRenderDepth(int renderDepth) {
        this.renderDepth = renderDepth;
    }

    public AutoCloseableSupplier<String> closeablePushRenderStack(String template) {
        this.renderStack.push(template);
        return AutoCloseableSupplier.of(() -> template, t -> this.renderStack.pop());
    }

    @Deprecated
    public void pushRenderStack(String template) {
        this.renderStack.push(template);
    }

    @Deprecated
    public String popRenderStack() {
        return this.renderStack.pop();
    }

    public boolean doesRenderStackContain(String template) {
        return this.renderStack.contains(template);
    }

    public void addDependency(String type, String identification) {
        this.dependencies.get((Object)type).add(identification);
        if (this.parent != null) {
            this.parent.addDependency(type, identification);
        }
    }

    public void addDependencies(SetMultimap<String, String> dependencies) {
        this.dependencies.putAll(dependencies);
        if (this.parent != null) {
            this.parent.addDependencies(dependencies);
        }
    }

    public SetMultimap<String, String> getDependencies() {
        return this.dependencies;
    }

    public boolean isDeferredExecutionMode() {
        return this.contextConfiguration.isDeferredExecutionMode();
    }

    public Context setDeferredExecutionMode(boolean deferredExecutionMode) {
        this.contextConfiguration = this.contextConfiguration.withDeferredExecutionMode(deferredExecutionMode);
        return this;
    }

    public boolean isDeferLargeObjects() {
        return this.contextConfiguration.isDeferLargeObjects();
    }

    public Context setDeferLargeObjects(boolean deferLargeObjects) {
        this.contextConfiguration = this.contextConfiguration.withDeferLargeObjects(deferLargeObjects);
        return this;
    }

    public TemporaryValueClosable<Boolean> withDeferLargeObjects(boolean deferLargeObjects) {
        TemporaryValueClosable<Boolean> temporaryValueClosable = new TemporaryValueClosable<Boolean>(this.isDeferLargeObjects(), this::setDeferLargeObjects);
        this.setDeferLargeObjects(deferLargeObjects);
        return temporaryValueClosable;
    }

    @Deprecated
    public boolean getThrowInterpreterErrors() {
        ErrorHandlingStrategy errorHandlingStrategy = this.getErrorHandlingStrategy();
        return errorHandlingStrategy.getFatalErrorStrategy() == ContextConfigurationIF.ErrorHandlingStrategyIF.TemplateErrorTypeHandlingStrategy.THROW_EXCEPTION;
    }

    @Deprecated
    public void setThrowInterpreterErrors(boolean throwInterpreterErrors) {
        this.contextConfiguration = this.contextConfiguration.withErrorHandlingStrategy(ErrorHandlingStrategy.builder().setFatalErrorStrategy(throwInterpreterErrors ? ContextConfigurationIF.ErrorHandlingStrategyIF.TemplateErrorTypeHandlingStrategy.THROW_EXCEPTION : ContextConfigurationIF.ErrorHandlingStrategyIF.TemplateErrorTypeHandlingStrategy.ADD_ERROR).setNonFatalErrorStrategy(throwInterpreterErrors ? ContextConfigurationIF.ErrorHandlingStrategyIF.TemplateErrorTypeHandlingStrategy.IGNORE : ContextConfigurationIF.ErrorHandlingStrategyIF.TemplateErrorTypeHandlingStrategy.ADD_ERROR).build());
    }

    @Deprecated
    public TemporaryValueClosable<Boolean> withThrowInterpreterErrors() {
        TemporaryValueClosable<Boolean> temporaryValueClosable = new TemporaryValueClosable<Boolean>(this.getThrowInterpreterErrors(), this::setThrowInterpreterErrors);
        this.setThrowInterpreterErrors(true);
        return temporaryValueClosable;
    }

    public ErrorHandlingStrategy getErrorHandlingStrategy() {
        return this.contextConfiguration.getErrorHandlingStrategy();
    }

    public void setErrorHandlingStrategy(ErrorHandlingStrategy errorHandlingStrategy) {
        this.contextConfiguration = this.contextConfiguration.withErrorHandlingStrategy(errorHandlingStrategy);
    }

    public TemporaryValueClosable<ErrorHandlingStrategy> withErrorHandlingStrategy(ErrorHandlingStrategy errorHandlingStrategy) {
        TemporaryValueClosable<ErrorHandlingStrategy> temporaryValueClosable = new TemporaryValueClosable<ErrorHandlingStrategy>(this.getErrorHandlingStrategy(), this::setErrorHandlingStrategy);
        this.setErrorHandlingStrategy(errorHandlingStrategy);
        return temporaryValueClosable;
    }

    public boolean isPartialMacroEvaluation() {
        return this.contextConfiguration.isPartialMacroEvaluation();
    }

    public void setPartialMacroEvaluation(boolean partialMacroEvaluation) {
        this.contextConfiguration = this.contextConfiguration.withPartialMacroEvaluation(partialMacroEvaluation);
    }

    public TemporaryValueClosable<Boolean> withPartialMacroEvaluation() {
        return this.withPartialMacroEvaluation(true);
    }

    public TemporaryValueClosable<Boolean> withPartialMacroEvaluation(boolean partialMacroEvaluation) {
        TemporaryValueClosable<Boolean> temporaryValueClosable = new TemporaryValueClosable<Boolean>(this.isPartialMacroEvaluation(), this::setPartialMacroEvaluation);
        this.setPartialMacroEvaluation(partialMacroEvaluation);
        return temporaryValueClosable;
    }

    public boolean isUnwrapRawOverride() {
        return this.contextConfiguration.isUnwrapRawOverride();
    }

    public void setUnwrapRawOverride(boolean unwrapRawOverride) {
        this.contextConfiguration = this.contextConfiguration.withUnwrapRawOverride(unwrapRawOverride);
    }

    public TemporaryValueClosable<Boolean> withUnwrapRawOverride() {
        TemporaryValueClosable<Boolean> temporaryValueClosable = new TemporaryValueClosable<Boolean>(this.isUnwrapRawOverride(), this::setUnwrapRawOverride);
        this.setUnwrapRawOverride(true);
        return temporaryValueClosable;
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(Node currentNode) {
        this.currentNode = currentNode;
    }

    public boolean isInForLoop() {
        return this.get("loop") != null;
    }

    public static enum Library {
        EXP_TEST,
        FILTER,
        FUNCTION,
        TAG;

    }

    public static class TemporaryValueClosable<T>
    extends AutoCloseableSupplier.AutoCloseableImpl<T> {
        private TemporaryValueClosable(T previousValue, Consumer<T> resetValueConsumer) {
            super(previousValue, resetValueConsumer);
        }

        public static <T> TemporaryValueClosable<T> noOp() {
            return new NoOpTemporaryValueClosable();
        }

        private static class NoOpTemporaryValueClosable<T>
        extends TemporaryValueClosable<T> {
            private NoOpTemporaryValueClosable() {
                super(null, null);
            }

            @Override
            public void close() {
            }
        }
    }
}

