/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.interpret;

import com.google.common.base.Suppliers;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class AutoCloseableSupplier<T>
implements Supplier<AutoCloseableImpl<T>> {
    private final Supplier<AutoCloseableImpl<T>> autoCloseableImplWrapper;

    public static <T> AutoCloseableSupplier<T> of(T tSupplier) {
        return AutoCloseableSupplier.of(() -> tSupplier, ignored -> {});
    }

    public static <T> AutoCloseableSupplier<T> of(Supplier<T> tSupplier, Consumer<T> closeConsumer) {
        return new AutoCloseableSupplier<T>(Suppliers.memoize(() -> new AutoCloseableImpl(tSupplier.get(), closeConsumer)));
    }

    private AutoCloseableSupplier(Supplier<AutoCloseableImpl<T>> autoCloseableImplWrapper) {
        this.autoCloseableImplWrapper = autoCloseableImplWrapper;
    }

    @Override
    public AutoCloseableImpl<T> get() {
        return this.autoCloseableImplWrapper.get();
    }

    public T dangerouslyGetWithoutClosing() {
        return this.autoCloseableImplWrapper.get().value();
    }

    public <R> AutoCloseableSupplier<R> map(Function<T, R> mapper) {
        return new AutoCloseableSupplier<T>(() -> {
            T t = this.autoCloseableImplWrapper.get().value();
            return new AutoCloseableImpl<Object>(mapper.apply(t), r -> this.autoCloseableImplWrapper.get().closeConsumer.accept(t));
        });
    }

    public static class AutoCloseableImpl<T>
    implements AutoCloseable {
        private final T t;
        private final Consumer<T> closeConsumer;

        protected AutoCloseableImpl(T t, Consumer<T> closeConsumer) {
            this.t = t;
            this.closeConsumer = closeConsumer;
        }

        public T value() {
            return this.t;
        }

        @Override
        public void close() {
            this.closeConsumer.accept(this.t);
        }
    }
}

