/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.features;

import com.google.common.collect.ImmutableMap;
import com.hubspot.jinjava.features.FeatureActivationStrategy;
import com.hubspot.jinjava.features.FeatureStrategies;
import java.util.HashMap;
import java.util.Map;

public class FeatureConfig {
    Map<String, FeatureActivationStrategy> features;

    private FeatureConfig(Map<String, FeatureActivationStrategy> features) {
        this.features = ImmutableMap.copyOf(features);
    }

    public FeatureActivationStrategy getFeature(String name) {
        return this.features.getOrDefault(name, FeatureStrategies.INACTIVE);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, FeatureActivationStrategy> features = new HashMap<String, FeatureActivationStrategy>();

        public Builder add(String name, FeatureActivationStrategy strategy) {
            this.features.put(name, strategy);
            return this;
        }

        public FeatureConfig build() {
            return new FeatureConfig(this.features);
        }
    }
}

