/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.el.ext.eager;

import com.hubspot.jinjava.el.ext.DeferredParsingException;
import com.hubspot.jinjava.el.ext.IdentifierPreservationStrategy;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.MetaContextVariables;
import com.hubspot.jinjava.interpret.PartiallyDeferredValue;
import com.hubspot.jinjava.util.EagerExpressionResolver;
import java.util.Collection;
import java.util.function.Supplier;
import jinjava.de.odysseus.el.tree.Bindings;
import jinjava.de.odysseus.el.tree.impl.ast.AstIdentifier;
import jinjava.de.odysseus.el.tree.impl.ast.AstNode;
import jinjava.javax.el.ELContext;
import jinjava.javax.el.ELException;

public interface EvalResultHolder {
    public Object getEvalResult();

    public void setEvalResult(Object var1);

    public boolean hasEvalResult();

    default public Object eval(Supplier<Object> evalSupplier, Bindings bindings, ELContext context) {
        try {
            this.setEvalResult(evalSupplier.get());
            return this.checkEvalResultSize(context);
        }
        catch (DeferredValueException | ELException originalException) {
            DeferredParsingException e = EvalResultHolder.convertToDeferredParsingException(originalException);
            throw new DeferredParsingException(this, this.getPartiallyResolved(bindings, context, e, IdentifierPreservationStrategy.RESOLVING));
        }
    }

    default public Object checkEvalResultSize(ELContext context) {
        Object evalResult = this.getEvalResult();
        if (evalResult instanceof Collection && ((Collection)evalResult).size() > 100 && ((JinjavaInterpreter)context.getELResolver().getValue(context, null, "____int3rpr3t3r____")).getContext().isDeferLargeObjects()) {
            throw new DeferredValueException("Collection too big");
        }
        return evalResult;
    }

    public String getPartiallyResolved(Bindings var1, ELContext var2, DeferredParsingException var3, IdentifierPreservationStrategy var4);

    public static String reconstructNode(Bindings bindings, ELContext context, EvalResultHolder astNode, DeferredParsingException exception, IdentifierPreservationStrategy preserveIdentifier) {
        block13: {
            if (astNode == null) {
                return "";
            }
            if ((preserveIdentifier = IdentifierPreservationStrategy.preserving(preserveIdentifier.isPreserving() || astNode instanceof AstIdentifier && "____int3rpr3t3r____".equals(((AstIdentifier)((Object)astNode)).getName()))).isPreserving() && !astNode.hasEvalResult() && !EvalResultHolder.exceptionMatchesNode(exception, astNode)) {
                try {
                    EagerExpressionResolver.getValueAsJinjavaStringSafe(((AstNode)((Object)astNode)).eval(bindings, context));
                }
                catch (DeferredParsingException deferredParsingException) {
                    // empty catch block
                }
            }
            Object evalResult = astNode.getEvalResult();
            if (EvalResultHolder.exceptionMatchesNode(exception, astNode) && exception.getIdentifierPreservationStrategy().isPreserving()) {
                return exception.getDeferredEvalResult();
            }
            if (!preserveIdentifier.isPreserving() || astNode.hasEvalResult() && (EagerExpressionResolver.isPrimitive(evalResult) || evalResult instanceof PartiallyDeferredValue)) {
                if (EvalResultHolder.exceptionMatchesNode(exception, astNode)) {
                    return exception.getDeferredEvalResult();
                }
                if (!astNode.hasEvalResult()) {
                    try {
                        evalResult = ((AstNode)((Object)astNode)).eval(bindings, context);
                    }
                    catch (DeferredParsingException e) {
                        return e.getDeferredEvalResult();
                    }
                }
                try {
                    return EagerExpressionResolver.getValueAsJinjavaStringSafe(evalResult);
                }
                catch (DeferredValueException e) {
                    if (!(astNode instanceof AstIdentifier)) break block13;
                    String name = ((AstIdentifier)((Object)astNode)).getName();
                    if (MetaContextVariables.isMetaContextVariable(name, ((JinjavaInterpreter)context.getELResolver().getValue(context, null, "____int3rpr3t3r____")).getContext())) {
                        return name;
                    }
                    throw e;
                }
            }
        }
        return astNode.getPartiallyResolved(bindings, context, exception, IdentifierPreservationStrategy.PRESERVING);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DeferredParsingException convertToDeferredParsingException(RuntimeException original) {
        DeferredValueException deferredValueException;
        if (!(original instanceof DeferredValueException)) {
            if (!(original.getCause() instanceof DeferredValueException)) throw original;
            deferredValueException = (DeferredValueException)original.getCause();
        } else {
            deferredValueException = (DeferredValueException)original;
        }
        if (!(deferredValueException instanceof DeferredParsingException)) return null;
        return (DeferredParsingException)deferredValueException;
    }

    public static boolean exceptionMatchesNode(DeferredParsingException deferredParsingException, Object astNode) {
        return deferredParsingException != null && deferredParsingException.getSourceNode() == astNode;
    }
}

