/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.el.ext;

import java.util.List;
import jinjava.javax.el.ELContext;
import jinjava.javax.el.ListELResolver;

public class JinjavaListELResolver
extends ListELResolver {
    public JinjavaListELResolver(boolean readOnly) {
        super(readOnly);
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        try {
            return super.getType(context, base, property);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        try {
            return super.isReadOnly(context, base, property);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        try {
            int index;
            if (JinjavaListELResolver.isResolvable(base) && (index = JinjavaListELResolver.toIndex(property)) < 0) {
                property = index + ((List)base).size();
            }
            return super.getValue(context, base, property);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static boolean isResolvable(Object base) {
        return base instanceof List;
    }

    private static int toIndex(Object property) {
        int index;
        if (property instanceof Number) {
            index = ((Number)property).intValue();
        } else if (property instanceof String) {
            if (!JinjavaListELResolver.isNumeric((String)property)) {
                throw new IllegalArgumentException("Cannot parse list index: " + String.valueOf(property));
            }
            try {
                index = Integer.parseInt((String)property);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot parse list index: " + String.valueOf(property));
            }
        } else if (property instanceof Character) {
            index = ((Character)property).charValue();
        } else if (property instanceof Boolean) {
            index = (Boolean)property != false ? 1 : 0;
        } else {
            throw new IllegalArgumentException("Cannot coerce property to list index: " + String.valueOf(property));
        }
        return index;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        try {
            super.setValue(context, base, property, value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static boolean isNumeric(CharSequence cs) {
        if (cs == null || cs.length() == 0) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(cs.charAt(i)) || cs.charAt(i) == '-') continue;
            return false;
        }
        return true;
    }
}

