/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.el.ext;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableSet;
import com.hubspot.jinjava.el.ext.BeanELResolver;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.util.EagerReconstructionUtils;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.Set;
import jinjava.javax.el.ELContext;
import jinjava.javax.el.MethodNotFoundException;

public class JinjavaBeanELResolver
extends BeanELResolver {
    private static final Set<String> DEFAULT_RESTRICTED_PROPERTIES = ImmutableSet.builder().add((Object)"class").build();
    private static final Set<String> DEFAULT_RESTRICTED_METHODS = ImmutableSet.builder().add((Object)"class").add((Object)"clone").add((Object)"hashCode").add((Object)"getClass").add((Object)"getDeclaringClass").add((Object)"forName").add((Object)"notify").add((Object)"notifyAll").add((Object)"wait").build();
    private static final Set<String> DEFERRED_EXECUTION_RESTRICTED_METHODS = ImmutableSet.builder().add((Object)"put").add((Object)"putAll").add((Object)"update").add((Object)"add").add((Object)"insert").add((Object)"pop").add((Object)"append").add((Object)"extend").add((Object)"clear").add((Object)"remove").add((Object)"addAll").add((Object)"removeAll").add((Object)"replace").add((Object)"replaceAll").add((Object)"putIfAbsent").add((Object)"sort").add((Object)"set").add((Object)"merge").build();

    public JinjavaBeanELResolver() {
    }

    public JinjavaBeanELResolver(boolean readOnly) {
        super(readOnly);
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        return super.getType(context, base, this.validatePropertyName(property));
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        if (this.isRestrictedClass(base)) {
            return null;
        }
        Object result = super.getValue(context, base, this.validatePropertyName(property));
        return result instanceof Class ? null : result;
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        return super.isReadOnly(context, base, this.validatePropertyName(property));
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        super.setValue(context, base, this.validatePropertyName(property), value);
    }

    @Override
    public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        JinjavaInterpreter interpreter = JinjavaInterpreter.getCurrent();
        if (method == null || DEFAULT_RESTRICTED_METHODS.contains(method.toString()) || interpreter != null && interpreter.getConfig().getRestrictedMethods().contains(method.toString())) {
            throw new MethodNotFoundException("Cannot find method '" + String.valueOf(method) + "' in " + String.valueOf(base.getClass()));
        }
        if (this.isRestrictedClass(base)) {
            throw new MethodNotFoundException("Cannot find method '" + String.valueOf(method) + "' in " + String.valueOf(base.getClass()));
        }
        if (DEFERRED_EXECUTION_RESTRICTED_METHODS.contains(method.toString()) && EagerReconstructionUtils.isDeferredExecutionMode().booleanValue()) {
            throw new DeferredValueException(String.format("Cannot run method '%s' in %s in deferred execution mode", method, base.getClass()));
        }
        Object result = super.invoke(context, base, method, paramTypes, params);
        if (this.isRestrictedClass(result)) {
            throw new MethodNotFoundException("Cannot find method '" + String.valueOf(method) + "' in " + String.valueOf(base.getClass()));
        }
        return result;
    }

    @Override
    protected Method findMethod(Object base, String name, Class<?>[] types, Object[] params, int paramCount) {
        if (types != null) {
            return super.findMethod(base, name, types, params, paramCount);
        }
        Method varArgsMethod = null;
        Method[] methods = base.getClass().getMethods();
        LinkedList<Method> potentialMethods = new LinkedList<Method>();
        for (Method method2 : methods) {
            if (!method2.getName().equals(name)) continue;
            int formalParamCount = method2.getParameterTypes().length;
            if (method2.isVarArgs() && paramCount >= formalParamCount - 1) {
                varArgsMethod = method2;
                continue;
            }
            if (paramCount != formalParamCount) continue;
            potentialMethods.add(JinjavaBeanELResolver.findAccessibleMethod(method2));
        }
        Method finalVarArgsMethod = varArgsMethod;
        return potentialMethods.stream().filter(method -> JinjavaBeanELResolver.checkAssignableParameterTypes(params, method)).min(JinjavaBeanELResolver::pickMoreSpecificMethod).orElseGet(() -> potentialMethods.stream().findAny().orElseGet(() -> finalVarArgsMethod == null ? null : JinjavaBeanELResolver.findAccessibleMethod(finalVarArgsMethod)));
    }

    private static boolean checkAssignableParameterTypes(Object[] params, Method method) {
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            TypeDescriptor.OfField<Class<?>> paramType = method.getParameterTypes()[i];
            if (((Class)paramType).isPrimitive()) {
                paramType = MethodType.methodType(paramType).wrap().returnType();
            }
            if (params[i] == null || ((Class)paramType).isAssignableFrom(params[i].getClass())) continue;
            return false;
        }
        return true;
    }

    private static int pickMoreSpecificMethod(Method methodA, Method methodB) {
        Class<?>[] typesA = methodA.getParameterTypes();
        Class<?>[] typesB = methodB.getParameterTypes();
        for (int i = 0; i < typesA.length; ++i) {
            if (typesA[i].isAssignableFrom(typesB[i])) continue;
            if (typesB[i].isPrimitive()) {
                return 1;
            }
            return -1;
        }
        return 1;
    }

    private String validatePropertyName(Object property) {
        String propertyName = this.transformPropertyName(property);
        JinjavaInterpreter interpreter = JinjavaInterpreter.getCurrent();
        if (DEFAULT_RESTRICTED_PROPERTIES.contains(propertyName) || interpreter != null && interpreter.getConfig().getRestrictedProperties().contains(propertyName)) {
            return null;
        }
        return propertyName;
    }

    private String transformPropertyName(Object property) {
        if (property == null) {
            return null;
        }
        String propertyStr = property.toString();
        if (propertyStr.indexOf(95) == -1) {
            return propertyStr;
        }
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, propertyStr);
    }

    protected boolean isRestrictedClass(Object o) {
        if (o == null) {
            return false;
        }
        return o.getClass().getPackage() != null && o.getClass().getPackage().getName().startsWith("java.lang.reflect") || o instanceof Class || o instanceof ClassLoader || o instanceof Thread || o instanceof Method || o instanceof Field || o instanceof Constructor || o instanceof JinjavaInterpreter;
    }
}

