/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.el.ext;

import com.google.common.collect.ImmutableMap;
import com.hubspot.algebra.Result;
import com.hubspot.jinjava.el.ext.AbstractCallableMethod;
import com.hubspot.jinjava.interpret.AutoCloseableSupplier;
import com.hubspot.jinjava.interpret.CallStack;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TagCycleException;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.interpret.errorcategory.BasicTemplateErrorCategory;
import com.hubspot.jinjava.lib.fn.MacroFunction;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import jinjava.de.odysseus.el.misc.LocalMessages;
import jinjava.de.odysseus.el.tree.Bindings;
import jinjava.de.odysseus.el.tree.impl.ast.AstFunction;
import jinjava.de.odysseus.el.tree.impl.ast.AstParameters;
import jinjava.javax.el.ELContext;
import jinjava.javax.el.ELException;

public class AstMacroFunction
extends AstFunction {
    public AstMacroFunction(String name, int index, AstParameters params, boolean varargs) {
        super(name, index, params, varargs);
    }

    @Override
    public Object eval(Bindings bindings, ELContext context) {
        JinjavaInterpreter interpreter = (JinjavaInterpreter)context.getELResolver().getValue(context, null, "____int3rpr3t3r____");
        MacroFunction macroFunction = interpreter.getContext().getGlobalMacro(this.getName());
        if (macroFunction != null) {
            if (macroFunction.isDeferred()) {
                throw new DeferredValueException(this.getName(), interpreter.getLineNumber(), interpreter.getPosition());
            }
            if (macroFunction.isCaller()) {
                return this.wrapInvoke(bindings, context, macroFunction);
            }
            try (Object macroStackPush = AstMacroFunction.checkAndPushMacroStackWithWrapper(interpreter, this.getName()).get();){
                Object object = ((Result)((AutoCloseableSupplier.AutoCloseableImpl)macroStackPush).value()).match(err -> "", path -> this.wrapInvoke(bindings, context, macroFunction));
                return object;
            }
        }
        return interpreter.getContext().isValidationMode() ? "" : super.eval(bindings, context);
    }

    private Object wrapInvoke(Bindings bindings, ELContext context, MacroFunction macroFunction) {
        try {
            return this.invoke(bindings, context, macroFunction, AbstractCallableMethod.EVAL_METHOD);
        }
        catch (IllegalAccessException e) {
            throw new ELException(LocalMessages.get("error.function.access", this.getName()), e);
        }
        catch (InvocationTargetException e) {
            throw new ELException(LocalMessages.get("error.function.invocation", this.getName()), e.getCause());
        }
    }

    public static AutoCloseableSupplier<Result<String, MacroCallError>> checkAndPushMacroStackWithWrapper(JinjavaInterpreter interpreter, String name) {
        CallStack macroStack = interpreter.getContext().getMacroStack();
        if (interpreter.getConfig().isEnableRecursiveMacroCalls()) {
            if (interpreter.getConfig().getMaxMacroRecursionDepth() != 0) {
                return macroStack.closeablePushWithMaxDepth(name, interpreter.getConfig().getMaxMacroRecursionDepth(), interpreter.getLineNumber(), interpreter.getPosition()).map(result -> result.mapErr(err -> {
                    AstMacroFunction.handleMacroCycleError(interpreter, name, err);
                    return MacroCallError.CYCLE_DETECTED;
                }));
            }
            return macroStack.closeablePushWithoutCycleCheck(name, interpreter.getLineNumber(), interpreter.getPosition()).map(Result::ok);
        }
        return macroStack.closeablePush(name, -1, -1).map(result -> result.mapErr(err -> {
            AstMacroFunction.handleMacroCycleError(interpreter, name, err);
            return MacroCallError.CYCLE_DETECTED;
        }));
    }

    private static void handleMacroCycleError(JinjavaInterpreter interpreter, String name, TagCycleException e) {
        int maxDepth = interpreter.getConfig().getMaxMacroRecursionDepth();
        if (maxDepth != 0 && interpreter.getConfig().isValidationMode()) {
            return;
        }
        String message = maxDepth == 0 ? String.format("Cycle detected for macro '%s'", name) : String.format("Max recursion limit of %d reached for macro '%s'", maxDepth, name);
        interpreter.addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.EXCEPTION, TemplateError.ErrorItem.TAG, message, null, e.getLineNumber(), e.getStartPosition(), e, BasicTemplateErrorCategory.CYCLE_DETECTED, (Map<String, String>)ImmutableMap.of((Object)"name", (Object)name)));
    }

    @Deprecated
    public static boolean checkAndPushMacroStack(JinjavaInterpreter interpreter, String name) {
        return (Boolean)AstMacroFunction.checkAndPushMacroStackWithWrapper(interpreter, name).dangerouslyGetWithoutClosing().match(err -> true, ok -> false);
    }

    public static enum MacroCallError {
        CYCLE_DETECTED;

    }
}

