/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.el;

import com.google.common.collect.ImmutableMap;
import com.hubspot.jinjava.el.ObjectUnwrapper;
import com.hubspot.jinjava.el.TypeConvertingMapELResolver;
import com.hubspot.jinjava.el.ext.AbstractCallableMethod;
import com.hubspot.jinjava.el.ext.DeferredParsingException;
import com.hubspot.jinjava.el.ext.JinjavaBeanELResolver;
import com.hubspot.jinjava.el.ext.JinjavaListELResolver;
import com.hubspot.jinjava.el.ext.NamedParameter;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.DisabledException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.interpret.errorcategory.BasicTemplateErrorCategory;
import com.hubspot.jinjava.objects.Namespace;
import com.hubspot.jinjava.objects.PyWrapper;
import com.hubspot.jinjava.objects.collections.SizeLimitingPyList;
import com.hubspot.jinjava.objects.collections.SizeLimitingPyMap;
import com.hubspot.jinjava.objects.date.FormattedDate;
import com.hubspot.jinjava.objects.date.InvalidDateFormatException;
import com.hubspot.jinjava.objects.date.PyishDate;
import com.hubspot.jinjava.objects.date.StrftimeFormatter;
import com.hubspot.jinjava.objects.serialization.PyishSerializable;
import com.hubspot.jinjava.util.DeferredValueUtils;
import com.hubspot.jinjava.util.Logging;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import jinjava.de.odysseus.el.util.SimpleResolver;
import jinjava.javax.el.ArrayELResolver;
import jinjava.javax.el.CompositeELResolver;
import jinjava.javax.el.ELContext;
import jinjava.javax.el.ELResolver;
import jinjava.javax.el.PropertyNotFoundException;
import jinjava.javax.el.ResourceBundleELResolver;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;

public class JinjavaInterpreterResolver
extends SimpleResolver {
    public static final ELResolver DEFAULT_RESOLVER_READ_ONLY = new CompositeELResolver(){
        {
            this.add(new ArrayELResolver(true));
            this.add(new JinjavaListELResolver(true));
            this.add(new TypeConvertingMapELResolver(true));
            this.add(new ResourceBundleELResolver());
            this.add(new JinjavaBeanELResolver(true));
        }
    };
    public static final ELResolver DEFAULT_RESOLVER_READ_WRITE = new CompositeELResolver(){
        {
            this.add(new ArrayELResolver(false));
            this.add(new JinjavaListELResolver(false));
            this.add(new TypeConvertingMapELResolver(false));
            this.add(new ResourceBundleELResolver());
            this.add(new JinjavaBeanELResolver(false));
        }
    };
    private final JinjavaInterpreter interpreter;
    private final ObjectUnwrapper objectUnwrapper;

    public JinjavaInterpreterResolver(JinjavaInterpreter interpreter) {
        super(interpreter.getConfig().getElResolver());
        this.interpreter = interpreter;
        this.objectUnwrapper = interpreter.getConfig().getObjectUnwrapper();
    }

    @Override
    public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        try {
            Object methodProperty = this.getValue(context, base, method, false);
            if (methodProperty instanceof AbstractCallableMethod) {
                String result = this.interpreter.getContext().isValidationMode() ? "" : ((AbstractCallableMethod)methodProperty).evaluate(params);
                context.setPropertyResolved(true);
                return result;
            }
        }
        catch (IllegalArgumentException methodProperty) {
            // empty catch block
        }
        try {
            return this.interpreter.getContext().isValidationMode() ? "" : super.invoke(context, base, method, paramTypes, this.generateMethodParams(method, params));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        return this.getValue(context, base, property, true);
    }

    private Object[] generateMethodParams(Object method, Object[] astParams) {
        if (!"filter".equals(method)) {
            return astParams;
        }
        if (astParams == null) {
            throw new IllegalArgumentException("AST params cannot be null");
        }
        ArrayList<Object> args = new ArrayList<Object>();
        LinkedHashMap<String, Object> kwargs = new LinkedHashMap<String, Object>();
        for (Object param : Arrays.asList(astParams).subList(2, astParams.length)) {
            if (param instanceof NamedParameter) {
                NamedParameter namedParameter = (NamedParameter)param;
                kwargs.put(namedParameter.getName(), namedParameter.getValue());
                continue;
            }
            args.add(param);
        }
        return new Object[]{astParams[0], astParams[1], args.toArray(), kwargs};
    }

    private Object getValue(ELContext context, Object base, Object property, boolean errOnUnknownProp) {
        Object value;
        block14: {
            String propertyName = Objects.toString(property, "");
            value = null;
            this.interpreter.getContext().addResolvedValue(propertyName);
            TemplateError.ErrorItem item = TemplateError.ErrorItem.PROPERTY;
            try {
                if ("____int3rpr3t3r____".equals(property)) {
                    value = this.interpreter;
                    break block14;
                }
                if (propertyName.startsWith("filter:")) {
                    item = TemplateError.ErrorItem.FILTER;
                    value = this.interpreter.getContext().getFilter(StringUtils.substringAfter((String)propertyName, (String)"filter:"));
                    break block14;
                }
                if (propertyName.startsWith("exptest:")) {
                    item = TemplateError.ErrorItem.EXPRESSION_TEST;
                    value = this.interpreter.getContext().getExpTest(StringUtils.substringAfter((String)propertyName, (String)"exptest:"));
                    break block14;
                }
                if (base == null) {
                    value = this.interpreter.retraceVariable((String)property, this.interpreter.getLineNumber(), -1);
                    break block14;
                }
                try {
                    int propertyNum;
                    base = this.objectUnwrapper.unwrapObject(base);
                    if (base == null) {
                        return null;
                    }
                    if (base.getClass().isArray() && (property instanceof Integer || property instanceof Long) && (propertyNum = ((Number)property).intValue()) < 0) {
                        propertyName = String.valueOf(propertyNum += ((Object[])base).length);
                    }
                    value = super.getValue(context, base, propertyName);
                    if ((value = this.objectUnwrapper.unwrapObject(value)) == null) {
                        return null;
                    }
                    if (DeferredValueUtils.isFullyDeferred(value)) {
                        if (this.interpreter.getConfig().getExecutionMode().useEagerParser()) {
                            throw new DeferredParsingException(this, propertyName);
                        }
                        throw new DeferredValueException(propertyName, this.interpreter.getLineNumber(), this.interpreter.getPosition());
                    }
                }
                catch (PropertyNotFoundException e) {
                    if (errOnUnknownProp) {
                        this.interpreter.addError(TemplateError.fromUnknownProperty(base, propertyName, this.interpreter.getLineNumber(), -1));
                    }
                }
            }
            catch (DisabledException e) {
                this.interpreter.addError(new TemplateError(TemplateError.ErrorType.FATAL, TemplateError.ErrorReason.DISABLED, item, e.getMessage(), propertyName, this.interpreter.getLineNumber(), -1, e));
            }
        }
        context.setPropertyResolved(true);
        return this.wrap(value);
    }

    Object wrap(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof PyishSerializable) {
            return value;
        }
        if ((value = this.objectUnwrapper.unwrapObject(value)) == null) {
            return null;
        }
        if (value instanceof PyWrapper) {
            return value;
        }
        if (value instanceof Namespace) {
            return new SizeLimitingPyMap((Map<String, Object>)((Object)((Namespace)value)), this.interpreter.getConfig().getMaxMapSize());
        }
        if (List.class.isAssignableFrom(value.getClass())) {
            return new SizeLimitingPyList((List)value, this.interpreter.getConfig().getMaxListSize());
        }
        if (Map.class.isAssignableFrom(value.getClass())) {
            return new SizeLimitingPyMap((Map)value, this.interpreter.getConfig().getMaxMapSize());
        }
        if (Date.class.isAssignableFrom(value.getClass())) {
            return new PyishDate(JinjavaInterpreterResolver.localizeDateTime(this.interpreter, ZonedDateTime.ofInstant(Instant.ofEpochMilli(((Date)value).getTime()), ZoneOffset.UTC)));
        }
        if (ZonedDateTime.class.isAssignableFrom(value.getClass())) {
            return new PyishDate(JinjavaInterpreterResolver.localizeDateTime(this.interpreter, (ZonedDateTime)value));
        }
        if (FormattedDate.class.isAssignableFrom(value.getClass())) {
            return JinjavaInterpreterResolver.formattedDateToString(this.interpreter, (FormattedDate)value);
        }
        return value;
    }

    private static ZonedDateTime localizeDateTime(JinjavaInterpreter interpreter, ZonedDateTime dt) {
        Logging.ENGINE_LOG.debug("Using timezone: {} to localize datetime: {}", (Object)interpreter.getConfig().getTimeZone(), (Object)dt);
        return dt.withZoneSameInstant(interpreter.getConfig().getTimeZone());
    }

    private static String formattedDateToString(JinjavaInterpreter interpreter, FormattedDate d) {
        ZonedDateTime zonedDateTime = JinjavaInterpreterResolver.localizeDateTime(interpreter, d.getDate());
        Locale locale = JinjavaInterpreterResolver.getLocale(interpreter, d);
        if (!StringUtils.isBlank((CharSequence)d.getFormat())) {
            try {
                return StrftimeFormatter.format(zonedDateTime, d.getFormat(), locale);
            }
            catch (InvalidDateFormatException e) {
                interpreter.addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.SYNTAX_ERROR, TemplateError.ErrorItem.OTHER, e.getMessage(), null, interpreter.getLineNumber(), -1, null, BasicTemplateErrorCategory.UNKNOWN_DATE, (Map<String, String>)ImmutableMap.of((Object)"date", (Object)d.getDate().toString(), (Object)"exception", (Object)e.getMessage(), (Object)"lineNumber", (Object)String.valueOf(interpreter.getLineNumber()))));
            }
        }
        return StrftimeFormatter.format(zonedDateTime, "medium", locale);
    }

    private static Locale getLocale(JinjavaInterpreter interpreter, FormattedDate d) {
        if (!StringUtils.isBlank((CharSequence)d.getLanguage())) {
            try {
                return LocaleUtils.toLocale((String)d.getLanguage());
            }
            catch (IllegalArgumentException e) {
                interpreter.addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.SYNTAX_ERROR, TemplateError.ErrorItem.OTHER, e.getMessage(), null, interpreter.getLineNumber(), -1, null, BasicTemplateErrorCategory.UNKNOWN_LOCALE, (Map<String, String>)ImmutableMap.of((Object)"date", (Object)d.getDate().toString(), (Object)"exception", (Object)e.getMessage(), (Object)"lineNumber", (Object)String.valueOf(interpreter.getLineNumber()))));
            }
        }
        return Locale.US;
    }
}

