/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.common.collect.ImmutableSet;
import com.hubspot.jinjava.LegacyOverrides;
import com.hubspot.jinjava.el.JinjavaInterpreterResolver;
import com.hubspot.jinjava.el.JinjavaObjectUnwrapper;
import com.hubspot.jinjava.el.JinjavaProcessors;
import com.hubspot.jinjava.el.ObjectUnwrapper;
import com.hubspot.jinjava.features.FeatureConfig;
import com.hubspot.jinjava.features.Features;
import com.hubspot.jinjava.interpret.Context;
import com.hubspot.jinjava.interpret.InterpreterFactory;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.JinjavaInterpreterFactory;
import com.hubspot.jinjava.mode.DefaultExecutionMode;
import com.hubspot.jinjava.mode.ExecutionMode;
import com.hubspot.jinjava.objects.date.CurrentDateTimeProvider;
import com.hubspot.jinjava.objects.date.DateTimeProvider;
import com.hubspot.jinjava.random.RandomNumberGeneratorStrategy;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.parse.DefaultTokenScannerSymbols;
import com.hubspot.jinjava.tree.parse.TokenScannerSymbols;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import jinjava.javax.el.ELResolver;

public class JinjavaConfig {
    private final Charset charset;
    private final Locale locale;
    private final ZoneId timeZone;
    private final int maxRenderDepth;
    private final long maxOutputSize;
    private final boolean trimBlocks;
    private final boolean lstripBlocks;
    private final boolean enableRecursiveMacroCalls;
    private final int maxMacroRecursionDepth;
    private final Map<Context.Library, Set<String>> disabled;
    private final Set<String> restrictedMethods;
    private final Set<String> restrictedProperties;
    private final boolean failOnUnknownTokens;
    private final boolean nestedInterpretationEnabled;
    private final RandomNumberGeneratorStrategy randomNumberGenerator;
    private final boolean validationMode;
    private final long maxStringLength;
    private final int maxListSize;
    private final int maxMapSize;
    private final int rangeLimit;
    private final int maxNumDeferredTokens;
    private final InterpreterFactory interpreterFactory;
    private final DateTimeProvider dateTimeProvider;
    private TokenScannerSymbols tokenScannerSymbols;
    private final ELResolver elResolver;
    private final ExecutionMode executionMode;
    private final LegacyOverrides legacyOverrides;
    private final boolean enablePreciseDivideFilter;
    private final ObjectMapper objectMapper;
    private final Features features;
    private final ObjectUnwrapper objectUnwrapper;
    private final JinjavaProcessors processors;

    public static Builder newBuilder() {
        return new Builder();
    }

    public JinjavaConfig() {
        this(JinjavaConfig.newBuilder());
    }

    public JinjavaConfig(InterpreterFactory interpreterFactory) {
        this(JinjavaConfig.newBuilder().withInterperterFactory(interpreterFactory));
    }

    public JinjavaConfig(Charset charset, Locale locale, ZoneId timeZone, int maxRenderDepth) {
        this(JinjavaConfig.newBuilder().withCharset(charset).withLocale(locale).withTimeZone(timeZone).withMaxRenderDepth(maxRenderDepth));
    }

    private JinjavaConfig(Builder builder) {
        this.charset = builder.charset;
        this.locale = builder.locale;
        this.timeZone = builder.timeZone;
        this.maxRenderDepth = builder.maxRenderDepth;
        this.disabled = builder.disabled;
        this.restrictedMethods = builder.restrictedMethods;
        this.restrictedProperties = builder.restrictedProperties;
        this.trimBlocks = builder.trimBlocks;
        this.lstripBlocks = builder.lstripBlocks;
        this.enableRecursiveMacroCalls = builder.enableRecursiveMacroCalls;
        this.maxMacroRecursionDepth = builder.maxMacroRecursionDepth;
        this.failOnUnknownTokens = builder.failOnUnknownTokens;
        this.maxOutputSize = builder.maxOutputSize;
        this.nestedInterpretationEnabled = builder.nestedInterpretationEnabled;
        this.randomNumberGenerator = builder.randomNumberGeneratorStrategy;
        this.validationMode = builder.validationMode;
        this.maxStringLength = builder.maxStringLength;
        this.maxListSize = builder.maxListSize;
        this.maxMapSize = builder.maxMapSize;
        this.rangeLimit = builder.rangeLimit;
        this.maxNumDeferredTokens = builder.maxNumDeferredTokens;
        this.interpreterFactory = builder.interpreterFactory;
        this.tokenScannerSymbols = builder.tokenScannerSymbols;
        this.elResolver = builder.elResolver;
        this.executionMode = builder.executionMode;
        this.legacyOverrides = builder.legacyOverrides;
        this.dateTimeProvider = builder.dateTimeProvider;
        this.enablePreciseDivideFilter = builder.enablePreciseDivideFilter;
        this.objectMapper = this.setupObjectMapper(builder.objectMapper);
        this.objectUnwrapper = builder.objectUnwrapper;
        this.processors = builder.processors;
        this.features = new Features(builder.featureConfig);
    }

    private ObjectMapper setupObjectMapper(@Nullable ObjectMapper objectMapper) {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper().registerModule((Module)new Jdk8Module());
            if (this.legacyOverrides.isUseSnakeCasePropertyNaming()) {
                objectMapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
            }
        }
        return objectMapper;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public int getMaxRenderDepth() {
        return this.maxRenderDepth;
    }

    public long getMaxOutputSize() {
        return this.maxOutputSize;
    }

    public int getMaxListSize() {
        return this.maxListSize;
    }

    public int getMaxMapSize() {
        return this.maxMapSize;
    }

    public int getRangeLimit() {
        return this.rangeLimit;
    }

    public int getMaxNumDeferredTokens() {
        return this.maxNumDeferredTokens;
    }

    public RandomNumberGeneratorStrategy getRandomNumberGeneratorStrategy() {
        return this.randomNumberGenerator;
    }

    public boolean isTrimBlocks() {
        return this.trimBlocks;
    }

    public boolean isLstripBlocks() {
        return this.lstripBlocks;
    }

    public boolean isEnableRecursiveMacroCalls() {
        return this.enableRecursiveMacroCalls;
    }

    public int getMaxMacroRecursionDepth() {
        return this.maxMacroRecursionDepth;
    }

    public Map<Context.Library, Set<String>> getDisabled() {
        return this.disabled;
    }

    public Set<String> getRestrictedMethods() {
        return this.restrictedMethods;
    }

    public Set<String> getRestrictedProperties() {
        return this.restrictedProperties;
    }

    public boolean isFailOnUnknownTokens() {
        return this.failOnUnknownTokens;
    }

    public boolean isNestedInterpretationEnabled() {
        return this.nestedInterpretationEnabled;
    }

    public boolean isValidationMode() {
        return this.validationMode;
    }

    public long getMaxStringLength() {
        return this.maxStringLength == 0L ? this.getMaxOutputSize() : this.maxStringLength;
    }

    public InterpreterFactory getInterpreterFactory() {
        return this.interpreterFactory;
    }

    public TokenScannerSymbols getTokenScannerSymbols() {
        return this.tokenScannerSymbols;
    }

    public void setTokenScannerSymbols(TokenScannerSymbols tokenScannerSymbols) {
        this.tokenScannerSymbols = tokenScannerSymbols;
    }

    public ELResolver getElResolver() {
        return this.elResolver;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public ObjectUnwrapper getObjectUnwrapper() {
        return this.objectUnwrapper;
    }

    @Deprecated
    public BiConsumer<Node, JinjavaInterpreter> getNodePreProcessor() {
        return this.processors.getNodePreProcessor();
    }

    public JinjavaProcessors getProcessors() {
        return this.processors;
    }

    @Deprecated
    public boolean isIterateOverMapKeys() {
        return this.legacyOverrides.isIterateOverMapKeys();
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public LegacyOverrides getLegacyOverrides() {
        return this.legacyOverrides;
    }

    public boolean getEnablePreciseDivideFilter() {
        return this.enablePreciseDivideFilter;
    }

    public DateTimeProvider getDateTimeProvider() {
        return this.dateTimeProvider;
    }

    public Features getFeatures() {
        return this.features;
    }

    public static class Builder {
        private Charset charset = StandardCharsets.UTF_8;
        private Locale locale = Locale.ENGLISH;
        private ZoneId timeZone = ZoneOffset.UTC;
        private int maxRenderDepth = 10;
        private long maxOutputSize = 0L;
        private Map<Context.Library, Set<String>> disabled = new HashMap<Context.Library, Set<String>>();
        private Set<String> restrictedMethods = ImmutableSet.of();
        private Set<String> restrictedProperties = ImmutableSet.of();
        private boolean trimBlocks;
        private boolean lstripBlocks;
        private boolean enableRecursiveMacroCalls;
        private int maxMacroRecursionDepth;
        private boolean failOnUnknownTokens;
        private boolean nestedInterpretationEnabled = true;
        private RandomNumberGeneratorStrategy randomNumberGeneratorStrategy = RandomNumberGeneratorStrategy.THREAD_LOCAL;
        private DateTimeProvider dateTimeProvider = new CurrentDateTimeProvider();
        private boolean validationMode = false;
        private long maxStringLength = 0L;
        private int rangeLimit = 1000;
        private int maxNumDeferredTokens = 1000;
        private InterpreterFactory interpreterFactory = new JinjavaInterpreterFactory();
        private TokenScannerSymbols tokenScannerSymbols = new DefaultTokenScannerSymbols();
        private ELResolver elResolver = JinjavaInterpreterResolver.DEFAULT_RESOLVER_READ_ONLY;
        private int maxListSize = Integer.MAX_VALUE;
        private int maxMapSize = Integer.MAX_VALUE;
        private ExecutionMode executionMode = DefaultExecutionMode.instance();
        private LegacyOverrides legacyOverrides = LegacyOverrides.NONE;
        private boolean enablePreciseDivideFilter = false;
        private ObjectMapper objectMapper = null;
        private ObjectUnwrapper objectUnwrapper = new JinjavaObjectUnwrapper();
        private JinjavaProcessors processors = JinjavaProcessors.newBuilder().build();
        private FeatureConfig featureConfig = FeatureConfig.newBuilder().build();

        private Builder() {
        }

        public Builder withCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder withLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder withTimeZone(ZoneId timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public Builder withDisabled(Map<Context.Library, Set<String>> disabled) {
            this.disabled = disabled;
            return this;
        }

        public Builder withRestrictedMethods(Set<String> restrictedMethods) {
            this.restrictedMethods = ImmutableSet.copyOf(restrictedMethods);
            return this;
        }

        public Builder withRestrictedProperties(Set<String> restrictedProperties) {
            this.restrictedProperties = ImmutableSet.copyOf(restrictedProperties);
            return this;
        }

        public Builder withMaxRenderDepth(int maxRenderDepth) {
            this.maxRenderDepth = maxRenderDepth;
            return this;
        }

        public Builder withRandomNumberGeneratorStrategy(RandomNumberGeneratorStrategy randomNumberGeneratorStrategy) {
            this.randomNumberGeneratorStrategy = randomNumberGeneratorStrategy;
            return this;
        }

        public Builder withDateTimeProvider(DateTimeProvider dateTimeProvider) {
            this.dateTimeProvider = dateTimeProvider;
            return this;
        }

        public Builder withTrimBlocks(boolean trimBlocks) {
            this.trimBlocks = trimBlocks;
            return this;
        }

        public Builder withLstripBlocks(boolean lstripBlocks) {
            this.lstripBlocks = lstripBlocks;
            return this;
        }

        public Builder withEnableRecursiveMacroCalls(boolean enableRecursiveMacroCalls) {
            this.enableRecursiveMacroCalls = enableRecursiveMacroCalls;
            return this;
        }

        public Builder withMaxMacroRecursionDepth(int maxMacroRecursionDepth) {
            this.maxMacroRecursionDepth = maxMacroRecursionDepth;
            return this;
        }

        public Builder withReadOnlyResolver(boolean readOnlyResolver) {
            this.elResolver = readOnlyResolver ? JinjavaInterpreterResolver.DEFAULT_RESOLVER_READ_ONLY : JinjavaInterpreterResolver.DEFAULT_RESOLVER_READ_WRITE;
            return this;
        }

        public Builder withElResolver(ELResolver elResolver) {
            this.elResolver = elResolver;
            return this;
        }

        public Builder withFailOnUnknownTokens(boolean failOnUnknownTokens) {
            this.failOnUnknownTokens = failOnUnknownTokens;
            return this;
        }

        public Builder withMaxOutputSize(long maxOutputSize) {
            this.maxOutputSize = maxOutputSize;
            return this;
        }

        public Builder withNestedInterpretationEnabled(boolean nestedInterpretationEnabled) {
            this.nestedInterpretationEnabled = nestedInterpretationEnabled;
            return this;
        }

        public Builder withValidationMode(boolean validationMode) {
            this.validationMode = validationMode;
            return this;
        }

        public Builder withMaxStringLength(long maxStringLength) {
            this.maxStringLength = maxStringLength;
            return this;
        }

        public Builder withMaxListSize(int maxListSize) {
            this.maxListSize = maxListSize;
            return this;
        }

        public Builder withMaxMapSize(int maxMapSize) {
            this.maxMapSize = maxMapSize;
            return this;
        }

        public Builder withRangeLimit(int rangeLimit) {
            this.rangeLimit = rangeLimit;
            return this;
        }

        public Builder withMaxNumDeferredTokens(int maxNumDeferredTokens) {
            this.maxNumDeferredTokens = maxNumDeferredTokens;
            return this;
        }

        public Builder withInterperterFactory(InterpreterFactory interperterFactory) {
            this.interpreterFactory = interperterFactory;
            return this;
        }

        public Builder withTokenScannerSymbols(TokenScannerSymbols tokenScannerSymbols) {
            this.tokenScannerSymbols = tokenScannerSymbols;
            return this;
        }

        @Deprecated
        public Builder withIterateOverMapKeys(boolean iterateOverMapKeys) {
            return this.withLegacyOverrides(LegacyOverrides.Builder.from(this.legacyOverrides).withIterateOverMapKeys(iterateOverMapKeys).build());
        }

        public Builder withExecutionMode(ExecutionMode executionMode) {
            this.executionMode = executionMode;
            return this;
        }

        public Builder withLegacyOverrides(LegacyOverrides legacyOverrides) {
            this.legacyOverrides = legacyOverrides;
            return this;
        }

        public Builder withEnablePreciseDivideFilter(boolean enablePreciseDivideFilter) {
            this.enablePreciseDivideFilter = enablePreciseDivideFilter;
            return this;
        }

        public Builder withObjectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder withObjectUnwrapper(ObjectUnwrapper objectUnwrapper) {
            this.objectUnwrapper = objectUnwrapper;
            return this;
        }

        @Deprecated
        public Builder withNodePreProcessor(BiConsumer<Node, JinjavaInterpreter> nodePreProcessor) {
            this.processors = JinjavaProcessors.newBuilder(this.processors).withNodePreProcessor(nodePreProcessor).build();
            return this;
        }

        public Builder withProcessors(JinjavaProcessors jinjavaProcessors) {
            this.processors = jinjavaProcessors;
            return this;
        }

        public Builder withFeatureConfig(FeatureConfig featureConfig) {
            this.featureConfig = featureConfig;
            return this;
        }

        public JinjavaConfig build() {
            return new JinjavaConfig(this);
        }
    }
}

