/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava;

import com.hubspot.jinjava.JinjavaConfig;
import com.hubspot.jinjava.doc.JinjavaDoc;
import com.hubspot.jinjava.doc.JinjavaDocFactory;
import com.hubspot.jinjava.el.ExtendedSyntaxBuilder;
import com.hubspot.jinjava.el.TruthyTypeConverter;
import com.hubspot.jinjava.el.ext.eager.EagerExtendedSyntaxBuilder;
import com.hubspot.jinjava.interpret.Context;
import com.hubspot.jinjava.interpret.FatalTemplateErrorsException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.RenderResult;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.lib.exptest.ExpTest;
import com.hubspot.jinjava.lib.filter.Filter;
import com.hubspot.jinjava.lib.fn.ELFunctionDefinition;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.loader.ClasspathResourceLocator;
import com.hubspot.jinjava.loader.ResourceLocator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import jinjava.de.odysseus.el.ExpressionFactoryImpl;
import jinjava.de.odysseus.el.misc.TypeConverter;
import jinjava.de.odysseus.el.tree.TreeBuilder;
import jinjava.javax.el.ExpressionFactory;

public class Jinjava {
    private ExpressionFactory expressionFactory;
    private ExpressionFactory eagerExpressionFactory;
    private ResourceLocator resourceLocator;
    private Context globalContext;
    private JinjavaConfig globalConfig;

    public Jinjava() {
        this(new JinjavaConfig());
    }

    public Jinjava(JinjavaConfig globalConfig) {
        this.globalConfig = globalConfig;
        this.globalContext = new Context();
        Properties expConfig = new Properties();
        expConfig.setProperty(TreeBuilder.class.getName(), ExtendedSyntaxBuilder.class.getName());
        Properties eagerExpConfig = new Properties();
        eagerExpConfig.setProperty(TreeBuilder.class.getName(), EagerExtendedSyntaxBuilder.class.getName());
        eagerExpConfig.setProperty("jinjava.javax.el.cacheSize", "0");
        TruthyTypeConverter converter = new TruthyTypeConverter();
        this.expressionFactory = new ExpressionFactoryImpl(expConfig, (TypeConverter)converter);
        this.eagerExpressionFactory = new ExpressionFactoryImpl(eagerExpConfig, (TypeConverter)converter);
        this.resourceLocator = new ClasspathResourceLocator();
    }

    public void setResourceLocator(ResourceLocator resourceLocator) {
        this.resourceLocator = resourceLocator;
    }

    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }

    public ExpressionFactory getEagerExpressionFactory() {
        return this.eagerExpressionFactory;
    }

    public JinjavaConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public Context getGlobalContext() {
        return this.globalContext;
    }

    public Context getGlobalContextCopy() {
        return this.copyGlobalContext();
    }

    public ResourceLocator getResourceLocator() {
        return this.resourceLocator;
    }

    public JinjavaDoc getJinjavaDoc() {
        return new JinjavaDocFactory(this).get();
    }

    public String getJinjavaSnippetDoc() {
        return new JinjavaDocFactory(this).getCodeEditorTagSnippets();
    }

    public String render(String template, Map<String, ?> bindings) {
        RenderResult result = this.renderForResult(template, bindings);
        List<TemplateError> fatalErrors = result.getErrors().stream().filter(error -> error.getSeverity() == TemplateError.ErrorType.FATAL).collect(Collectors.toList());
        if (!fatalErrors.isEmpty()) {
            throw new FatalTemplateErrorsException(template, fatalErrors);
        }
        return result.getOutput();
    }

    public RenderResult renderForResult(String template, Map<String, ?> bindings) {
        return this.renderForResult(template, bindings, this.globalConfig);
    }

    /*
     * Exception decompiling
     */
    public RenderResult renderForResult(String template, Map<String, ?> bindings, JinjavaConfig renderConfig) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public JinjavaInterpreter newInterpreter() {
        return this.globalConfig.getInterpreterFactory().newInstance(this, this.copyGlobalContext(), this.getGlobalConfig());
    }

    public void registerTag(Tag t) {
        this.globalContext.registerTag(t);
    }

    public void registerFunction(ELFunctionDefinition f) {
        this.globalContext.registerFunction(f);
    }

    public void registerFilter(Filter f) {
        this.globalContext.registerFilter(f);
    }

    public void registerExpTest(ExpTest t) {
        this.globalContext.registerExpTest(t);
    }

    protected Map<String, Object> createBindingsWithParentContext(Map<String, ?> bindings, Map<String, ?> bindingsFromParentContext) {
        HashMap<String, Object> bindingsWithParentContext = new HashMap<String, Object>(bindings);
        if (bindingsFromParentContext != null) {
            bindingsWithParentContext.putAll(bindingsFromParentContext);
        }
        return bindingsWithParentContext;
    }

    private Context copyGlobalContext() {
        Context context = new Context(null, this.globalContext);
        this.globalContext.getAllExpTests().forEach(context::registerExpTest);
        this.globalContext.getAllFilters().forEach(context::registerFilter);
        this.globalContext.getAllFunctions().forEach(context::registerFunction);
        this.globalContext.getAllTags().forEach(context::registerTag);
        context.setAutoEscape(this.globalContext.isAutoEscape());
        context.setDynamicVariableResolver(this.globalContext.getDynamicVariableResolver());
        return context;
    }
}

