/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.ims.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ExportImageRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="bucket_url")
    private String bucketUrl;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="file_format")
    private FileFormatEnum fileFormat;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="is_quick_export")
    private Boolean isQuickExport;

    public ExportImageRequestBody withBucketUrl(String bucketUrl) {
        this.bucketUrl = bucketUrl;
        return this;
    }

    public String getBucketUrl() {
        return this.bucketUrl;
    }

    public void setBucketUrl(String bucketUrl) {
        this.bucketUrl = bucketUrl;
    }

    public ExportImageRequestBody withFileFormat(FileFormatEnum fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    public FileFormatEnum getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(FileFormatEnum fileFormat) {
        this.fileFormat = fileFormat;
    }

    public ExportImageRequestBody withIsQuickExport(Boolean isQuickExport) {
        this.isQuickExport = isQuickExport;
        return this;
    }

    public Boolean getIsQuickExport() {
        return this.isQuickExport;
    }

    public void setIsQuickExport(Boolean isQuickExport) {
        this.isQuickExport = isQuickExport;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExportImageRequestBody exportImageRequestBody = (ExportImageRequestBody)o;
        return Objects.equals(this.bucketUrl, exportImageRequestBody.bucketUrl) && Objects.equals(this.fileFormat, exportImageRequestBody.fileFormat) && Objects.equals(this.isQuickExport, exportImageRequestBody.isQuickExport);
    }

    public int hashCode() {
        return Objects.hash(this.bucketUrl, this.fileFormat, this.isQuickExport);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExportImageRequestBody {\n");
        sb.append("    bucketUrl: ").append(this.toIndentedString(this.bucketUrl)).append("\n");
        sb.append("    fileFormat: ").append(this.toIndentedString(this.fileFormat)).append("\n");
        sb.append("    isQuickExport: ").append(this.toIndentedString(this.isQuickExport)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class FileFormatEnum {
        public static final FileFormatEnum QCOW2 = new FileFormatEnum("qcow2");
        public static final FileFormatEnum VHD = new FileFormatEnum("vhd");
        public static final FileFormatEnum ZVHD = new FileFormatEnum("zvhd");
        public static final FileFormatEnum VMDK = new FileFormatEnum("vmdk");
        private static final Map<String, FileFormatEnum> STATIC_FIELDS = FileFormatEnum.createStaticFields();
        private String value;

        private static Map<String, FileFormatEnum> createStaticFields() {
            HashMap<String, FileFormatEnum> map = new HashMap<String, FileFormatEnum>();
            map.put("qcow2", QCOW2);
            map.put("vhd", VHD);
            map.put("zvhd", ZVHD);
            map.put("vmdk", VMDK);
            return Collections.unmodifiableMap(map);
        }

        FileFormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FileFormatEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            FileFormatEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new FileFormatEnum(value);
            }
            return result;
        }

        public static FileFormatEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            FileFormatEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof FileFormatEnum) {
                return this.value.equals(((FileFormatEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

