/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.ims.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class BatchUpdateMembersRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="images")
    private List<String> images = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="project_id")
    private String projectId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="status")
    private StatusEnum status;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="vault_id")
    private String vaultId;

    public BatchUpdateMembersRequestBody withImages(List<String> images) {
        this.images = images;
        return this;
    }

    public BatchUpdateMembersRequestBody addImagesItem(String imagesItem) {
        if (this.images == null) {
            this.images = new ArrayList<String>();
        }
        this.images.add(imagesItem);
        return this;
    }

    public BatchUpdateMembersRequestBody withImages(Consumer<List<String>> imagesSetter) {
        if (this.images == null) {
            this.images = new ArrayList<String>();
        }
        imagesSetter.accept(this.images);
        return this;
    }

    public List<String> getImages() {
        return this.images;
    }

    public void setImages(List<String> images) {
        this.images = images;
    }

    public BatchUpdateMembersRequestBody withProjectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public BatchUpdateMembersRequestBody withStatus(StatusEnum status) {
        this.status = status;
        return this;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public BatchUpdateMembersRequestBody withVaultId(String vaultId) {
        this.vaultId = vaultId;
        return this;
    }

    public String getVaultId() {
        return this.vaultId;
    }

    public void setVaultId(String vaultId) {
        this.vaultId = vaultId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchUpdateMembersRequestBody batchUpdateMembersRequestBody = (BatchUpdateMembersRequestBody)o;
        return Objects.equals(this.images, batchUpdateMembersRequestBody.images) && Objects.equals(this.projectId, batchUpdateMembersRequestBody.projectId) && Objects.equals(this.status, batchUpdateMembersRequestBody.status) && Objects.equals(this.vaultId, batchUpdateMembersRequestBody.vaultId);
    }

    public int hashCode() {
        return Objects.hash(this.images, this.projectId, this.status, this.vaultId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchUpdateMembersRequestBody {\n");
        sb.append("    images: ").append(this.toIndentedString(this.images)).append("\n");
        sb.append("    projectId: ").append(this.toIndentedString(this.projectId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    vaultId: ").append(this.toIndentedString(this.vaultId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class StatusEnum {
        public static final StatusEnum ACCEPTED = new StatusEnum("accepted");
        public static final StatusEnum REJECTED = new StatusEnum("rejected");
        private static final Map<String, StatusEnum> STATIC_FIELDS = StatusEnum.createStaticFields();
        private String value;

        private static Map<String, StatusEnum> createStaticFields() {
            HashMap<String, StatusEnum> map = new HashMap<String, StatusEnum>();
            map.put("accepted", ACCEPTED);
            map.put("rejected", REJECTED);
            return Collections.unmodifiableMap(map);
        }

        StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            StatusEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new StatusEnum(value);
            }
            return result;
        }

        public static StatusEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            StatusEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof StatusEnum) {
                return this.value.equals(((StatusEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

