/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.impl;

import com.huaweicloud.sdk.core.auth.SigningAlgorithm;
import com.huaweicloud.sdk.core.exception.ConnectionException;
import com.huaweicloud.sdk.core.exception.HostUnreachableException;
import com.huaweicloud.sdk.core.exception.SslHandShakeException;
import com.huaweicloud.sdk.core.http.FormDataFilePart;
import com.huaweicloud.sdk.core.http.HttpClient;
import com.huaweicloud.sdk.core.http.HttpConfig;
import com.huaweicloud.sdk.core.http.HttpRequest;
import com.huaweicloud.sdk.core.http.HttpResponse;
import com.huaweicloud.sdk.core.impl.DefaultHttpListener;
import com.huaweicloud.sdk.core.impl.DefaultHttpResponse;
import com.huaweicloud.sdk.core.ssl.DefaultSSLSocketFactory;
import com.huaweicloud.sdk.core.ssl.GMSSLSocketFactory;
import com.huaweicloud.sdk.core.ssl.IgnoreSSLVerificationFactory;
import com.huaweicloud.sdk.core.utils.ExceptionUtils;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLHandshakeException;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.http.HttpMethod;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class DefaultHttpClient
implements HttpClient {
    private static final String OKHTTP_PREEMPTIVE = "OkHttp-Preemptive";
    private static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    private static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    private static final int PROXY_AUTHENTICATION_REQUIRED = 407;
    private static final int DEFAULT_READ_TIMEOUT = 120;
    private OkHttpClient client;
    private HttpConfig httpConfig;

    public DefaultHttpClient(HttpConfig httpConfig) {
        this.withHttpConfig(httpConfig);
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public DefaultHttpClient withHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        clientBuilder.connectionPool(httpConfig.getConnectionPool());
        clientBuilder.dispatcher(httpConfig.getDispatcher());
        clientBuilder.connectTimeout((long)httpConfig.getTimeout(), TimeUnit.SECONDS).readTimeout(120L, TimeUnit.SECONDS);
        if (Objects.nonNull(httpConfig.getSSLSocketFactory()) && Objects.nonNull(httpConfig.getX509TrustManager())) {
            clientBuilder.sslSocketFactory(httpConfig.getSSLSocketFactory(), httpConfig.getX509TrustManager());
        } else if (httpConfig.isIgnoreSSLVerification()) {
            clientBuilder.hostnameVerifier(IgnoreSSLVerificationFactory.getHostnameVerifier()).sslSocketFactory(IgnoreSSLVerificationFactory.getSSLContext(httpConfig.getSecureRandom()).getSocketFactory(), IgnoreSSLVerificationFactory.getTrustAllManager());
        } else if (httpConfig.getSigningAlgorithm() == SigningAlgorithm.HMAC_SHA256) {
            clientBuilder.sslSocketFactory(DefaultSSLSocketFactory.getDefaultSSLSocketFactory(), DefaultSSLSocketFactory.getDefaultX509TrustManager());
        } else if (httpConfig.getSigningAlgorithm() == SigningAlgorithm.HMAC_SM3) {
            clientBuilder.sslSocketFactory(GMSSLSocketFactory.getSSLContext(httpConfig.getSecureRandom()).getSocketFactory(), GMSSLSocketFactory.getX509TrustManager());
        }
        clientBuilder.protocols(Collections.singletonList(Protocol.HTTP_1_1));
        if (!StringUtils.isEmpty(httpConfig.getProxyHost())) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(httpConfig.getProxyHost(), httpConfig.getProxyPort()));
            clientBuilder.proxy(proxy);
        }
        if (!StringUtils.isEmpty(httpConfig.getProxyUsername())) {
            Authenticator proxyAuthenticator = (route, response) -> {
                if (!OKHTTP_PREEMPTIVE.equals(response.header(PROXY_AUTHENTICATE)) && response.code() == 407) {
                    return null;
                }
                String credential = Credentials.basic((String)httpConfig.getProxyUsername(), (String)httpConfig.getProxyPassword());
                return response.request().newBuilder().header(PROXY_AUTHORIZATION, credential).build();
            };
            clientBuilder.proxyAuthenticator(proxyAuthenticator);
        }
        this.client = clientBuilder.addInterceptor((Interceptor)new DefaultHttpListener(httpConfig)).build();
        return this;
    }

    private Request buildOkHttpRequest(HttpRequest httpRequest) {
        Request.Builder requestBuilder = new Request.Builder();
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)(httpRequest.getEndpoint() + httpRequest.getPathParamsString())).newBuilder();
        httpRequest.getQueryParams().forEach((key, values) -> {
            if (values.size() == 0) {
                urlBuilder.addQueryParameter(key, null);
            } else {
                values.forEach(value -> urlBuilder.addQueryParameter(key, value));
            }
        });
        requestBuilder.url(urlBuilder.build());
        httpRequest.getHeaders().forEach((key, values) -> values.forEach(value -> requestBuilder.header(key, value)));
        if (Objects.isNull(httpRequest.getBodyAsString())) {
            return httpRequest.getContentType().startsWith("multipart/form-data") ? this.buildOkHttpRequestWithFormData(httpRequest, requestBuilder) : this.buildOkHttpRequestWithoutTextBody(httpRequest, requestBuilder);
        }
        return this.buildOkHttpRequestWithTextBody(httpRequest, requestBuilder);
    }

    private Request buildOkHttpRequestWithFormData(HttpRequest httpRequest, Request.Builder requestBuilder) {
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
        bodyBuilder.setType(MediaType.parse((String)httpRequest.getContentType()));
        httpRequest.getFormData().forEach((name, part) -> {
            if (part instanceof FormDataFilePart) {
                final FormDataFilePart filePart = (FormDataFilePart)part;
                bodyBuilder.addFormDataPart(name, filePart.getFilename(), new RequestBody(){

                    public MediaType contentType() {
                        return Objects.isNull(filePart.getContentType()) ? null : MediaType.parse((String)filePart.getContentType());
                    }

                    public void writeTo(BufferedSink bufferedSink) throws IOException {
                        try (Source source = Okio.source((InputStream)filePart.getInputStream());){
                            bufferedSink.writeAll(source);
                        }
                    }
                });
            } else {
                bodyBuilder.addFormDataPart(name, part.toString());
            }
        });
        requestBuilder.method(httpRequest.getMethod().toString(), (RequestBody)bodyBuilder.build());
        return requestBuilder.build();
    }

    private Request buildOkHttpRequestWithTextBody(final HttpRequest httpRequest, Request.Builder requestBuilder) {
        requestBuilder.method(httpRequest.getMethod().toString(), new RequestBody(){

            public MediaType contentType() {
                return MediaType.parse((String)httpRequest.getContentType());
            }

            public void writeTo(BufferedSink bufferedSink) throws IOException {
                bufferedSink.writeUtf8(httpRequest.getBodyAsString());
            }
        });
        return requestBuilder.build();
    }

    private Request buildOkHttpRequestWithoutTextBody(final HttpRequest httpRequest, Request.Builder requestBuilder) {
        if (Objects.isNull(httpRequest.getBody())) {
            if (HttpMethod.requiresRequestBody((String)httpRequest.getMethod().toString())) {
                requestBuilder.method(httpRequest.getMethod().toString(), RequestBody.create(null, (byte[])new byte[0]));
            } else {
                requestBuilder.method(httpRequest.getMethod().toString(), null);
            }
        } else {
            requestBuilder.method(httpRequest.getMethod().toString(), new RequestBody(){

                public MediaType contentType() {
                    return MediaType.parse((String)httpRequest.getContentType());
                }

                public void writeTo(BufferedSink bufferedSink) throws IOException {
                    try (Source source = Okio.source((InputStream)httpRequest.getBody());){
                        bufferedSink.writeAll(source);
                    }
                }
            });
        }
        return requestBuilder.build();
    }

    public Callback toCallback(final CompletableFuture<Response> future) {
        return new Callback(){

            public void onFailure(Call call, IOException e) {
                future.completeExceptionally(e);
            }

            public void onResponse(Call call, Response response) {
                future.complete(response);
            }
        };
    }

    @Override
    public CompletableFuture<HttpResponse> asyncInvokeHttp(HttpRequest httpRequest) {
        Request request = this.buildOkHttpRequest(httpRequest);
        CompletableFuture<Response> asyncHttpResponse = new CompletableFuture<Response>();
        this.client.newCall(request).enqueue(this.toCallback(asyncHttpResponse));
        return asyncHttpResponse.handle((response, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof SSLHandshakeException) {
                    throw new SslHandShakeException("DefaultHttpClient SslHandShakeException", (Throwable)throwable);
                }
                if (throwable instanceof UnknownHostException) {
                    throw new HostUnreachableException("DefaultHttpClient HostUnreachableException", (Throwable)throwable);
                }
                if (throwable instanceof SocketTimeoutException) {
                    ExceptionUtils.mapSocketTimeoutException("DefaultHttpClient RequestTimeoutException", throwable);
                } else {
                    throw new ConnectionException("DefaultHttpClient ConnectionException", (Throwable)throwable);
                }
            }
            return DefaultHttpResponse.wrap(response);
        });
    }

    @Override
    public HttpResponse syncInvokeHttp(HttpRequest httpRequest) throws ConnectionException {
        Request request = this.buildOkHttpRequest(httpRequest);
        Response response = null;
        try {
            response = this.client.newCall(request).execute();
        }
        catch (SSLHandshakeException e) {
            throw new SslHandShakeException("DefaultHttpClient SslHandShakeException", e);
        }
        catch (UnknownHostException e) {
            throw new HostUnreachableException("DefaultHttpClient HostUnreachableException", e);
        }
        catch (SocketTimeoutException e) {
            ExceptionUtils.mapSocketTimeoutException("DefaultHttpClient RequestTimeout", e);
        }
        catch (IOException e) {
            throw new ConnectionException("DefaultHttpClient ConnectionException", e);
        }
        return DefaultHttpResponse.wrap(response);
    }
}

