/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.auth;

import com.huaweicloud.sdk.core.auth.AbstractCredentials;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.http.HttpRequest;
import com.huaweicloud.sdk.core.utils.BinaryUtils;
import com.huaweicloud.sdk.core.utils.SignUtils;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SimpleTimeZone;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class AKSKSigner {
    public static final String EMPTY_BODY_SHA256 = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
    public static final String ISO_8601_BASIC_FORMAT = "yyyyMMdd'T'HHmmss'Z'";

    public static <T extends AbstractCredentials<T>> Map<String, String> sign(HttpRequest request, T credential) {
        String[] split;
        String dateTimeStamp;
        Date now = new Date();
        HashMap<String, String> authenticationHeaders = new HashMap<String, String>();
        URL url = request.getUrl();
        String canonicalHost = url.getAuthority();
        authenticationHeaders.put("Host", canonicalHost);
        if (!request.haveHeader("X-Sdk-Date").booleanValue()) {
            SimpleDateFormat isoDateFormat = new SimpleDateFormat(ISO_8601_BASIC_FORMAT);
            isoDateFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
            dateTimeStamp = isoDateFormat.format(now);
            authenticationHeaders.put("X-Sdk-Date", dateTimeStamp);
        } else {
            dateTimeStamp = request.getHeader("X-Sdk-Date");
        }
        TreeMap<String, String> allHeaders = new TreeMap<String, String>();
        allHeaders.putAll(request.getHeaders().entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("Content-Type") || !((String)((List)entry.getValue()).get(0)).startsWith("multipart/form-data")).collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(Locale.ROOT), entry -> (String)((List)entry.getValue()).get(0))));
        allHeaders.putAll(authenticationHeaders.entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(Locale.ROOT), Map.Entry::getValue)));
        String pathOld = url.getPath();
        StringBuilder canonicalUri = new StringBuilder();
        for (String urlSplit : split = pathOld.split("/")) {
            canonicalUri.append(SignUtils.urlEncode(urlSplit, false)).append("/");
        }
        String query = url.getQuery();
        Map<String, List<String>> parameters = request.getQueryParams();
        String canonicalQueryString = AKSKSigner.buildCanonicalQueryString(query, parameters);
        String signedHeaderNames = String.join((CharSequence)";", allHeaders.keySet());
        String canonicalHeaders = AKSKSigner.buildCanonicalHeaders(allHeaders);
        String payloadHash = AKSKSigner.buildPayloadHash(request);
        String canonicalRequest = AKSKSigner.buildCanonicalRequest(request.getMethod().name(), canonicalUri.toString(), canonicalQueryString, canonicalHeaders, signedHeaderNames, payloadHash);
        String canonicalRequestHash = BinaryUtils.toHex(AKSKSigner.sha256(canonicalRequest));
        String stringToSign = AKSKSigner.getStringToSign("SDK-HMAC-SHA256", dateTimeStamp, canonicalRequestHash);
        String signatureString = AKSKSigner.signature(stringToSign, credential.getSk());
        StringBuilder authorization = new StringBuilder("SDK-HMAC-SHA256").append(" ");
        authorization.append("Access=").append(credential.getAk()).append(", ");
        authorization.append("SignedHeaders=").append(signedHeaderNames).append(", ");
        authorization.append("Signature=").append(signatureString);
        authenticationHeaders.put("Authorization", authorization.toString());
        return authenticationHeaders;
    }

    protected static String buildCanonicalQueryString(String query, Map<String, List<String>> parameters) {
        SortedMap<String, List<String>> sorted = SignUtils.convertQuery2SortedMap(query);
        if (parameters == null || parameters.isEmpty()) {
            return "";
        }
        for (Map.Entry<String, List<String>> pair : parameters.entrySet()) {
            String key = pair.getKey();
            List<String> values = pair.getValue();
            ArrayList<String> escapedValues = new ArrayList<String>();
            for (String value : values) {
                escapedValues.add(SignUtils.urlEncode(value, false));
            }
            sorted.put(SignUtils.urlEncode(key, false), escapedValues);
        }
        return SignUtils.convertSortedMap2QueryString(sorted);
    }

    protected static String buildCanonicalHeaders(Map<String, String> heads) {
        StringBuilder sb = new StringBuilder();
        heads.forEach((key, value) -> {
            sb.append((String)key).append(":").append((String)value);
            sb.append("\n");
        });
        return sb.toString();
    }

    protected static String buildPayloadHash(HttpRequest request) {
        if (request.haveHeader("X-Sdk-Content-Sha256").booleanValue()) {
            return request.getHeader("X-Sdk-Content-Sha256");
        }
        if (Objects.nonNull(request.getBodyAsString()) && !request.getBodyAsString().isEmpty()) {
            return BinaryUtils.toHex(AKSKSigner.sha256(request.getBodyAsString()));
        }
        return EMPTY_BODY_SHA256;
    }

    protected static String buildCanonicalRequest(String ... segments) {
        return String.join((CharSequence)"\n", segments);
    }

    protected static String getStringToSign(String ... segments) {
        return String.join((CharSequence)"\n", segments);
    }

    protected static String signature(String stringToSign, String secretKey) {
        byte[] keySecret = secretKey.getBytes(StandardCharsets.UTF_8);
        byte[] signature = AKSKSigner.hmac(keySecret, stringToSign);
        return BinaryUtils.toHex(signature);
    }

    public static byte[] sha256(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(text.getBytes(StandardCharsets.UTF_8));
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new SdkException("Unable to compute hash while signing request", e);
        }
    }

    protected static byte[] hmac(byte[] key, String data) {
        try {
            Mac hmac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "HmacSHA256");
            hmac.init(secretKeySpec);
            return hmac.doFinal(data.getBytes(StandardCharsets.UTF_8));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new SdkException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }
}

