/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.invoker;

import com.huaweicloud.sdk.core.HcClient;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.exchange.SdkExchange;
import com.huaweicloud.sdk.core.http.HttpRequestDef;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;

public class BaseInvoker<ReqT, ResT, DerivedT extends BaseInvoker<ReqT, ResT, DerivedT>> {
    SdkExchange exchange = new SdkExchange().withApiReference(apiReference -> apiReference.withName(meta.getName()).withMethod(meta.getMethod().toString()).withUri(meta.getUri()));
    HcClient hcClient;
    HttpRequestDef<ReqT, ResT> meta;
    ReqT req;
    Map<String, String> extraHeader;

    public BaseInvoker(ReqT req, HttpRequestDef<ReqT, ResT> meta, HcClient hcClient) {
        this.hcClient = hcClient;
        this.meta = meta;
        this.req = req;
    }

    public <T extends ICredential> DerivedT replaceCredentialWhen(Class<T> clazz, Consumer<T> func) {
        ICredential credential = this.hcClient.getCredential().deepClone();
        if (clazz.isAssignableFrom(credential.getClass())) {
            func.accept(credential);
            this.hcClient = this.hcClient.overrideCredential(credential);
        }
        return (DerivedT)this;
    }

    public DerivedT addHeader(String headerKey, String headerValue) {
        if (Objects.isNull(this.extraHeader)) {
            this.extraHeader = new TreeMap<String, String>();
        }
        this.extraHeader.put(headerKey, headerValue);
        return (DerivedT)this;
    }

    public DerivedT withExchange(Consumer<SdkExchange> func) {
        if (Objects.nonNull(func)) {
            func.accept(this.exchange);
        }
        return (DerivedT)this;
    }
}

