/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.auth;

import com.huaweicloud.sdk.core.HcClient;
import com.huaweicloud.sdk.core.auth.AKSKSigner;
import com.huaweicloud.sdk.core.auth.AbstractCredentials;
import com.huaweicloud.sdk.core.auth.AuthCache;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.http.HttpClient;
import com.huaweicloud.sdk.core.http.HttpRequest;
import com.huaweicloud.sdk.core.internal.InnerIamMeta;
import com.huaweicloud.sdk.core.internal.model.KeystoneListAuthDomainsRequest;
import com.huaweicloud.sdk.core.internal.model.KeystoneListAuthDomainsResponse;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class GlobalCredentials
extends AbstractCredentials<GlobalCredentials> {
    private String domainId;

    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public GlobalCredentials withDomainId(String domainId) {
        this.domainId = domainId;
        return this;
    }

    Map<String, Object> getPathParams() {
        LinkedHashMap<String, Object> pathParam = new LinkedHashMap<String, Object>();
        if (Objects.nonNull(this.domainId)) {
            pathParam.put("domain_id", this.domainId);
        }
        return pathParam;
    }

    @Override
    public CompletableFuture<ICredential> processAuthParams(HcClient hcClient, String regionId) {
        KeystoneListAuthDomainsRequest request;
        if (!StringUtils.isEmpty(this.domainId)) {
            return CompletableFuture.completedFuture(this);
        }
        String akWithName = this.getAk();
        if (Objects.nonNull(AuthCache.getAuth(akWithName)) && !StringUtils.isEmpty(AuthCache.getAuth(akWithName))) {
            this.domainId = AuthCache.getAuth(akWithName);
            return CompletableFuture.completedFuture(this);
        }
        String iamEndpoint = StringUtils.isEmpty(this.getIamEndpoint()) ? "https://iam.myhuaweicloud.com" : this.getIamEndpoint();
        HcClient inner = hcClient.overrideEndpoint(iamEndpoint);
        KeystoneListAuthDomainsResponse response = inner.syncInvokeHttp(request = new KeystoneListAuthDomainsRequest(), InnerIamMeta.KEYSTONE_LIST_AUTH_DOMAINS);
        if (Objects.isNull(response)) {
            throw new SdkException("failed to get domain id");
        }
        this.domainId = response.getDomains().get(0).getId();
        AuthCache.putAuth(akWithName, this.domainId);
        return CompletableFuture.completedFuture(this);
    }

    @Override
    public CompletableFuture<HttpRequest> processAuthRequest(HttpRequest httpRequest, HttpClient httpClient) {
        return CompletableFuture.supplyAsync(() -> {
            HttpRequest.HttpRequestBuilder builder = httpRequest.builder().addAutoFilledPathParam(this.getPathParams());
            if (Objects.nonNull(this.getDomainId())) {
                builder.addHeader("X-Domain-Id", this.getDomainId());
            }
            if (Objects.nonNull(this.getSecurityToken())) {
                builder.addHeader("X-Security-Token", this.getSecurityToken());
            }
            if (Objects.nonNull(httpRequest.getContentType()) && !httpRequest.getContentType().startsWith("application/json")) {
                builder.addHeader("X-Sdk-Content-Sha256", "UNSIGNED-PAYLOAD");
            }
            Map<String, String> header = AKSKSigner.sign(builder.build(), this);
            builder.addHeaders(header);
            return builder.build();
        });
    }

    @Override
    public GlobalCredentials deepClone() {
        return (GlobalCredentials)((GlobalCredentials)((GlobalCredentials)((GlobalCredentials)new GlobalCredentials().withDomainId(this.domainId).withAk(this.getAk())).withSk(this.getSk())).withIamEndpoint(this.getIamEndpoint())).withSecurityToken(this.getSecurityToken());
    }
}

