/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.wan.impl;

import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.wan.WanMigrationAwarePublisher;
import com.hazelcast.wan.WanPublisher;
import com.hazelcast.wan.impl.WanDataSerializerHook;
import com.hazelcast.wan.impl.WanReplicationService;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;

public class WanEventContainerReplicationOperation
extends Operation
implements IdentifiedDataSerializable {
    private Collection<WanReplicationConfig> wanReplicationConfigs;
    private Map<String, Map<String, Object>> eventContainers;

    public WanEventContainerReplicationOperation() {
    }

    public WanEventContainerReplicationOperation(@Nonnull Collection<WanReplicationConfig> wanReplicationConfigs, @Nonnull Map<String, Map<String, Object>> eventContainers, int partitionId, int replicaIndex) {
        Preconditions.checkNotNull(wanReplicationConfigs);
        Preconditions.checkNotNull(eventContainers);
        this.wanReplicationConfigs = wanReplicationConfigs;
        this.eventContainers = eventContainers;
        this.setPartitionId(partitionId).setReplicaIndex(replicaIndex);
    }

    @Override
    public void run() throws Exception {
        WanReplicationService service = this.getWanReplicationService();
        int partitionId = this.getPartitionId();
        for (WanReplicationConfig wanReplicationConfig : this.wanReplicationConfigs) {
            service.addWanReplicationConfigLocally(wanReplicationConfig);
        }
        this.forAllReplicationContainers((publisher, o) -> {});
        this.forAllReplicationContainers((publisher, eventContainer) -> {
            if (publisher instanceof WanMigrationAwarePublisher) {
                WanMigrationAwarePublisher awarePublisher = (WanMigrationAwarePublisher)((Object)publisher);
                awarePublisher.processEventContainerReplicationData(partitionId, eventContainer);
            }
        });
    }

    private void forAllReplicationContainers(BiConsumer<WanPublisher, Object> publisherContainerConsumer) {
        WanReplicationService service = this.getWanReplicationService();
        for (Map.Entry<String, Map<String, Object>> wanReplicationSchemeEntry : this.eventContainers.entrySet()) {
            String wanReplicationScheme = wanReplicationSchemeEntry.getKey();
            Map<String, Object> eventContainersByPublisherId = wanReplicationSchemeEntry.getValue();
            for (Map.Entry<String, Object> publisherEventContainer : eventContainersByPublisherId.entrySet()) {
                String publisherId = publisherEventContainer.getKey();
                Object eventContainer = publisherEventContainer.getValue();
                WanPublisher publisher = service.getPublisherOrFail(wanReplicationScheme, publisherId);
                publisherContainerConsumer.accept(publisher, eventContainer);
            }
        }
    }

    @Override
    public int getFactoryId() {
        return WanDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeInt(this.eventContainers.size());
        for (Map.Entry<String, Map<String, Object>> entry : this.eventContainers.entrySet()) {
            String wanReplicationScheme = entry.getKey();
            Map<String, Object> eventContainersByPublisherId = entry.getValue();
            out.writeString(wanReplicationScheme);
            out.writeInt(eventContainersByPublisherId.size());
            for (Map.Entry<String, Object> publisherEventContainer : eventContainersByPublisherId.entrySet()) {
                String publisherId = publisherEventContainer.getKey();
                Object eventContainer = publisherEventContainer.getValue();
                out.writeString(publisherId);
                out.writeObject(eventContainer);
            }
        }
        SerializationUtil.writeCollection(this.wanReplicationConfigs, out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int wanReplicationSchemeCount = in.readInt();
        this.eventContainers = MapUtil.createHashMap(wanReplicationSchemeCount);
        for (int i = 0; i < wanReplicationSchemeCount; ++i) {
            String wanReplicationScheme = in.readString();
            int publisherCount = in.readInt();
            Map eventContainersByPublisherId = MapUtil.createHashMap(publisherCount);
            for (int j = 0; j < publisherCount; ++j) {
                String publisherId = in.readString();
                Object eventContainer = in.readObject();
                eventContainersByPublisherId.put(publisherId, eventContainer);
            }
            this.eventContainers.put(wanReplicationScheme, eventContainersByPublisherId);
        }
        this.wanReplicationConfigs = SerializationUtil.readCollection(in);
    }

    private WanReplicationService getWanReplicationService() {
        return this.getNodeEngine().getWanReplicationService();
    }
}

