/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.spi.impl.operationservice.WrappableException;
import java.util.UUID;

public final class QueryException
extends HazelcastException
implements WrappableException<QueryException> {
    private final int code;
    private final String suggestion;
    private final UUID originatingMemberId;

    public QueryException(String message, Throwable cause) {
        this(-1, message, cause, null);
    }

    private QueryException(int code, String message, Throwable cause, UUID originatingMemberId) {
        this(code, message, cause, null, originatingMemberId);
    }

    private QueryException(int code, String message, Throwable cause, String suggestion, UUID originatingMemberId) {
        super(message, cause);
        this.code = code;
        this.suggestion = suggestion;
        this.originatingMemberId = originatingMemberId;
    }

    public static QueryException error(String message) {
        return QueryException.error(message, null);
    }

    public static QueryException error(String message, Throwable cause) {
        return QueryException.error(-1, message, cause);
    }

    public static QueryException error(int code, String message) {
        return new QueryException(code, message, null, null);
    }

    public static QueryException error(int code, String message, Throwable cause) {
        return new QueryException(code, message, cause, null);
    }

    public static QueryException error(int code, String message, Throwable cause, String suggestion) {
        return new QueryException(code, message, cause, suggestion, null);
    }

    public static QueryException error(int code, String message, UUID originatingMemberId) {
        return new QueryException(code, message, null, originatingMemberId);
    }

    public static QueryException error(int code, String message, Throwable cause, UUID originatingMemberId) {
        return new QueryException(code, message, cause, originatingMemberId);
    }

    public static QueryException memberConnection(Address address) {
        return QueryException.error(1001, "Cluster topology changed while a query was executed: Member cannot be reached: " + String.valueOf(address));
    }

    public static QueryException clientMemberConnection(UUID clientId) {
        return QueryException.error(1001, "Client cannot be reached: " + String.valueOf(clientId));
    }

    public static QueryException timeout(long timeout) {
        return QueryException.error(1004, "Query has been cancelled due to a timeout (" + timeout + " ms)");
    }

    public static QueryException cancelledByUser() {
        return QueryException.error(1003, "Query was cancelled by the user");
    }

    public static QueryException dataException(String message, Throwable cause) {
        return QueryException.error(2000, message, cause);
    }

    public static QueryException dataException(String message) {
        return QueryException.dataException(message, null);
    }

    public int getCode() {
        return this.code;
    }

    public String getSuggestion() {
        return this.suggestion;
    }

    public UUID getOriginatingMemberId() {
        return this.originatingMemberId;
    }

    @Override
    public QueryException wrap() {
        return new QueryException(this.code, this.getMessage(), this, this.suggestion, this.originatingMemberId);
    }
}

