/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.executionservice.impl;

import com.hazelcast.config.DurableExecutorConfig;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricTarget;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.RuntimeAvailableProcessors;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.internal.util.executor.CachedExecutorServiceDelegate;
import com.hazelcast.internal.util.executor.ExecutorType;
import com.hazelcast.internal.util.executor.LoggingScheduledExecutor;
import com.hazelcast.internal.util.executor.ManagedExecutorService;
import com.hazelcast.internal.util.executor.NamedThreadPoolExecutor;
import com.hazelcast.internal.util.executor.PoolExecutorThreadFactory;
import com.hazelcast.internal.util.executor.SingleExecutorThreadFactory;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.executionservice.TaskScheduler;
import com.hazelcast.spi.impl.executionservice.impl.CompletableFutureEntry;
import com.hazelcast.spi.impl.executionservice.impl.CompletableFutureTask;
import com.hazelcast.spi.impl.executionservice.impl.DelegatingTaskScheduler;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ExecutionServiceImpl
implements ExecutionService {
    private static final int CORE_POOL_SIZE = 3;
    private static final long KEEP_ALIVE_TIME = 60L;
    private static final long INITIAL_DELAY = 1000L;
    private static final long PERIOD = 100L;
    private static final int BEGIN_INDEX = 3;
    private static final long AWAIT_TIME = 3L;
    private static final int POOL_MULTIPLIER = 2;
    private static final int QUEUE_MULTIPLIER = 100000;
    private static final int ASYNC_QUEUE_CAPACITY = 100000;
    private static final int OFFLOADABLE_QUEUE_CAPACITY = 100000;
    private static final int JOB_OFFLOADABLE_QUEUE_CAPACITY = 100000;
    private final ILogger logger;
    private final NodeEngine nodeEngine;
    private final TaskScheduler globalTaskScheduler;
    private final ExecutorService cachedExecutorService;
    private final LoggingScheduledExecutor scheduledExecutorService;
    private final CompletableFutureTask completableFutureTask;
    private final ConcurrentMap<String, ManagedExecutorService> executors = new ConcurrentHashMap<String, ManagedExecutorService>();
    private final ConcurrentMap<String, ManagedExecutorService> durableExecutors = new ConcurrentHashMap<String, ManagedExecutorService>();
    private final ConcurrentMap<String, ManagedExecutorService> scheduleDurableExecutors = new ConcurrentHashMap<String, ManagedExecutorService>();
    private final ConstructorFunction<String, ManagedExecutorService> constructor = new ConstructorFunction<String, ManagedExecutorService>(){

        @Override
        public ManagedExecutorService createNew(String name) {
            ExecutorConfig config = ExecutionServiceImpl.this.nodeEngine.getConfig().findExecutorConfig(name);
            int queueCapacity = config.getQueueCapacity() <= 0 ? Integer.MAX_VALUE : config.getQueueCapacity();
            return ExecutionServiceImpl.this.createExecutor(name, config.getPoolSize(), queueCapacity, ExecutorType.CACHED, null);
        }
    };
    private final ConstructorFunction<String, ManagedExecutorService> durableConstructor = new ConstructorFunction<String, ManagedExecutorService>(){

        @Override
        public ManagedExecutorService createNew(String name) {
            DurableExecutorConfig cfg = ExecutionServiceImpl.this.nodeEngine.getConfig().findDurableExecutorConfig(name);
            return ExecutionServiceImpl.this.createExecutor(name, cfg.getPoolSize(), Integer.MAX_VALUE, ExecutorType.CACHED, null);
        }
    };
    private final ConstructorFunction<String, ManagedExecutorService> scheduledDurableConstructor = new ConstructorFunction<String, ManagedExecutorService>(){

        @Override
        public ManagedExecutorService createNew(String name) {
            ScheduledExecutorConfig cfg = ExecutionServiceImpl.this.nodeEngine.getConfig().findScheduledExecutorConfig(name);
            return ExecutionServiceImpl.this.createExecutor(name, cfg.getPoolSize(), Integer.MAX_VALUE, ExecutorType.CACHED, null);
        }
    };

    public ExecutionServiceImpl(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(ExecutionService.class.getName());
        String hzName = nodeEngine.getHazelcastInstance().getName();
        ClassLoader configClassLoader = nodeEngine.getConfigClassLoader();
        PoolExecutorThreadFactory threadFactory = new PoolExecutorThreadFactory(ThreadUtil.createThreadPoolName(hzName, "cached"), configClassLoader, nodeEngine);
        this.cachedExecutorService = new ThreadPoolExecutor(3, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory, (r, executor) -> {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Node is shutting down; discarding the task: %s", r);
            }
        });
        SingleExecutorThreadFactory singleExecutorThreadFactory = new SingleExecutorThreadFactory(configClassLoader, ThreadUtil.createThreadPoolName(hzName, "scheduled"));
        this.scheduledExecutorService = new LoggingScheduledExecutor(this.logger, 1, singleExecutorThreadFactory);
        this.registerExecutors();
        this.globalTaskScheduler = this.getTaskScheduler("hz:scheduled");
        this.completableFutureTask = new CompletableFutureTask();
        this.scheduleWithRepetition(this.completableFutureTask, 1000L, 100L, TimeUnit.MILLISECONDS);
        nodeEngine.getMetricsRegistry().registerDynamicMetricsProvider(new MetricsProvider(this.executors, this.durableExecutors, this.scheduleDurableExecutors));
    }

    private void registerExecutors() {
        int coreSize = Math.max(RuntimeAvailableProcessors.get(), 2);
        this.register("hz:system", coreSize, Integer.MAX_VALUE, ExecutorType.CACHED);
        this.register("hz:scheduled", coreSize * 2, coreSize * 100000, ExecutorType.CACHED);
        this.register("hz:async", coreSize, 100000, ExecutorType.CONCRETE);
        this.register("hz:offloadable", coreSize, 100000, ExecutorType.CACHED);
        this.register("hz:jet-job-offloadable", coreSize, 100000, ExecutorType.CACHED);
    }

    public LoggingScheduledExecutor getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    @Override
    public ManagedExecutorService register(String name, int defaultPoolSize, int defaultQueueCapacity, ExecutorType type) {
        return this.register(name, defaultPoolSize, defaultQueueCapacity, type, null);
    }

    @Override
    public ManagedExecutorService register(String name, int defaultPoolSize, int defaultQueueCapacity, ThreadFactory threadFactory) {
        return this.register(name, defaultPoolSize, defaultQueueCapacity, ExecutorType.CONCRETE, threadFactory);
    }

    private ManagedExecutorService register(String name, int defaultPoolSize, int defaultQueueCapacity, ExecutorType type, ThreadFactory threadFactory) {
        ManagedExecutorService executor;
        ExecutorConfig config = this.nodeEngine.getConfig().getExecutorConfigs().get(name);
        int poolSize = defaultPoolSize;
        int queueCapacity = defaultQueueCapacity;
        if (config != null) {
            poolSize = config.getPoolSize();
            queueCapacity = config.getQueueCapacity() <= 0 ? Integer.MAX_VALUE : config.getQueueCapacity();
        }
        if (this.executors.putIfAbsent(name, executor = this.createExecutor(name, poolSize, queueCapacity, type, threadFactory)) != null) {
            throw new IllegalArgumentException("ExecutorService['" + name + "'] already exists!");
        }
        return executor;
    }

    private ManagedExecutorService createExecutor(String name, int poolSize, int queueCapacity, ExecutorType type, ThreadFactory threadFactory) {
        ManagedExecutorService executor;
        if (type == ExecutorType.CACHED) {
            if (threadFactory != null) {
                throw new IllegalArgumentException("Cached executor can not be used with external thread factory");
            }
            executor = new CachedExecutorServiceDelegate(name, this.cachedExecutorService, poolSize, queueCapacity);
        } else if (type == ExecutorType.CONCRETE) {
            if (threadFactory == null) {
                ClassLoader classLoader = this.nodeEngine.getConfigClassLoader();
                String hzName = this.nodeEngine.getHazelcastInstance().getName();
                String internalName = name.startsWith("hz:") ? name.substring(3) : name;
                String threadNamePrefix = ThreadUtil.createThreadPoolName(hzName, internalName);
                threadFactory = new PoolExecutorThreadFactory(threadNamePrefix, classLoader, this.nodeEngine);
            }
            NamedThreadPoolExecutor pool = new NamedThreadPoolExecutor(name, poolSize, poolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueCapacity), threadFactory);
            pool.allowCoreThreadTimeOut(true);
            executor = pool;
        } else {
            throw new IllegalArgumentException("Unknown executor type: " + String.valueOf((Object)type));
        }
        return executor;
    }

    @Override
    public ManagedExecutorService getExecutor(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.executors, name, this.constructor);
    }

    @Override
    public ManagedExecutorService getDurable(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.durableExecutors, name, this.durableConstructor);
    }

    @Override
    public ExecutorService getScheduledDurable(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.scheduleDurableExecutors, name, this.scheduledDurableConstructor);
    }

    @Override
    public <V> InternalCompletableFuture<V> asCompletableFuture(Future<V> future) {
        if (future == null) {
            throw new IllegalArgumentException("future must not be null");
        }
        if (future instanceof InternalCompletableFuture) {
            return (InternalCompletableFuture)future;
        }
        return this.registerCompletableFuture(future);
    }

    @Override
    public void execute(String name, Runnable command) {
        this.getExecutor(name).execute(command);
    }

    @Override
    public void executeDurable(String name, Runnable command) {
        this.getDurable(name).execute(command);
    }

    @Override
    public Future<?> submit(String name, Runnable task) {
        return this.getExecutor(name).submit(task);
    }

    @Override
    public <T> Future<T> submit(String name, Callable<T> task) {
        return this.getExecutor(name).submit(task);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.globalTaskScheduler.schedule(command, delay, unit);
    }

    @Override
    public ScheduledFuture<?> schedule(String name, Runnable command, long delay, TimeUnit unit) {
        return this.getTaskScheduler(name).schedule(command, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleDurable(String name, Runnable command, long delay, TimeUnit unit) {
        return this.getDurableTaskScheduler(name).schedule(command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<Future<V>> scheduleDurable(String name, Callable<V> command, long delay, TimeUnit unit) {
        return this.getDurableTaskScheduler(name).schedule(command, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithRepetition(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.globalTaskScheduler.scheduleWithRepetition(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithRepetition(String name, Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.getTaskScheduler(name).scheduleWithRepetition(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleDurableWithRepetition(String name, Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.getDurableTaskScheduler(name).scheduleWithRepetition(command, initialDelay, period, unit);
    }

    @Override
    public TaskScheduler getGlobalTaskScheduler() {
        return this.globalTaskScheduler;
    }

    @Override
    public TaskScheduler getTaskScheduler(String name) {
        return new DelegatingTaskScheduler(this.scheduledExecutorService, this.getExecutor(name));
    }

    public void shutdown() {
        this.logger.finest("Stopping executors...");
        this.scheduledExecutorService.notifyShutdownInitiated();
        this.shutdown(this.executors);
        this.shutdown(this.durableExecutors);
        this.shutdown(this.scheduleDurableExecutors);
        this.scheduledExecutorService.shutdownNow();
        this.cachedExecutorService.shutdown();
        this.awaitAndForceShutdown(this.executors);
        this.awaitAndForceShutdown(this.scheduledExecutorService);
        this.awaitAndForceShutdown(this.cachedExecutorService);
        this.executors.clear();
        this.durableExecutors.clear();
        this.scheduleDurableExecutors.clear();
    }

    private void shutdown(Map<?, ? extends ExecutorService> executorServiceMap) {
        for (ExecutorService executorService : executorServiceMap.values()) {
            executorService.shutdown();
        }
    }

    private void awaitAndForceShutdown(Map<?, ? extends ExecutorService> executorServiceMap) {
        for (ExecutorService executorService : executorServiceMap.values()) {
            this.awaitAndForceShutdown(executorService);
        }
    }

    private void awaitAndForceShutdown(ExecutorService executorService) {
        try {
            if (!executorService.awaitTermination(3L, TimeUnit.SECONDS)) {
                executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.finest(e);
        }
        catch (UnsupportedOperationException e) {
            EmptyStatement.ignore(e);
        }
    }

    @Override
    public void shutdownExecutor(String name) {
        ExecutorService executorService = (ExecutorService)this.executors.remove(name);
        if (executorService != null) {
            executorService.shutdown();
        }
    }

    @Override
    public void shutdownDurableExecutor(String name) {
        ExecutorService executorService = (ExecutorService)this.durableExecutors.remove(name);
        if (executorService != null) {
            executorService.shutdown();
        }
    }

    @Override
    public void shutdownScheduledDurableExecutor(String name) {
        ExecutorService executorService = (ExecutorService)this.scheduleDurableExecutors.remove(name);
        if (executorService != null) {
            executorService.shutdown();
        }
    }

    private <V> InternalCompletableFuture<V> registerCompletableFuture(Future<V> future) {
        CompletableFutureEntry<V> entry = new CompletableFutureEntry<V>(future);
        this.completableFutureTask.registerCompletableFutureEntry(entry);
        return entry.completableFuture;
    }

    private TaskScheduler getDurableTaskScheduler(String name) {
        return new DelegatingTaskScheduler(this.scheduledExecutorService, this.getScheduledDurable(name));
    }

    private static final class MetricsProvider
    implements DynamicMetricsProvider {
        private final ConcurrentMap<String, ManagedExecutorService> executors;
        private final ConcurrentMap<String, ManagedExecutorService> durableExecutors;
        private final ConcurrentMap<String, ManagedExecutorService> scheduleDurableExecutors;

        private MetricsProvider(ConcurrentMap<String, ManagedExecutorService> executors, ConcurrentMap<String, ManagedExecutorService> durableExecutors, ConcurrentMap<String, ManagedExecutorService> scheduleDurableExecutors) {
            this.executors = executors;
            this.durableExecutors = durableExecutors;
            this.scheduleDurableExecutors = scheduleDurableExecutors;
        }

        @Override
        public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
            MetricDescriptor executorDescriptor;
            for (ManagedExecutorService executorService : this.executors.values()) {
                executorDescriptor = descriptor.copy().withPrefix("executor.internal").withDiscriminator("name", executorService.getName()).withExcludedTarget(MetricTarget.MANAGEMENT_CENTER);
                context.collect(executorDescriptor, executorService);
            }
            for (ManagedExecutorService executorService : this.durableExecutors.values()) {
                executorDescriptor = descriptor.copy().withPrefix("executor.durable.internal").withDiscriminator("name", executorService.getName()).withExcludedTarget(MetricTarget.MANAGEMENT_CENTER);
                context.collect(executorDescriptor, executorService);
            }
            for (ManagedExecutorService executorService : this.scheduleDurableExecutors.values()) {
                executorDescriptor = descriptor.copy().withPrefix("executor.scheduled.internal").withDiscriminator("name", executorService.getName()).withExcludedTarget(MetricTarget.MANAGEMENT_CENTER);
                context.collect(executorDescriptor, executorService);
            }
        }
    }
}

