/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.snakeyaml.engine.v2.serializer;

import com.hazelcast.shaded.org.snakeyaml.engine.v2.common.Anchor;
import com.hazelcast.shaded.org.snakeyaml.engine.v2.nodes.Node;
import com.hazelcast.shaded.org.snakeyaml.engine.v2.serializer.AnchorGenerator;
import java.text.NumberFormat;
import java.util.Locale;

public class NumberAnchorGenerator
implements AnchorGenerator {
    private int lastAnchorId = 0;

    public NumberAnchorGenerator(int lastAnchorId) {
        this.lastAnchorId = lastAnchorId;
    }

    @Override
    public Anchor nextAnchor(Node node) {
        if (node.getAnchor().isPresent()) {
            return node.getAnchor().get();
        }
        ++this.lastAnchorId;
        NumberFormat format = NumberFormat.getNumberInstance(Locale.ROOT);
        format.setMinimumIntegerDigits(3);
        format.setMaximumFractionDigits(0);
        format.setGroupingUsed(false);
        String anchorId = format.format(this.lastAnchorId);
        return new Anchor("id" + anchorId);
    }
}

