/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl;

import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.partition.PartitionLostEvent;
import com.hazelcast.scheduledexecutor.IScheduledFuture;
import com.hazelcast.scheduledexecutor.ScheduledTaskHandler;
import com.hazelcast.scheduledexecutor.ScheduledTaskStatistics;
import com.hazelcast.scheduledexecutor.StaleTaskException;
import com.hazelcast.scheduledexecutor.impl.DistributedScheduledExecutorService;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorServiceProxy;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskResult;
import com.hazelcast.scheduledexecutor.impl.operations.CancelTaskOperation;
import com.hazelcast.scheduledexecutor.impl.operations.DisposeTaskOperation;
import com.hazelcast.scheduledexecutor.impl.operations.GetDelayOperation;
import com.hazelcast.scheduledexecutor.impl.operations.GetResultOperation;
import com.hazelcast.scheduledexecutor.impl.operations.GetStatisticsOperation;
import com.hazelcast.scheduledexecutor.impl.operations.IsCanceledOperation;
import com.hazelcast.scheduledexecutor.impl.operations.IsDoneOperation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

@SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
public final class ScheduledFutureProxy<V>
implements IScheduledFuture<V>,
HazelcastInstanceAware {
    private transient HazelcastInstance instance;
    private final transient AtomicBoolean partitionLost = new AtomicBoolean();
    private final transient AtomicBoolean memberLost = new AtomicBoolean();
    private volatile ScheduledTaskHandler handler;

    ScheduledFutureProxy(ScheduledTaskHandler handler, ScheduledExecutorServiceProxy executor) {
        Preconditions.checkNotNull(handler);
        this.handler = handler;
        ((DistributedScheduledExecutorService)executor.getService()).addLossListener(this);
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.instance = hazelcastInstance;
    }

    @Override
    public ScheduledTaskHandler getHandler() {
        return this.handler;
    }

    @Override
    public ScheduledTaskStatistics getStats() {
        this.checkAccessibleHandler();
        this.checkAccessibleOwner();
        GetStatisticsOperation op = new GetStatisticsOperation(this.handler);
        return (ScheduledTaskStatistics)this.invoke(op).joinInternal();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        Preconditions.checkNotNull(unit, "Unit is null");
        this.checkAccessibleHandler();
        this.checkAccessibleOwner();
        GetDelayOperation op = new GetDelayOperation(this.handler, unit);
        return (Long)this.invoke(op).joinInternal();
    }

    @Override
    public int compareTo(Delayed o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (mayInterruptIfRunning) {
            throw new UnsupportedOperationException("mayInterruptIfRunning flag is not supported.");
        }
        this.checkAccessibleHandler();
        this.checkAccessibleOwner();
        CancelTaskOperation op = new CancelTaskOperation(this.handler, false);
        return (Boolean)this.invoke(op).joinInternal();
    }

    @Override
    public boolean isCancelled() {
        this.checkAccessibleHandler();
        this.checkAccessibleOwner();
        IsCanceledOperation op = new IsCanceledOperation(this.handler);
        return (Boolean)this.invoke(op).joinInternal();
    }

    @Override
    public boolean isDone() {
        this.checkAccessibleHandler();
        this.checkAccessibleOwner();
        IsDoneOperation op = new IsDoneOperation(this.handler);
        return (Boolean)this.invoke(op).joinInternal();
    }

    private InvocationFuture<V> get0() {
        this.checkAccessibleHandler();
        this.checkAccessibleOwner();
        GetResultOperation op = new GetResultOperation(this.handler);
        return this.invoke(op);
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.get0().get();
        }
        catch (ScheduledTaskResult.ExecutionExceptionDecorator ex) {
            throw ExceptionUtil.sneakyThrow(ex.getCause());
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Preconditions.checkNotNull(unit, "Unit is null");
        try {
            return this.get0().get(timeout, unit);
        }
        catch (ScheduledTaskResult.ExecutionExceptionDecorator ex) {
            throw ExceptionUtil.sneakyThrow(ex.getCause());
        }
    }

    @Override
    public void dispose() {
        this.checkAccessibleHandler();
        this.checkAccessibleOwner();
        DisposeTaskOperation op = new DisposeTaskOperation(this.handler);
        InvocationFuture future = this.invoke(op);
        this.handler = null;
        future.joinInternal();
    }

    void notifyMemberLost(MembershipEvent event) {
        ScheduledTaskHandler handler = this.handler;
        if (handler == null) {
            return;
        }
        if (handler.isAssignedToMember() && handler.getUuid().equals(event.getMember().getUuid())) {
            this.memberLost.set(true);
        }
    }

    void notifyPartitionLost(PartitionLostEvent event) {
        ScheduledTaskHandler handler = this.handler;
        if (handler == null) {
            return;
        }
        int durability = this.instance.getConfig().getScheduledExecutorConfig(handler.getSchedulerName()).getDurability();
        if (handler.isAssignedToPartition() && handler.getPartitionId() == event.getPartitionId() && event.getLostBackupCount() >= durability) {
            this.partitionLost.set(true);
        }
    }

    private void checkAccessibleOwner() {
        if (this.handler.isAssignedToPartition()) {
            if (this.partitionLost.get()) {
                throw new IllegalStateException("Partition " + this.handler.getPartitionId() + ", holding this scheduled task was lost along with all backups.");
            }
        } else if (this.memberLost.get()) {
            throw new IllegalStateException("Member with address: " + String.valueOf(this.handler.getUuid()) + ",  holding this scheduled task is not part of this cluster.");
        }
    }

    private void checkAccessibleHandler() {
        if (this.handler == null) {
            throw new StaleTaskException("Scheduled task was previously disposed.");
        }
    }

    private <T> InvocationFuture<T> invoke(Operation op) {
        if (this.handler.isAssignedToPartition()) {
            op.setPartitionId(this.handler.getPartitionId());
            return this.invokeOnPartition(op);
        }
        return this.invokeOnTarget(op, this.handler.getUuid());
    }

    private <T> InvocationFuture<T> invokeOnPartition(Operation op) {
        OperationServiceImpl opService = ((HazelcastInstanceImpl)this.instance).node.getNodeEngine().getOperationService();
        return opService.invokeOnPartition(op);
    }

    private <T> InvocationFuture<T> invokeOnTarget(Operation op, UUID uuid) {
        NodeEngineImpl nodeEngine = ((HazelcastInstanceImpl)this.instance).node.getNodeEngine();
        MemberImpl member = nodeEngine.getClusterService().getMember(uuid);
        if (member == null) {
            throw new IllegalStateException("Member with address: " + String.valueOf(uuid) + ",  holding this scheduled task is not part of this cluster.");
        }
        OperationServiceImpl opService = nodeEngine.getOperationService();
        return opService.invokeOnTarget(op.getServiceName(), op, member.getAddress());
    }
}

