/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl;

import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.core.EntryListener;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.SetUtil;
import com.hazelcast.map.impl.DataCollection;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.multimap.LocalMultiMapStats;
import com.hazelcast.multimap.MultiMap;
import com.hazelcast.multimap.impl.MultiMapProxySupport;
import com.hazelcast.multimap.impl.MultiMapService;
import com.hazelcast.multimap.impl.operations.EntrySetResponse;
import com.hazelcast.multimap.impl.operations.MultiMapResponse;
import com.hazelcast.spi.impl.InitializingObject;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionOn;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MultiMapProxyImpl<K, V>
extends MultiMapProxySupport
implements MultiMap<K, V>,
InitializingObject {
    protected static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";
    protected static final String NULL_VALUE_IS_NOT_ALLOWED = "Null value is not allowed!";
    protected static final String NULL_LISTENER_IS_NOT_ALLOWED = "Null listener is not allowed!";

    public MultiMapProxyImpl(MultiMapConfig config, MultiMapService service, NodeEngine nodeEngine, String name) {
        super(config, service, nodeEngine, name);
    }

    @Override
    public void initialize() {
        NodeEngine nodeEngine = this.getNodeEngine();
        List<EntryListenerConfig> listenerConfigs = this.config.getEntryListenerConfigs();
        for (EntryListenerConfig listenerConfig : listenerConfigs) {
            EntryListener listener = null;
            if (listenerConfig.getImplementation() != null) {
                MapListener impl = listenerConfig.getImplementation();
                listener = Preconditions.checkInstanceOf(EntryListener.class, impl, String.valueOf(impl) + " should be an instance of EntryListener");
            } else if (listenerConfig.getClassName() != null) {
                try {
                    ClassLoader loader = NamespaceUtil.getClassLoaderForNamespace(nodeEngine, this.config.getUserCodeNamespace());
                    listener = (EntryListener)ClassLoaderUtil.newInstance(loader, listenerConfig.getClassName());
                }
                catch (Exception e) {
                    throw ExceptionUtil.rethrow(e);
                }
            }
            if (listener == null) continue;
            if (listenerConfig.isLocal()) {
                this.addLocalEntryListener(listener);
                continue;
            }
            this.addEntryListener(listener, listenerConfig.isIncludeValue());
        }
    }

    @Override
    public CompletionStage<Void> putAllAsync(@Nonnull Map<? extends K, Collection<? extends V>> m) {
        InternalCompletableFuture<Void> future = new InternalCompletableFuture<Void>();
        HashMap<Data, Data> dataMap = new HashMap<Data, Data>();
        for (Map.Entry<K, Collection<V>> e : m.entrySet()) {
            Collection<Data> dataCollection = CollectionUtil.objectToDataCollection(e.getValue(), this.getNodeEngine().getSerializationService());
            dataMap.put(this.toData(e.getKey()), this.toData(new DataCollection(dataCollection)));
        }
        this.putAllInternal(dataMap, future);
        return future;
    }

    @Override
    public CompletionStage<Void> putAllAsync(@Nonnull K key, @Nonnull Collection<? extends V> value) {
        InternalCompletableFuture<Void> future = new InternalCompletableFuture<Void>();
        HashMap<Data, Data> dataMap = new HashMap<Data, Data>();
        Collection<Data> dataCollection = CollectionUtil.objectToDataCollection(value, this.getNodeEngine().getSerializationService());
        dataMap.put(this.toData(key), this.toData(new DataCollection(dataCollection)));
        this.putAllInternal(dataMap, future);
        return future;
    }

    @Override
    public boolean put(@Nonnull K key, @Nonnull V value) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        NodeEngine nodeEngine = this.getNodeEngine();
        Data dataKey = nodeEngine.toData(key);
        Data dataValue = nodeEngine.toData(value);
        return this.putInternal(dataKey, dataValue, -1);
    }

    @Override
    @Nonnull
    public Collection<V> get(@Nonnull K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        NodeEngine nodeEngine = this.getNodeEngine();
        Data dataKey = nodeEngine.toData(key);
        MultiMapResponse result = this.getAllInternal(dataKey);
        return result.getObjectCollection(nodeEngine);
    }

    @Override
    public boolean remove(@Nonnull Object key, @Nonnull Object value) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        NodeEngine nodeEngine = this.getNodeEngine();
        Data dataKey = nodeEngine.toData(key);
        Data dataValue = nodeEngine.toData(value);
        return this.removeInternal(dataKey, dataValue);
    }

    @Override
    @Nonnull
    public Collection<V> remove(@Nonnull Object key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        NodeEngine nodeEngine = this.getNodeEngine();
        Data dataKey = nodeEngine.toData(key);
        MultiMapResponse result = this.removeInternal(dataKey);
        return result.getObjectCollection(nodeEngine);
    }

    @Override
    public void delete(@Nonnull Object key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        NodeEngine nodeEngine = this.getNodeEngine();
        Data dataKey = nodeEngine.toData(key);
        this.deleteInternal(dataKey);
    }

    @Override
    @Nonnull
    public Set<K> localKeySet() {
        this.ensureNoSplitBrain(SplitBrainProtectionOn.READ);
        Set<Data> dataKeySet = this.localKeySetInternal();
        return this.toObjectSet(dataKeySet);
    }

    @Override
    @Nonnull
    public Set<K> keySet() {
        Set<Data> dataKeySet = this.keySetInternal();
        return this.toObjectSet(dataKeySet);
    }

    @Override
    @Nonnull
    public Collection<V> values() {
        NodeEngine nodeEngine = this.getNodeEngine();
        Map map = this.valuesInternal();
        LinkedList values = new LinkedList();
        for (Object obj : map.values()) {
            if (obj == null) continue;
            MultiMapResponse response = (MultiMapResponse)nodeEngine.toObject(obj);
            values.addAll(response.getObjectCollection(nodeEngine));
        }
        return values;
    }

    @Override
    @Nonnull
    public Set<Map.Entry<K, V>> entrySet() {
        NodeEngine nodeEngine = this.getNodeEngine();
        Map map = this.entrySetInternal();
        HashSet<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>();
        for (Object obj : map.values()) {
            if (obj == null) continue;
            EntrySetResponse response = (EntrySetResponse)nodeEngine.toObject(obj);
            Set entries = response.getObjectEntrySet(nodeEngine);
            entrySet.addAll(entries);
        }
        return entrySet;
    }

    @Override
    public boolean containsKey(@Nonnull K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        NodeEngine nodeEngine = this.getNodeEngine();
        Data dataKey = nodeEngine.toData(key);
        return this.containsInternal(dataKey, null);
    }

    @Override
    public boolean containsValue(@Nonnull Object value) {
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        NodeEngine nodeEngine = this.getNodeEngine();
        Data valueKey = nodeEngine.toData(value);
        return this.containsInternal(null, valueKey);
    }

    @Override
    public boolean containsEntry(@Nonnull K key, @Nonnull V value) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        NodeEngine nodeEngine = this.getNodeEngine();
        Data dataKey = nodeEngine.toData(key);
        Data valueKey = nodeEngine.toData(value);
        return this.containsInternal(dataKey, valueKey);
    }

    @Override
    public int valueCount(@Nonnull K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        NodeEngine nodeEngine = this.getNodeEngine();
        Data dataKey = nodeEngine.toData(key);
        return this.countInternal(dataKey);
    }

    @Override
    @Nonnull
    public UUID addLocalEntryListener(@Nonnull EntryListener<K, V> listener) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        return ((MultiMapService)this.getService()).addLocalListener(this.name, listener, null, false);
    }

    @Override
    @Nonnull
    public UUID addLocalEntryListener(@Nonnull EntryListener<K, V> listener, boolean includeValue) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        return ((MultiMapService)this.getService()).addLocalListener(this.name, listener, null, includeValue);
    }

    @Override
    @Nonnull
    public UUID addEntryListener(@Nonnull EntryListener<K, V> listener, boolean includeValue) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        return ((MultiMapService)this.getService()).addListener(this.name, listener, null, includeValue);
    }

    @Override
    public boolean removeEntryListener(@Nonnull UUID registrationId) {
        Preconditions.checkNotNull(registrationId, "Registration ID should not be null!");
        return ((MultiMapService)this.getService()).removeListener(this.name, registrationId);
    }

    @Override
    @Nonnull
    public UUID addEntryListener(@Nonnull EntryListener<K, V> listener, @Nonnull K key, boolean includeValue) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        NodeEngine nodeEngine = this.getNodeEngine();
        Data dataKey = nodeEngine.toData(key);
        return ((MultiMapService)this.getService()).addListener(this.name, listener, dataKey, includeValue);
    }

    @Override
    public void lock(@Nonnull K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        NodeEngine nodeEngine = this.getNodeEngine();
        Data dataKey = nodeEngine.toData(key);
        this.lockSupport.lock(nodeEngine, dataKey);
    }

    @Override
    public void lock(@Nonnull K key, long leaseTime, @Nonnull TimeUnit timeUnit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(timeUnit, "Null timeUnit is not allowed!");
        Preconditions.checkPositive("leaseTime", leaseTime);
        NodeEngine nodeEngine = this.getNodeEngine();
        Data dataKey = nodeEngine.toData(key);
        this.lockSupport.lock(nodeEngine, dataKey, timeUnit.toMillis(leaseTime));
    }

    @Override
    public boolean isLocked(@Nonnull K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        NodeEngine nodeEngine = this.getNodeEngine();
        Data dataKey = nodeEngine.toData(key);
        return this.lockSupport.isLocked(nodeEngine, dataKey);
    }

    @Override
    public boolean tryLock(@Nonnull K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        NodeEngine nodeEngine = this.getNodeEngine();
        Data dataKey = nodeEngine.toData(key);
        return this.lockSupport.tryLock(nodeEngine, dataKey);
    }

    @Override
    public boolean tryLock(@Nonnull K key, long time, TimeUnit timeunit) throws InterruptedException {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        NodeEngine nodeEngine = this.getNodeEngine();
        Data dataKey = nodeEngine.toData(key);
        return this.lockSupport.tryLock(nodeEngine, dataKey, time, timeunit);
    }

    @Override
    public boolean tryLock(@Nonnull K key, long time, @Nullable TimeUnit timeunit, long leaseTime, @Nullable TimeUnit leaseUnit) throws InterruptedException {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        NodeEngine nodeEngine = this.getNodeEngine();
        Data dataKey = nodeEngine.toData(key);
        return this.lockSupport.tryLock(nodeEngine, dataKey, time, timeunit, leaseTime, leaseUnit);
    }

    @Override
    public void unlock(@Nonnull K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        NodeEngine nodeEngine = this.getNodeEngine();
        Data dataKey = nodeEngine.toData(key);
        this.lockSupport.unlock(nodeEngine, dataKey);
    }

    @Override
    public void forceUnlock(@Nonnull K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        NodeEngine nodeEngine = this.getNodeEngine();
        Data dataKey = nodeEngine.toData(key);
        this.lockSupport.forceUnlock(nodeEngine, dataKey);
    }

    @Override
    @Nonnull
    public LocalMultiMapStats getLocalMultiMapStats() {
        return ((MultiMapService)this.getService()).createStats(this.name);
    }

    private Set<K> toObjectSet(Set<Data> dataSet) {
        NodeEngine nodeEngine = this.getNodeEngine();
        Set keySet = SetUtil.createHashSet(dataSet.size());
        for (Data dataKey : dataSet) {
            keySet.add(nodeEngine.toObject(dataKey));
        }
        if (this.config.isStatisticsEnabled()) {
            ((MultiMapService)this.getService()).getLocalMultiMapStatsImpl(this.name).incrementOtherOperations();
        }
        return keySet;
    }

    private void ensureNoSplitBrain(SplitBrainProtectionOn requiredSplitBrainProtectionPermissionType) {
        ((MultiMapService)this.getService()).ensureNoSplitBrain(this.name, requiredSplitBrainProtectionPermissionType);
    }
}

