/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.map.impl.MetadataInitializer;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.JsonMetadataStore;
import com.hazelcast.map.impl.recordstore.MutationObserver;
import com.hazelcast.query.impl.JsonMetadata;
import com.hazelcast.query.impl.Metadata;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import javax.annotation.Nonnull;

public class JsonMetadataMutationObserver
implements MutationObserver<Record> {
    private final SerializationService serializationService;
    private final MetadataInitializer metadataInitializer;
    private final JsonMetadataStore metadataStore;
    private final InMemoryFormat inMemoryFormat;

    public JsonMetadataMutationObserver(SerializationService serializationService, MetadataInitializer metadataInitializer, JsonMetadataStore metadataStore, InMemoryFormat inMemoryFormat) {
        this.serializationService = serializationService;
        this.metadataInitializer = metadataInitializer;
        this.metadataStore = metadataStore;
        this.inMemoryFormat = inMemoryFormat;
    }

    @Override
    public void onPutRecord(@Nonnull Data key, Record record, Object oldValue, boolean backup) {
        this.onPutInternal(key, record);
    }

    @Override
    public void onReplicationPutRecord(@Nonnull Data key, @Nonnull Record record, boolean populateIndex) {
        this.onPutInternal(key, record);
    }

    @Override
    public void onUpdateRecord(@Nonnull Data key, @Nonnull Record record, Object oldValue, Object newValue, boolean backup) {
        this.updateValueMetadataIfNecessary(key, newValue);
    }

    @Override
    public void onLoadRecord(@Nonnull Data key, @Nonnull Record record, boolean backup) {
        this.onPutInternal(key, record);
    }

    @Override
    public void onRemoveRecord(Data key, Record record, boolean backup) {
        this.metadataStore.remove(key);
    }

    @Override
    public void onEvictRecord(Data key, Record record, boolean backup) {
        this.metadataStore.remove(key);
    }

    @Override
    public void onReset() {
        this.metadataStore.clear();
    }

    @Override
    public void onClear() {
        this.metadataStore.clear();
    }

    @Override
    public void onDestroy(boolean isDuringShutdown, boolean internal) {
        this.metadataStore.clear();
    }

    protected JsonMetadata getMetadata(Data dataKey) {
        return this.metadataStore.get(dataKey);
    }

    protected void setMetadata(Data dataKey, JsonMetadata metadata) {
        this.metadataStore.set(dataKey, metadata);
    }

    protected void setMetadataValue(Data dataKey, Object metadataValue) {
        this.metadataStore.setValue(dataKey, metadataValue);
    }

    protected void removeMetadata(Data dataKey) {
        this.metadataStore.remove(dataKey);
    }

    private void onPutInternal(Data dataKey, Record record) {
        Metadata metadata = this.initializeMetadata(dataKey, record.getValue());
        if (metadata != null) {
            this.setMetadata(dataKey, metadata);
        }
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    private void updateValueMetadataIfNecessary(Data dataKey, Object updateValue) {
        Object valueMetadata = null;
        try {
            valueMetadata = switch (this.inMemoryFormat) {
                default -> throw new IncompatibleClassChangeError();
                case InMemoryFormat.OBJECT -> {
                    Data serializedData;
                    Object valueObject = updateValue instanceof Data && (serializedData = (Data)updateValue).isJson() ? this.serializationService.toObject(updateValue) : updateValue;
                    yield this.metadataInitializer.createFromObject(valueObject);
                }
                case InMemoryFormat.BINARY, InMemoryFormat.NATIVE -> {
                    if (updateValue instanceof Data) {
                        Data valueData = (Data)updateValue;
                        yield this.metadataInitializer.createFromData(valueData);
                    }
                    yield updateValue instanceof HazelcastJsonValue ? this.metadataInitializer.createFromData((Data)this.serializationService.toData(updateValue)) : null;
                }
            };
        }
        catch (IOException e) {
            EmptyStatement.ignore(e);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        this.setMetadataValue(dataKey, valueMetadata);
    }

    private Metadata initializeMetadata(Data key, Object value) {
        try {
            Object valueMetadata;
            Object keyMetadata = this.metadataInitializer.createFromData(key);
            if (value instanceof Data) {
                Data data = (Data)value;
                valueMetadata = this.metadataInitializer.createFromData(data);
            } else {
                valueMetadata = this.metadataInitializer.createFromObject(value);
            }
            if (keyMetadata != null || valueMetadata != null) {
                Metadata metadata = new Metadata(keyMetadata, valueMetadata);
                return metadata;
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }
}

