/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordReaderWriter;
import java.util.Objects;

public class SimpleRecord<V>
implements Record<V> {
    protected volatile V value;
    private int version;

    SimpleRecord() {
    }

    public SimpleRecord(V value) {
        this.setValue(value);
    }

    @Override
    public final int getVersion() {
        return this.version;
    }

    @Override
    public final void setVersion(int version) {
        this.version = version;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public void setValue(V value) {
        this.value = value;
    }

    @Override
    public Object getCachedValueUnsafe() {
        return Record.NOT_CACHED;
    }

    @Override
    public boolean casCachedValue(Object expectedValue, Object newValue) {
        return true;
    }

    @Override
    public long getCost() {
        V v = this.value;
        if (v instanceof Data) {
            Data data = (Data)v;
            return JVMUtil.OBJECT_HEADER_SIZE + JVMUtil.REFERENCE_COST_IN_BYTES + data.getHeapCost();
        }
        return 0L;
    }

    @Override
    public void onAccess(long now) {
    }

    @Override
    public void onStore() {
    }

    @Override
    public RecordReaderWriter getMatchingRecordReaderWriter() {
        return RecordReaderWriter.SIMPLE_DATA_RECORD_READER_WRITER;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleRecord that = (SimpleRecord)o;
        if (this.version != that.version) {
            return false;
        }
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + this.version;
        return result;
    }

    public String toString() {
        return "SimpleRecord{value=" + String.valueOf(this.value) + ", version=" + this.version + "}";
    }
}

