/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache.accumulator;

import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.namespace.impl.NodeEngineThreadLocalContext;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.impl.NodeEngine;
import java.io.IOException;

public class AccumulatorInfo
implements IdentifiedDataSerializable {
    private String mapName;
    private String cacheId;
    private Predicate predicate;
    private int batchSize;
    private int bufferSize;
    private long delaySeconds;
    private boolean includeValue;
    private boolean populate;
    private boolean coalesce;
    private volatile boolean publishable;

    public static AccumulatorInfo toAccumulatorInfo(QueryCacheConfig config, String mapName, String cacheId, Predicate predicate) {
        Preconditions.checkNotNull(config, "config cannot be null");
        AccumulatorInfo info = new AccumulatorInfo();
        info.mapName = mapName;
        info.cacheId = cacheId;
        info.batchSize = AccumulatorInfo.calculateBatchSize(config);
        info.bufferSize = config.getBufferSize();
        info.delaySeconds = config.getDelaySeconds();
        info.includeValue = config.isIncludeValue();
        info.populate = config.isPopulate();
        info.predicate = AccumulatorInfo.getPredicate(config, predicate);
        info.coalesce = config.isCoalesce();
        info.publishable = false;
        return info;
    }

    public static AccumulatorInfo toAccumulatorInfo(String mapName, String cacheId, Predicate predicate, int batchSize, int bufferSize, long delaySeconds, boolean includeValue, boolean populate, boolean coalesce) {
        AccumulatorInfo info = new AccumulatorInfo();
        info.mapName = mapName;
        info.cacheId = cacheId;
        info.batchSize = batchSize;
        info.bufferSize = bufferSize;
        info.delaySeconds = delaySeconds;
        info.includeValue = includeValue;
        info.populate = populate;
        info.predicate = predicate;
        info.coalesce = coalesce;
        info.publishable = false;
        return info;
    }

    private static Predicate getPredicate(QueryCacheConfig config, Predicate predicate) {
        if (predicate != null) {
            return predicate;
        }
        Predicate implementation = config.getPredicateConfig().getImplementation();
        if (implementation != null) {
            return implementation;
        }
        throw new IllegalArgumentException("Predicate cannot be null");
    }

    private static int calculateBatchSize(QueryCacheConfig config) {
        int bufferSize;
        int batchSize = config.getBatchSize();
        return batchSize > (bufferSize = config.getBufferSize()) ? bufferSize : batchSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public long getDelaySeconds() {
        return this.delaySeconds;
    }

    public boolean isIncludeValue() {
        return this.includeValue;
    }

    public String getMapName() {
        return this.mapName;
    }

    public String getCacheId() {
        return this.cacheId;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public boolean isPublishable() {
        return this.publishable;
    }

    public boolean isPopulate() {
        return this.populate;
    }

    public void setPublishable(boolean publishable) {
        this.publishable = publishable;
    }

    public boolean isCoalesce() {
        return this.coalesce;
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.mapName);
        out.writeString(this.cacheId);
        out.writeInt(this.batchSize);
        out.writeInt(this.bufferSize);
        out.writeLong(this.delaySeconds);
        out.writeBoolean(this.includeValue);
        out.writeBoolean(this.publishable);
        out.writeBoolean(this.coalesce);
        out.writeBoolean(this.populate);
        out.writeObject(this.predicate);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.mapName = in.readString();
        this.cacheId = in.readString();
        this.batchSize = in.readInt();
        this.bufferSize = in.readInt();
        this.delaySeconds = in.readLong();
        this.includeValue = in.readBoolean();
        this.publishable = in.readBoolean();
        this.coalesce = in.readBoolean();
        this.populate = in.readBoolean();
        NodeEngine engine = NodeEngineThreadLocalContext.getNodeEngineThreadLocalContext();
        this.predicate = NamespaceUtil.callWithNamespace(engine, MapService.lookupNamespace(engine, this.mapName), in::readObject);
    }

    public String toString() {
        return "AccumulatorInfo{batchSize=" + this.batchSize + ", mapName='" + this.mapName + "', cacheId='" + this.cacheId + "', predicate=" + String.valueOf(this.predicate) + ", bufferSize=" + this.bufferSize + ", delaySeconds=" + this.delaySeconds + ", includeValue=" + this.includeValue + ", populate=" + this.populate + ", coalesce=" + this.coalesce + ", publishable=" + this.publishable + "}";
    }
}

