/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation.steps;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.operation.MergeOperation;
import com.hazelcast.map.impl.operation.steps.DeleteOpSteps;
import com.hazelcast.map.impl.operation.steps.IMapOpStep;
import com.hazelcast.map.impl.operation.steps.PutOpSteps;
import com.hazelcast.map.impl.operation.steps.UtilSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.DefaultRecordStore;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.StaticParams;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.spi.impl.merge.MergingValueFactory;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import com.hazelcast.wan.impl.CallerProvenance;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Queue;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MergeOpSteps implements IMapOpStep
{
    READ{

        @Override
        public void runStep(State state) {
            MergeOperation operation = (MergeOperation)state.getOperation();
            DefaultRecordStore recordStore = (DefaultRecordStore)state.getRecordStore();
            MapContainer mapContainer = recordStore.getMapContainer();
            MapServiceContext mapServiceContext = mapContainer.getMapServiceContext();
            SerializationService serializationService = mapServiceContext.getNodeEngine().getSerializationService();
            List<SplitBrainMergeTypes.MapMergeTypes<Object, Object>> mergingEntries = state.getMergingEntries();
            SplitBrainMergePolicy mergePolicy = state.getMergePolicy();
            MergeOperation.checkMergePolicy(mapContainer, mergePolicy);
            Queue<InternalIndex> notMarkedIndexes = operation.beginIndexMarking();
            state.setNotMarkedIndexes(notMarkedIndexes);
            ArrayList<Object> outcomes = new ArrayList<Object>(5 * mergingEntries.size());
            for (SplitBrainMergeTypes.MapMergeTypes<Object, Object> mapMergeTypes : mergingEntries) {
                SplitBrainMergeTypes.MapMergeTypes mapMergeTypes2 = (SplitBrainMergeTypes.MapMergeTypes)serializationService.getManagedContext().initialize(mapMergeTypes);
                mergePolicy = (SplitBrainMergePolicy)serializationService.getManagedContext().initialize(mergePolicy);
                Data key = (Data)mapMergeTypes2.getRawKey();
                Record record = recordStore.getRecordOrNull(key, state.getNow(), false);
                SplitBrainMergeTypes.MapMergeTypes existingEntry = record != null ? MergingValueFactory.createMergingEntry(serializationService, key, record, recordStore.getExpirySystem().getExpiryMetadata(key)) : null;
                Object oldValue = record == null ? null : record.getValue();
                Object newValue = mergePolicy.merge(mapMergeTypes2, existingEntry);
                if (oldValue == null && newValue == null) continue;
                outcomes.add(key);
                outcomes.add(recordStore.copyToHeapWhenNeeded(oldValue));
                outcomes.add(recordStore.copyToHeapWhenNeeded(newValue));
                outcomes.add(mapMergeTypes2);
                outcomes.add(existingEntry);
            }
            state.setResult(outcomes);
        }

        @Override
        public Step nextStep(State state) {
            boolean persistenceEnabled = ((DefaultRecordStore)state.getRecordStore()).persistenceEnabledFor(state.getCallerProvenance());
            List outcomes = (List)state.getResult();
            return !outcomes.isEmpty() && persistenceEnabled ? STORE_OR_DELETE : PROCESS;
        }
    }
    ,
    STORE_OR_DELETE{

        @Override
        public boolean isStoreStep() {
            return true;
        }

        @Override
        public void runStep(State state) {
            List outcomes = (List)state.getResult();
            State perKeyState = new State(state);
            for (int i = 0; i < outcomes.size(); i += 5) {
                Object key = outcomes.get(i);
                assert (key instanceof Data) : "Expect key instanceOf Data but found " + String.valueOf(key);
                Object oldValue = outcomes.get(i + 1);
                Object newValue = outcomes.get(i + 2);
                perKeyState.setKey((Data)key).setOldValue(oldValue).setNewValue(newValue);
                if (oldValue == null && newValue != null || oldValue != null && newValue != null) {
                    PutOpSteps.STORE.runStep(perKeyState);
                    outcomes.set(i + 2, perKeyState.getNewValue());
                    continue;
                }
                if (oldValue == null || newValue != null) continue;
                DeleteOpSteps.DELETE.runStep(perKeyState);
            }
            state.setResult(outcomes);
        }

        @Override
        public Step nextStep(State state) {
            return PROCESS;
        }
    }
    ,
    PROCESS{

        @Override
        public void runStep(State state) {
            DefaultRecordStore recordStore = (DefaultRecordStore)state.getRecordStore();
            MapContainer mapContainer = recordStore.getMapContainer();
            MapServiceContext mapServiceContext = mapContainer.getMapServiceContext();
            SerializationService serializationService = mapServiceContext.getNodeEngine().getSerializationService();
            List outcomes = (List)state.getResult();
            State perKeyState = new State(state);
            for (int i = 0; i < outcomes.size(); i += 5) {
                Object key = outcomes.get(i);
                assert (key instanceof Data) : "Expect key instanceOf Data but found " + String.valueOf(key);
                Object oldValue = outcomes.get(i + 1);
                Object newValue = outcomes.get(i + 2);
                perKeyState.setKey((Data)key).setOldValue(oldValue).setNewValue(newValue).setStaticPutParams(StaticParams.PUT_PARAMS);
                if (oldValue == null && newValue != null || oldValue != null && newValue != null) {
                    SplitBrainMergeTypes.MapMergeTypes mergingEntry = (SplitBrainMergeTypes.MapMergeTypes)outcomes.get(i + 3);
                    if (recordStore.getValueComparator().isEqual(newValue, oldValue, serializationService)) {
                        Record record;
                        boolean shouldMergeExpiration;
                        SplitBrainMergeTypes.MapMergeTypes existingEntry = (SplitBrainMergeTypes.MapMergeTypes)outcomes.get(i + 4);
                        boolean bl = shouldMergeExpiration = state.getCallerProvenance() != CallerProvenance.WAN || recordStore.getValueComparator().isEqual(existingEntry.getRawValue(), mergingEntry.getRawValue(), serializationService);
                        if (!shouldMergeExpiration || (record = recordStore.getRecord((Data)key)) == null || recordStore.mergeRecordExpiration((Data)key, record, mergingEntry, state.getNow())) continue;
                        if (state.getNonWanReplicatedIndexes() == null) {
                            state.setNonWanReplicatedIndexes(new BitSet());
                        }
                        state.getNonWanReplicatedIndexes().set(i / 5);
                        continue;
                    }
                    PutOpSteps.ON_STORE.runStep(perKeyState);
                    Record record = recordStore.getRecord((Data)key);
                    recordStore.mergeRecordExpiration((Data)key, record, mergingEntry, state.getNow());
                    continue;
                }
                if (oldValue == null || newValue != null) continue;
                DeleteOpSteps.ON_DELETE.runStep(perKeyState);
            }
        }

        @Override
        public Step nextStep(State state) {
            return RESPONSE;
        }
    }
    ,
    RESPONSE{

        @Override
        public void runStep(State state) {
            RecordStore recordStore = state.getRecordStore();
            MapContainer mapContainer = recordStore.getMapContainer();
            MapServiceContext mapServiceContext = mapContainer.getMapServiceContext();
            MapEventPublisher mapEventPublisher = mapServiceContext.getMapEventPublisher();
            MergeOperation operation = (MergeOperation)state.getOperation();
            ArrayList<Data> invalidationKeys = null;
            boolean hasMergedValues = false;
            ArrayList<Data> backupPairs = null;
            boolean hasMapListener = mapEventPublisher.hasEventListener(state.getOperation().getName());
            boolean hasWanReplication = mapContainer.getWanContext().isWanReplicationEnabled() && !state.isDisableWanReplicationEvent();
            boolean hasBackups = mapContainer.getTotalBackupCount() > 0;
            boolean hasInvalidation = mapContainer.hasInvalidationListener();
            List outcomes = (List)state.getResult();
            if (hasBackups) {
                backupPairs = new ArrayList<Data>(2 * (outcomes.size() / 5));
            }
            if (hasInvalidation) {
                invalidationKeys = new ArrayList<Data>(outcomes.size() / 5);
            }
            for (int i = 0; i < outcomes.size(); i += 5) {
                hasMergedValues = true;
                Data dataKey = (Data)outcomes.get(i);
                Object oldValue = outcomes.get(i + 1);
                Object newValue = outcomes.get(i + 2);
                Data dataValue = operation.getValueOrPostProcessedValue(dataKey, operation.getValue(dataKey));
                mapServiceContext.interceptAfterPut(mapContainer.getInterceptorRegistry(), dataValue);
                if (hasMapListener) {
                    mapEventPublisher.publishEvent(state.getCallerAddress(), state.getOperation().getName(), EntryEventType.MERGED, dataKey, oldValue, dataValue);
                }
                if (hasWanReplication) {
                    boolean nonReplicatedKey;
                    boolean bl = nonReplicatedKey = state.getNonWanReplicatedIndexes() != null && state.getNonWanReplicatedIndexes().get(i / 5);
                    if (!nonReplicatedKey) {
                        operation.publishWanUpdate(dataKey, dataValue);
                    }
                }
                if (hasInvalidation) {
                    invalidationKeys.add(dataKey);
                }
                if (hasBackups) {
                    backupPairs.add(dataKey);
                    backupPairs.add(dataValue);
                }
                operation.evict(dataKey);
            }
            state.setBackupPairs(backupPairs);
            state.setResult(hasMergedValues);
            operation.invalidateNearCache(invalidationKeys);
            operation.finishIndexMarking(state.getNotMarkedIndexes());
            operation.setNonWanReplicatedKeys(state.getNonWanReplicatedIndexes());
        }

        @Override
        public Step nextStep(State state) {
            return UtilSteps.FINAL_STEP;
        }
    };

    private static final int NUMBER_OF_ITEMS = 5;
    private static final int OLD_VALUE_OFFSET = 1;
    private static final int NEW_VALUE_OFFSET = 2;
    private static final int MERGING_ENTRY_OFFSET = 3;
    private static final int EXISTING_ENTRY_OFFSET = 4;
}

