/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.namespace.impl.NodeEngineThreadLocalContext;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.ToHeapDataConverter;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.operation.AbstractMultipleEntryBackupOperation;
import com.hazelcast.map.impl.operation.EntryOperator;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import java.io.IOException;
import java.util.LinkedList;

public class PartitionWideEntryBackupOperation
extends AbstractMultipleEntryBackupOperation
implements BackupOperation {
    public PartitionWideEntryBackupOperation() {
    }

    public PartitionWideEntryBackupOperation(String name, EntryProcessor backupProcessor) {
        super(name, backupProcessor);
    }

    @Override
    protected void runInternal() {
        if (this.mapContainer.getMapConfig().getInMemoryFormat() == InMemoryFormat.NATIVE) {
            this.runWithPartitionScanForNative();
        } else {
            this.runWithPartitionScan();
        }
    }

    private void runWithPartitionScan() {
        EntryOperator operator = EntryOperator.operator(this, this.backupProcessor, this.getPredicate());
        this.recordStore.forEach((key, record) -> operator.operateOnKey((Data)key).doPostOperateOps(), true);
    }

    protected void runWithPartitionScanForNative() {
        EntryOperator operator = EntryOperator.operator(this, this.backupProcessor, this.getPredicate());
        LinkedList outComes = new LinkedList();
        this.recordStore.forEach((key, record) -> {
            Data dataKey = ToHeapDataConverter.toHeapData(key);
            operator.operateOnKeyValueDuringScan(dataKey, record.getValue());
            EntryEventType eventType = operator.getEventType();
            if (eventType != null) {
                outComes.add(dataKey);
                outComes.add(operator.getOldValue());
                outComes.add(operator.getByPreferringDataNewValue());
                outComes.add(eventType);
                outComes.add(operator.getEntry().getNewTtl());
                outComes.add(operator.getEntry().isChangeExpiryOnUpdate());
            }
        }, true);
        while (!outComes.isEmpty()) {
            Data dataKey = (Data)outComes.poll();
            Object oldValue = outComes.poll();
            Object newValue = outComes.poll();
            EntryEventType eventType = (EntryEventType)((Object)outComes.poll());
            long newTtl = (Long)outComes.poll();
            boolean changeExpiryOnUpdate = (Boolean)outComes.poll();
            operator.init(dataKey, oldValue, newValue, null, eventType, null, changeExpiryOnUpdate, newTtl).doPostOperateOps();
        }
    }

    @Override
    public Object getResponse() {
        return true;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        NodeEngine engine = NodeEngineThreadLocalContext.getNodeEngineThreadLocalContext();
        String namespace = MapService.lookupNamespace(engine, this.name);
        NamespaceUtil.setupNamespace(engine, namespace);
        this.backupProcessor = (EntryProcessor)in.readObject();
        this.afterReadInternal();
    }

    protected void afterReadInternal() {
        NodeEngine engine = NodeEngineThreadLocalContext.getNodeEngineThreadLocalContext();
        String namespace = MapService.lookupNamespace(engine, this.name);
        NamespaceUtil.cleanupNamespace(engine, namespace);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.backupProcessor);
    }

    @Override
    public int getClassId() {
        return 38;
    }
}

