/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.operation.MergeOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.operations.PartitionAwareOperationFactory;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class MergeOperationFactory
extends PartitionAwareOperationFactory {
    protected String name;
    protected List<SplitBrainMergeTypes.MapMergeTypes<Object, Object>>[] mergingEntries;
    protected SplitBrainMergePolicy<Object, SplitBrainMergeTypes.MapMergeTypes<Object, Object>, Object> mergePolicy;

    public MergeOperationFactory() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public MergeOperationFactory(String name, int[] partitions, List<SplitBrainMergeTypes.MapMergeTypes<Object, Object>>[] mergingEntries, SplitBrainMergePolicy<Object, SplitBrainMergeTypes.MapMergeTypes<Object, Object>, Object> mergePolicy) {
        this.name = name;
        this.partitions = partitions;
        this.mergingEntries = mergingEntries;
        this.mergePolicy = mergePolicy;
    }

    @Override
    public Operation createPartitionOperation(int partitionId) {
        for (int i = 0; i < this.partitions.length; ++i) {
            if (this.partitions[i] != partitionId) continue;
            return new MergeOperation(this.name, this.mergingEntries[i], this.mergePolicy, false);
        }
        throw new IllegalArgumentException("Unknown partitionId " + partitionId + " (" + Arrays.toString(this.partitions) + ")");
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeIntArray(this.partitions);
        for (List<SplitBrainMergeTypes.MapMergeTypes<Object, Object>> list : this.mergingEntries) {
            out.writeInt(list.size());
            for (SplitBrainMergeTypes.MapMergeTypes<Object, Object> mergingEntry : list) {
                out.writeObject(mergingEntry);
            }
        }
        out.writeObject(this.mergePolicy);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.partitions = in.readIntArray();
        this.mergingEntries = new List[this.partitions.length];
        for (int partitionIndex = 0; partitionIndex < this.partitions.length; ++partitionIndex) {
            this.mergingEntries[partitionIndex] = SerializationUtil.readList(in);
        }
        this.mergePolicy = NamespaceUtil.callWithNamespace(in::readObject, this.name, MapService::lookupNamespace);
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 135;
    }
}

