/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.mapstore.writebehind;

import com.hazelcast.map.ReachedMaxSizeException;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.concurrent.atomic.AtomicLong;

public class NodeWideUsedCapacityCounter {
    private final long maxPerNodeCapacity;
    private final AtomicLong nodeWideUsedCapacityCounter = new AtomicLong();

    public NodeWideUsedCapacityCounter(HazelcastProperties properties) {
        this.maxPerNodeCapacity = properties.getLong(ClusterProperty.MAP_WRITE_BEHIND_QUEUE_CAPACITY);
    }

    public void checkAndAddCapacityOrThrowException(int delta) {
        if (delta == 0) {
            return;
        }
        long currentCapacity = this.nodeWideUsedCapacityCounter.get();
        long newCapacity = currentCapacity + (long)delta;
        if (newCapacity < 0L) {
            return;
        }
        if (delta > 0 && this.maxPerNodeCapacity < newCapacity) {
            NodeWideUsedCapacityCounter.throwException(currentCapacity, this.maxPerNodeCapacity, delta);
        }
        while (!this.nodeWideUsedCapacityCounter.compareAndSet(currentCapacity, newCapacity)) {
            currentCapacity = this.nodeWideUsedCapacityCounter.get();
            newCapacity = currentCapacity + (long)delta;
            if (newCapacity < 0L) {
                return;
            }
            if (delta <= 0 || this.maxPerNodeCapacity >= newCapacity) continue;
            NodeWideUsedCapacityCounter.throwException(currentCapacity, this.maxPerNodeCapacity, delta);
        }
    }

    private static void throwException(long currentCapacity, long maxPerNodeCapacity, int requiredCapacity) {
        String msg = String.format("Reached node-wide write-behind-queue max capacity [max=%d, current=%d, required=%d]", maxPerNodeCapacity, currentCapacity, requiredCapacity);
        throw new ReachedMaxSizeException(msg);
    }

    public void add(long delta) {
        this.nodeWideUsedCapacityCounter.addAndGet(delta);
    }

    public long currentValue() {
        return this.nodeWideUsedCapacityCounter.get();
    }
}

