/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.kubernetes;

import com.hazelcast.internal.json.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class RuntimeContext {
    @Deprecated(forRemoval=true, since="5.6")
    public static final long UNKNOWN = -1L;
    private static final String UNSUPPORTED_API_MESSAGE = "RuntimeContext created using deprecated constructor. For support use RuntimeContext() and RuntimeContext(RuntimeContext)";
    private final Map<String, StatefulSetInfo> statefulSets = new HashMap<String, StatefulSetInfo>();
    private StatefulSetInfo merged;
    private String resourceVersion;
    @Nullable
    private final RuntimeContextImmutable immutableContext;

    public RuntimeContext() {
        this.immutableContext = null;
    }

    public RuntimeContext(RuntimeContext context) {
        if (context.immutableContext != null) {
            throw new UnsupportedOperationException("Copying the state of a RuntimeContext created using a deprecated API is not permitted");
        }
        this.statefulSets.putAll(context.statefulSets);
        this.merged = context.merged;
        this.resourceVersion = context.resourceVersion;
        this.immutableContext = null;
    }

    @Deprecated(forRemoval=true, since="5.6")
    public RuntimeContext(int specifiedReplicaCount, int readyReplicas, int currentReplicas, @Nullable String resourceVersion) {
        this.immutableContext = new RuntimeContextImmutable(specifiedReplicaCount, readyReplicas, currentReplicas, resourceVersion);
    }

    private boolean isLegacy() {
        return this.immutableContext != null;
    }

    private StatefulSetInfo getMerged() {
        if (this.merged == null) {
            this.merged = new StatefulSetInfo(this.sum(StatefulSetInfo::specifiedReplicaCount), this.sum(StatefulSetInfo::readyReplicas), this.sum(StatefulSetInfo::currentReplicas));
        }
        return this.merged;
    }

    private int sum(ToIntFunction<StatefulSetInfo> fieldExtractor) {
        return this.statefulSets.values().stream().mapToInt(fieldExtractor).reduce((a, b) -> a == -1 || b == -1 ? -1 : a + b).orElse(-1);
    }

    public int getSpecifiedReplicaCount() {
        return this.isLegacy() ? this.immutableContext.specifiedReplicaCount : this.getMerged().specifiedReplicaCount;
    }

    public int getReadyReplicas() {
        return this.isLegacy() ? this.immutableContext.readyReplicas : this.getMerged().readyReplicas;
    }

    public int getCurrentReplicas() {
        return this.isLegacy() ? this.immutableContext.currentReplicas : this.getMerged().currentReplicas;
    }

    public String getResourceVersion() {
        return this.isLegacy() ? this.immutableContext.resourceVersion : this.resourceVersion;
    }

    public int getStatefulSetCount() {
        if (this.isLegacy()) {
            throw new UnsupportedOperationException(UNSUPPORTED_API_MESSAGE);
        }
        return this.statefulSets.size();
    }

    public void addStatefulSetInfo(String name, @Nonnull StatefulSetInfo info, String resourceVersion) {
        if (this.isLegacy()) {
            throw new UnsupportedOperationException(UNSUPPORTED_API_MESSAGE);
        }
        StatefulSetInfo previous = this.statefulSets.put(name, info);
        if (!info.equals(previous)) {
            this.merged = null;
        }
        this.resourceVersion = resourceVersion;
    }

    public String toString() {
        if (this.isLegacy()) {
            return this.immutableContext.toString();
        }
        return "RuntimeContext{specifiedReplicaCount=" + this.getSpecifiedReplicaCount() + ", readyReplicas=" + this.getReadyReplicas() + ", currentReplicas=" + this.getCurrentReplicas() + ", resourceVersion='" + this.resourceVersion + "'}";
    }

    private static final class RuntimeContextImmutable {
        private final int specifiedReplicaCount;
        private final int readyReplicas;
        private final int currentReplicas;
        @Nullable
        private final String resourceVersion;

        private RuntimeContextImmutable(int specifiedReplicaCount, int readyReplicas, int currentReplicas, @Nullable String resourceVersion) {
            this.specifiedReplicaCount = specifiedReplicaCount;
            this.readyReplicas = readyReplicas;
            this.currentReplicas = currentReplicas;
            this.resourceVersion = resourceVersion;
        }

        public String toString() {
            return "RuntimeContext{specifiedReplicaCount=" + this.specifiedReplicaCount + ", readyReplicas=" + this.readyReplicas + ", currentReplicas=" + this.currentReplicas + ", resourceVersion='" + this.resourceVersion + "'}";
        }
    }

    public record StatefulSetInfo(int specifiedReplicaCount, int readyReplicas, int currentReplicas) {
        @Nonnull
        public static StatefulSetInfo from(@Nonnull JsonObject statefulSet) {
            int specReplicas = statefulSet.get("spec").asObject().getInt("replicas", -1);
            int readyReplicas = statefulSet.get("status").asObject().getInt("readyReplicas", 0);
            int replicas = statefulSet.get("status").asObject().getInt("currentReplicas", 0);
            return new StatefulSetInfo(specReplicas, readyReplicas, replicas);
        }
    }
}

