/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.serialization;

import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.impl.AbstractSerializationService;
import com.hazelcast.internal.serialization.impl.InternalGenericRecord;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.serialization.impl.SerializerAdapter;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.serialization.impl.portable.PortableContext;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.impl.util.ReflectionUtils;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.partition.PartitioningStrategy;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DelegatingSerializationService
extends AbstractSerializationService {
    private final Map<Class<?>, SerializerAdapter> serializersByClass;
    private final Map<Integer, SerializerAdapter> serializersById;
    private final AbstractSerializationService delegate;
    private volatile boolean active;

    public DelegatingSerializationService(Map<Class<?>, ? extends Serializer> serializers, AbstractSerializationService delegate) {
        super(delegate);
        if (serializers.isEmpty()) {
            this.serializersByClass = Collections.emptyMap();
            this.serializersById = Collections.emptyMap();
        } else {
            HashMap serializersByClass = new HashMap();
            HashMap<Integer, SerializerAdapter> serializersById = new HashMap<Integer, SerializerAdapter>();
            serializers.forEach((clazz, serializer) -> {
                int typeId = serializer.getTypeId();
                String serializerClassName = serializer.getClass().getName();
                if (typeId <= 0) {
                    throw new IllegalArgumentException("Cannot register Serializer[" + serializerClassName + "] - typeId should be > 0");
                }
                if (serializersById.containsKey(typeId)) {
                    Serializer registered = ((SerializerAdapter)serializersById.get(typeId)).getImpl();
                    throw new IllegalStateException("Cannot register Serializer[" + serializerClassName + "] - " + registered.getClass().getName() + " has been already registered for type ID: " + typeId);
                }
                SerializerAdapter serializerAdapter = SerializationUtil.createSerializerAdapter(serializer);
                serializersByClass.put((Class<?>)clazz, serializerAdapter);
                serializersById.put(typeId, serializerAdapter);
            });
            this.serializersByClass = serializersByClass;
            this.serializersById = serializersById;
        }
        this.delegate = delegate;
        this.active = true;
    }

    @Override
    public <B extends Data> B toData(Object object, DataType type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <B extends Data> B toData(Object object, DataType type, PartitioningStrategy strategy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <B extends Data> B convertData(Data data, DataType dataType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InternalGenericRecord readAsInternalGenericRecord(Data data) throws IOException {
        return this.delegate.readAsInternalGenericRecord(data);
    }

    @Override
    public Schema extractSchemaFromData(@Nonnull Data data) throws IOException {
        return this.delegate.extractSchemaFromData(data);
    }

    @Override
    public Schema extractSchemaFromObject(@Nonnull Object object) {
        return this.delegate.extractSchemaFromObject(object);
    }

    @Override
    public PortableContext getPortableContext() {
        return this.delegate.getPortableContext();
    }

    @Override
    public SerializerAdapter serializerFor(Object object, boolean includeSchema) {
        Class<?> clazz = object == null ? null : object.getClass();
        SerializerAdapter serializer = null;
        if (clazz != null) {
            serializer = this.serializersByClass.get(clazz);
        }
        if (serializer == null) {
            try {
                serializer = this.delegate.serializerFor(object, includeSchema);
            }
            catch (HazelcastSerializationException hse) {
                throw this.serializationException(clazz, (Throwable)hse);
            }
        }
        if (serializer == null) {
            throw this.active ? this.serializationException(clazz) : new HazelcastInstanceNotActiveException();
        }
        return serializer;
    }

    private RuntimeException serializationException(@Nullable Class<?> clazz, Throwable t) {
        return new JetException("Unable to serialize instance of " + String.valueOf(clazz) + ": " + t.getMessage() + " - Note: You can register a serializer using JobConfig.registerSerializer()", t);
    }

    private RuntimeException serializationException(@Nullable Class<?> clazz) {
        return new JetException("There is no suitable serializer for " + String.valueOf(clazz) + ", did you register it with JobConfig.registerSerializer()?");
    }

    @Override
    public SerializerAdapter serializerFor(int typeId) {
        SerializerAdapter serializer = this.serializersById.get(typeId);
        if (serializer == null) {
            try {
                serializer = this.delegate.serializerFor(typeId);
            }
            catch (HazelcastSerializationException hse) {
                throw this.serializationException(typeId, (Throwable)hse);
            }
        }
        if (serializer == null) {
            throw this.active ? this.serializationException(typeId) : new HazelcastInstanceNotActiveException();
        }
        return serializer;
    }

    private RuntimeException serializationException(int typeId, Throwable t) {
        return new JetException("Unable to deserialize object for type " + typeId + ": " + t.getMessage(), t);
    }

    private RuntimeException serializationException(int typeId) {
        return new JetException("There is no suitable de-serializer for type " + typeId + ". This exception is likely caused by differences in the serialization configuration between members or between clients and members.");
    }

    public boolean hasAddedSerializers() {
        return !this.serializersByClass.isEmpty();
    }

    @Override
    public void dispose() {
        this.active = false;
        for (SerializerAdapter serializer : this.serializersByClass.values()) {
            serializer.destroy();
        }
    }

    public static InternalSerializationService from(SerializationService serializationService, Map<String, String> serializerConfigs) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        HashMap serializers = new HashMap();
        for (Map.Entry<String, String> entry : serializerConfigs.entrySet()) {
            serializers.put(ReflectionUtils.loadClass(classLoader, entry.getKey()), (Serializer)ReflectionUtils.newInstance(classLoader, entry.getValue()));
        }
        return new DelegatingSerializationService(serializers, (AbstractSerializationService)serializationService);
    }
}

