/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.security.PermissionsUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class ProcessorSupplierFromSimpleSupplier
implements ProcessorSupplier,
IdentifiedDataSerializable {
    private static final long serialVersionUID = 1L;
    private SupplierEx<? extends Processor> simpleSupplier;

    public ProcessorSupplierFromSimpleSupplier() {
    }

    public ProcessorSupplierFromSimpleSupplier(SupplierEx<? extends Processor> simpleSupplier) {
        this.simpleSupplier = simpleSupplier;
    }

    @Override
    public void init(@Nonnull ProcessorSupplier.Context context) throws Exception {
        PermissionsUtil.checkPermission(this.simpleSupplier, context);
    }

    @Override
    public boolean initIsCooperative() {
        return true;
    }

    @Override
    public boolean closeIsCooperative() {
        return true;
    }

    @Override
    @Nonnull
    public Collection<? extends Processor> get(int count) {
        return Stream.generate(this.simpleSupplier).limit(count).collect(Collectors.toList());
    }

    @Override
    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 45;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.simpleSupplier);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.simpleSupplier = (SupplierEx)in.readObject();
    }
}

