/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.serialization.SerializableByConvention;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.connector.ConnectorNameAware;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.security.PermissionsUtil;
import java.io.IOException;
import java.security.Permission;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@SerializableByConvention
public class MetaSupplierFromProcessorSupplier
implements ProcessorMetaSupplier,
DataSerializable,
ConnectorNameAware {
    private static final long serialVersionUID = 1L;
    private int preferredLocalParallelism;
    private ProcessorSupplier processorSupplier;
    private Permission permission;
    @Nullable
    private String connectorName;

    public MetaSupplierFromProcessorSupplier() {
    }

    public MetaSupplierFromProcessorSupplier(int preferredLocalParallelism, Permission permission, ProcessorSupplier processorSupplier) {
        this.preferredLocalParallelism = preferredLocalParallelism;
        this.permission = permission;
        this.processorSupplier = processorSupplier;
    }

    public MetaSupplierFromProcessorSupplier(int preferredLocalParallelism, Permission permission, ProcessorSupplier processorSupplier, @Nullable String connectorName) {
        this.preferredLocalParallelism = preferredLocalParallelism;
        this.permission = permission;
        this.processorSupplier = processorSupplier;
        this.connectorName = connectorName;
    }

    @Override
    public void init(@Nonnull ProcessorMetaSupplier.Context context) throws Exception {
        PermissionsUtil.checkPermission(this.processorSupplier, context);
    }

    @Override
    public int preferredLocalParallelism() {
        return this.preferredLocalParallelism;
    }

    @Override
    @Nonnull
    public Function<? super Address, ? extends ProcessorSupplier> get(@Nonnull List<Address> addresses) {
        return address -> this.processorSupplier;
    }

    @Override
    public Permission getRequiredPermission() {
        return this.permission;
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public boolean initIsCooperative() {
        return true;
    }

    @Override
    public boolean closeIsCooperative() {
        return true;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.preferredLocalParallelism);
        out.writeObject(this.processorSupplier);
        out.writeObject(this.permission);
        out.writeString(this.connectorName);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.preferredLocalParallelism = in.readInt();
        this.processorSupplier = (ProcessorSupplier)in.readObject();
        this.permission = (Permission)in.readObject();
        this.connectorName = in.readString();
    }

    @Override
    @Nullable
    public String getConnectorName() {
        return this.connectorName;
    }
}

