/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.operation.AsyncMasterAwareJobOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;

public class JoinSubmittedJobOperation
extends AsyncMasterAwareJobOperation {
    private boolean isLightJob;

    public JoinSubmittedJobOperation() {
    }

    public JoinSubmittedJobOperation(long jobId, boolean isLightJob) {
        super(jobId);
        this.isLightJob = isLightJob;
    }

    @Override
    protected CompletableFuture<?> doRun() {
        if (this.isLightJob) {
            return this.getJobCoordinationService().joinLightJob(this.jobId());
        }
        return this.getJobCoordinationService().joinSubmittedJob(this.jobId());
    }

    @Override
    public int getClassId() {
        return 15;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.isLightJob);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.isLightJob = in.readBoolean();
    }

    @Override
    public boolean isRequireMasterExecution() {
        return !this.isLightJob;
    }
}

