/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution;

import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.impl.execution.SnapshotFlags;
import com.hazelcast.jet.impl.operation.SnapshotPhase1Operation;
import com.hazelcast.logging.ILogger;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class SnapshotContext {
    private final ILogger logger;
    private final String jobNameAndExecutionId;
    private final ProcessingGuarantee guarantee;
    private volatile int snapshotFlags;
    private int numSsTasklets = Integer.MIN_VALUE;
    private int numPTasklets = Integer.MIN_VALUE;
    private int numPrioritySsTasklets = Integer.MIN_VALUE;
    private final AtomicInteger numRemainingTasklets = new AtomicInteger();
    private final AtomicReference<Throwable> snapshotError = new AtomicReference();
    private volatile long activeSnapshotIdPhase1;
    private volatile long activeSnapshotIdPhase2;
    private volatile boolean lastPhase1Successful;
    private long currentSnapshotId;
    private volatile String currentMapName;
    private volatile CompletableFuture<SnapshotPhase1Operation.SnapshotPhase1Result> phase1Future;
    private volatile CompletableFuture<Void> phase2Future;
    private final AtomicLong totalBytes = new AtomicLong();
    private final AtomicLong totalKeys = new AtomicLong();
    private final AtomicLong totalChunks = new AtomicLong();
    private boolean isCancelled;

    public SnapshotContext(ILogger logger, String jobNameAndExecutionId, long activeSnapshotId, ProcessingGuarantee guarantee) {
        this.jobNameAndExecutionId = jobNameAndExecutionId;
        this.activeSnapshotIdPhase2 = this.currentSnapshotId = activeSnapshotId;
        this.activeSnapshotIdPhase1 = this.currentSnapshotId;
        this.guarantee = guarantee;
        this.logger = logger;
    }

    long activeSnapshotIdPhase1() {
        return this.activeSnapshotIdPhase1;
    }

    long activeSnapshotIdPhase2() {
        return this.activeSnapshotIdPhase2;
    }

    public long currentSnapshotId() {
        return this.currentSnapshotId;
    }

    public String currentMapName() {
        return this.currentMapName;
    }

    boolean isTerminalSnapshot() {
        return SnapshotFlags.isTerminal(this.snapshotFlags);
    }

    public boolean isExportOnly() {
        return SnapshotFlags.isExportOnly(this.snapshotFlags);
    }

    boolean isLastPhase1Successful() {
        return this.lastPhase1Successful;
    }

    public ProcessingGuarantee processingGuarantee() {
        return this.guarantee;
    }

    synchronized void initTaskletCount(int numPTasklets, int numSsTasklets, int numPrioritySsTasklets) {
        assert (this.numSsTasklets == Integer.MIN_VALUE && this.numPTasklets == Integer.MIN_VALUE) : "Tasklet count already set";
        assert (numSsTasklets >= 0 && numPrioritySsTasklets >= 0 && numSsTasklets >= numPrioritySsTasklets && numPTasklets >= numSsTasklets) : "numPTasklets=" + numPTasklets + ", numSsTasklets=" + numSsTasklets + ", numPrioritySsTasklets=" + numPrioritySsTasklets;
        this.numSsTasklets = numSsTasklets;
        this.numPTasklets = numPTasklets;
        this.numPrioritySsTasklets = numPrioritySsTasklets;
    }

    synchronized CompletableFuture<SnapshotPhase1Operation.SnapshotPhase1Result> startNewSnapshotPhase1(long snapshotId, String mapName, int flags) {
        if (snapshotId == this.currentSnapshotId) {
            throw new RuntimeException("new snapshotId equal to previous, operation probably retried. Previous=" + this.currentSnapshotId + ", new=" + snapshotId);
        }
        assert (snapshotId == this.currentSnapshotId + 1L) : "New snapshotId for " + this.jobNameAndExecutionId + " not incremented by 1. Previous=" + this.currentSnapshotId + ", new=" + snapshotId;
        assert (this.currentSnapshotId == this.activeSnapshotIdPhase1) : "last snapshot was postponed but not started";
        assert (this.numSsTasklets >= 0) : "numSsTasklets=" + this.numSsTasklets;
        assert (this.phase1Future == null) : "phase 1 already in progress";
        assert (this.phase2Future == null) : "phase 2 still ongoing";
        assert (snapshotId == this.activeSnapshotIdPhase2 + 1L) : "snapshotId=" + snapshotId + ", activeSnapshotIdPhase2=" + this.activeSnapshotIdPhase2;
        if (this.isCancelled) {
            throw new CancellationException("execution cancelled");
        }
        this.snapshotFlags = flags;
        boolean success = this.numRemainingTasklets.compareAndSet(0, this.numSsTasklets);
        assert (success) : "numRemainingTasklets wasn't 0, but " + this.numRemainingTasklets.get();
        this.currentSnapshotId = snapshotId;
        this.currentMapName = mapName;
        if (this.numPrioritySsTasklets == 0) {
            this.activeSnapshotIdPhase1 = this.currentSnapshotId;
        } else {
            this.logger.info("Snapshot " + snapshotId + " for " + this.jobNameAndExecutionId + " is postponed until all higher priority vertices are completed (number of such vertices = " + this.numPrioritySsTasklets + ")");
        }
        if (this.numSsTasklets == 0) {
            return CompletableFuture.completedFuture(new SnapshotPhase1Operation.SnapshotPhase1Result(0L, 0L, 0L, null));
        }
        this.phase1Future = new CompletableFuture();
        return this.phase1Future;
    }

    synchronized CompletableFuture<Void> startNewSnapshotPhase2(long snapshotId, boolean success) {
        if (snapshotId == this.activeSnapshotIdPhase2) {
            this.logger.warning("Second request for phase 2 for snapshot " + snapshotId);
            CompletableFuture<Void> res = this.phase2Future;
            if (res == null) {
                res = CompletableFuture.completedFuture(null);
            }
            return res;
        }
        assert (snapshotId == this.activeSnapshotIdPhase1) : "requested phase 2 for snapshot ID " + snapshotId + ", but phase 1 snapshot ID is " + this.activeSnapshotIdPhase1;
        assert (this.phase1Future == null) : "phase 1 still ongoing";
        assert (this.phase2Future == null) : "phase 2 already in progress";
        assert (snapshotId > this.activeSnapshotIdPhase2) : "new snapshotId for phase 2 not larger than previous. Previous=" + this.activeSnapshotIdPhase2 + ", new=" + snapshotId;
        assert (this.numPTasklets >= 0) : "numPTasklets=" + this.numPTasklets;
        if (this.isCancelled) {
            throw new CancellationException("execution cancelled");
        }
        this.lastPhase1Successful = success;
        assert (this.numPrioritySsTasklets == 0) : "numPrioritySsTasklets=" + this.numPrioritySsTasklets;
        boolean casSuccess = this.numRemainingTasklets.compareAndSet(0, this.numPTasklets);
        assert (casSuccess) : "numRemainingTasklets wasn't 0, but " + this.numRemainingTasklets.get();
        this.activeSnapshotIdPhase2 = snapshotId;
        if (this.numPTasklets == 0) {
            return CompletableFuture.completedFuture(null);
        }
        this.phase2Future = new CompletableFuture();
        return this.phase2Future;
    }

    synchronized void storeSnapshotTaskletDone(long lastCompletedSnapshotId, boolean isHigherPrioritySource) {
        assert (this.numSsTasklets > 0) : "numSsTasklets=" + this.numSsTasklets;
        assert (lastCompletedSnapshotId <= this.activeSnapshotIdPhase1) : "activeSnapshotIdPhase1=" + this.activeSnapshotIdPhase1 + ", tasklet.lastCompletedSnapshotId=" + lastCompletedSnapshotId;
        --this.numSsTasklets;
        if (isHigherPrioritySource) {
            assert (this.numPrioritySsTasklets > 0) : "numPrioritySsTasklets=" + this.numPrioritySsTasklets;
            --this.numPrioritySsTasklets;
            if (this.numPrioritySsTasklets == 0 && this.activeSnapshotIdPhase1 < this.currentSnapshotId) {
                this.activeSnapshotIdPhase1 = this.currentSnapshotId;
                this.logger.info("Postponed snapshot " + this.activeSnapshotIdPhase1 + " for " + this.jobNameAndExecutionId + " started");
            }
        }
        assert (this.numPrioritySsTasklets <= this.numSsTasklets) : "numPrioritySsTasklets > numSsTasklets";
        assert (lastCompletedSnapshotId <= this.currentSnapshotId) : "tasklet completed a snapshot that didn't start yet";
        if (lastCompletedSnapshotId < this.currentSnapshotId) {
            this.phase1DoneForTasklet(0L, 0L, 0L);
        } else assert (lastCompletedSnapshotId == this.activeSnapshotIdPhase1 && lastCompletedSnapshotId == this.activeSnapshotIdPhase2) : "lastCompletedSnapshotId=" + lastCompletedSnapshotId + ", activeSnapshotIdPhase1=" + this.activeSnapshotIdPhase1 + ", activeSnapshotIdPhase2=" + this.activeSnapshotIdPhase2;
    }

    synchronized void processorTaskletDone(long lastCompletedPhase2SnapshotId) {
        assert (this.numPTasklets > 0) : "numPTasklets=" + this.numPTasklets;
        assert (lastCompletedPhase2SnapshotId == this.activeSnapshotIdPhase2) : "phase2 was initiated, processor completed without doing it";
        --this.numPTasklets;
    }

    void phase1DoneForTasklet(long numBytes, long numKeys, long numChunks) {
        this.totalBytes.addAndGet(numBytes);
        this.totalKeys.addAndGet(numKeys);
        this.totalChunks.addAndGet(numChunks);
        int newRemainingTasklets = this.numRemainingTasklets.decrementAndGet();
        assert (newRemainingTasklets >= 0) : "newRemainingTasklets=" + newRemainingTasklets;
        if (newRemainingTasklets == 0) {
            this.handlePhase1Done();
        }
    }

    void phase2DoneForTasklet() {
        int newRemainingTasklets = this.numRemainingTasklets.decrementAndGet();
        assert (newRemainingTasklets >= 0) : "newRemainingTasklets=" + newRemainingTasklets;
        if (newRemainingTasklets == 0) {
            this.handlePhase2Done();
        }
    }

    synchronized void cancel() {
        if (this.phase1Future != null) {
            this.reportError(new CancellationException("execution cancelled"));
            this.handlePhase1Done();
        }
        if (this.phase2Future != null) {
            this.handlePhase2Done();
        }
        this.isCancelled = true;
    }

    private synchronized void handlePhase1Done() {
        if (this.isCancelled) {
            assert (this.phase1Future == null) : "phase1Future=" + String.valueOf(this.phase1Future);
            return;
        }
        this.phase1Future.complete(new SnapshotPhase1Operation.SnapshotPhase1Result(this.totalBytes.get(), this.totalKeys.get(), this.totalChunks.get(), this.snapshotError.get()));
        this.phase1Future = null;
        this.snapshotError.set(null);
        this.totalBytes.set(0L);
        this.totalKeys.set(0L);
        this.totalChunks.set(0L);
        this.currentMapName = null;
    }

    private synchronized void handlePhase2Done() {
        if (this.isCancelled) {
            assert (this.phase2Future == null) : "phase2Future=" + String.valueOf(this.phase2Future);
            return;
        }
        this.phase2Future.complete(null);
        this.phase2Future = null;
    }

    void reportError(Throwable ex) {
        this.snapshotError.compareAndSet(null, ex);
    }

    AtomicInteger getNumRemainingTasklets() {
        return this.numRemainingTasklets;
    }
}

