/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.aggregate;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.impl.aggregate.AggregateDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AggregateOperationImpl<A, R>
implements AggregateOperation<A, R>,
IdentifiedDataSerializable {
    private static final long serialVersionUID = 1L;
    BiConsumerEx<? super A, ?>[] accumulateFns;
    private SupplierEx<A> createFn;
    private BiConsumerEx<? super A, ? super A> combineFn;
    private BiConsumerEx<? super A, ? super A> deductFn;
    private FunctionEx<? super A, ? extends R> exportFn;
    private FunctionEx<? super A, ? extends R> finishFn;

    public AggregateOperationImpl() {
    }

    public AggregateOperationImpl(@Nonnull SupplierEx<A> createFn, @Nonnull BiConsumerEx<? super A, ?>[] accumulateFns, @Nullable BiConsumerEx<? super A, ? super A> combineFn, @Nullable BiConsumerEx<? super A, ? super A> deductFn, @Nonnull FunctionEx<? super A, ? extends R> exportFn, @Nonnull FunctionEx<? super A, ? extends R> finishFn) {
        for (BiConsumerEx<? super A, ?> f : accumulateFns) {
            Preconditions.checkNotNull(f, "accumulateFns array contains a null slot");
        }
        this.createFn = createFn;
        this.accumulateFns = (BiConsumerEx[])accumulateFns.clone();
        this.combineFn = combineFn;
        this.deductFn = deductFn;
        this.exportFn = exportFn;
        this.finishFn = finishFn;
    }

    @Override
    public int arity() {
        return this.accumulateFns.length;
    }

    @Override
    @Nonnull
    public SupplierEx<A> createFn() {
        return this.createFn;
    }

    @Override
    @Nonnull
    public <T> BiConsumerEx<? super A, ? super T> accumulateFn(int index) {
        if (index >= this.accumulateFns.length) {
            throw new IllegalArgumentException("This AggregateOperation has " + this.accumulateFns.length + " accumulating functions, but was asked for function at index " + index);
        }
        return this.accumulateFns[index];
    }

    @Override
    @Nullable
    public BiConsumerEx<? super A, ? super A> combineFn() {
        return this.combineFn;
    }

    @Override
    @Nullable
    public BiConsumerEx<? super A, ? super A> deductFn() {
        return this.deductFn;
    }

    @Override
    @Nonnull
    public FunctionEx<? super A, ? extends R> exportFn() {
        return this.exportFn;
    }

    @Override
    @Nonnull
    public FunctionEx<? super A, ? extends R> finishFn() {
        return this.finishFn;
    }

    @Override
    @Nonnull
    public AggregateOperation<A, R> withAccumulateFns(BiConsumerEx ... accumulateFns) {
        return new AggregateOperationImpl<A, R>(this.createFn(), accumulateFns, this.combineFn(), this.deductFn(), this.exportFn(), this.finishFn());
    }

    @Override
    @Nonnull
    public AggregateOperation<A, A> withIdentityFinish() {
        SerializationUtil.checkSerializable(this.finishFn, "finishFn");
        return new AggregateOperationImpl<A, A>(this.createFn(), this.accumulateFns, this.combineFn(), this.deductFn(), this.unsupportedExportFn(), FunctionEx.identity());
    }

    @Override
    @Nonnull
    public <R_NEW> AggregateOperation<A, R_NEW> andThen(FunctionEx<? super R, ? extends R_NEW> thenFn) {
        return new AggregateOperationImpl<A, R_NEW>(this.createFn(), this.accumulateFns, this.combineFn(), this.deductFn(), this.exportFn().andThen(thenFn), this.finishFn().andThen(thenFn));
    }

    @Nonnull
    static <A> BiConsumerEx<? super A, ?>[] accumulateFns(BiConsumerEx ... accFns) {
        return accFns;
    }

    FunctionEx<? super A, ? extends A> unsupportedExportFn() {
        return x -> {
            throw new UnsupportedOperationException("Can't use exportFn on an aggregate operation with identity finishFn");
        };
    }

    @Override
    public int getFactoryId() {
        return AggregateDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.accumulateFns.length);
        for (BiConsumerEx<? super A, ?> accumulateFn : this.accumulateFns) {
            out.writeObject(accumulateFn);
        }
        out.writeObject(this.createFn);
        out.writeObject(this.combineFn);
        out.writeObject(this.deductFn);
        out.writeObject(this.exportFn);
        out.writeObject(this.finishFn);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.accumulateFns = new BiConsumerEx[in.readInt()];
        for (int i = 0; i < this.accumulateFns.length; ++i) {
            this.accumulateFns[i] = (BiConsumerEx)in.readObject();
        }
        this.createFn = (SupplierEx)in.readObject();
        this.combineFn = (BiConsumerEx)in.readObject();
        this.deductFn = (BiConsumerEx)in.readObject();
        this.exportFn = (FunctionEx)in.readObject();
        this.finishFn = (FunctionEx)in.readObject();
    }
}

