/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Outbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.logging.ILogger;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public abstract class AbstractProcessor
implements Processor {
    private ILogger logger;
    private Outbox outbox;
    private Object pendingItem;
    private Map.Entry<?, ?> pendingSnapshotItem;

    @Override
    public final void init(@Nonnull Outbox outbox, @Nonnull Processor.Context context) throws Exception {
        this.outbox = outbox;
        this.logger = context.logger();
        this.init(context);
    }

    @Override
    public final void restoreFromSnapshot(@Nonnull Inbox inbox) {
        Map.Entry entry;
        while ((entry = (Map.Entry)inbox.poll()) != null) {
            this.restoreFromSnapshot(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void process(int ordinal, @Nonnull Inbox inbox) {
        try {
            switch (ordinal) {
                case 0: {
                    this.process0(inbox);
                    break;
                }
                case 1: {
                    this.process1(inbox);
                    break;
                }
                case 2: {
                    this.process2(inbox);
                    break;
                }
                case 3: {
                    this.process3(inbox);
                    break;
                }
                case 4: {
                    this.process4(inbox);
                    break;
                }
                default: {
                    this.processAny(ordinal, inbox);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    protected void init(@Nonnull Processor.Context context) throws Exception {
    }

    protected boolean tryProcess(int ordinal, @Nonnull Object item) throws Exception {
        throw new UnsupportedOperationException("Missing implementation in " + String.valueOf(this.getClass()));
    }

    protected boolean tryProcess0(@Nonnull Object item) throws Exception {
        return this.tryProcess(0, item);
    }

    protected boolean tryProcess1(@Nonnull Object item) throws Exception {
        return this.tryProcess(1, item);
    }

    protected boolean tryProcess2(@Nonnull Object item) throws Exception {
        return this.tryProcess(2, item);
    }

    protected boolean tryProcess3(@Nonnull Object item) throws Exception {
        return this.tryProcess(3, item);
    }

    protected boolean tryProcess4(@Nonnull Object item) throws Exception {
        return this.tryProcess(4, item);
    }

    protected void restoreFromSnapshot(@Nonnull Object key, @Nonnull Object value) {
        throw new UnsupportedOperationException("Missing implementation in " + String.valueOf(this.getClass()));
    }

    @Override
    public boolean tryProcessWatermark(@Nonnull Watermark watermark) {
        return this.tryEmit(watermark);
    }

    protected final ILogger getLogger() {
        return this.logger;
    }

    protected final Outbox getOutbox() {
        return this.outbox;
    }

    @CheckReturnValue
    protected final boolean tryEmit(int ordinal, @Nonnull Object item) {
        return this.outbox.offer(ordinal, item);
    }

    @CheckReturnValue
    protected final boolean tryEmit(@Nonnull Object item) {
        return this.outbox.offer(item);
    }

    @CheckReturnValue
    protected final boolean tryEmit(@Nonnull int[] ordinals, @Nonnull Object item) {
        return this.outbox.offer(ordinals, item);
    }

    protected final <E> boolean emitFromTraverser(@Nonnull int[] ordinals, @Nonnull Traverser<E> traverser) {
        Object item;
        if (this.pendingItem != null) {
            item = this.pendingItem;
            this.pendingItem = null;
        } else {
            item = traverser.next();
        }
        while (item != null) {
            if (!this.tryEmit(ordinals, item)) {
                this.pendingItem = item;
                return false;
            }
            item = traverser.next();
        }
        return true;
    }

    protected final <E> boolean emitFromTraverser(int ordinal, @Nonnull Traverser<E> traverser) {
        Object item;
        if (this.pendingItem != null) {
            item = this.pendingItem;
            this.pendingItem = null;
        } else {
            item = traverser.next();
        }
        while (item != null) {
            if (!this.tryEmit(ordinal, item)) {
                this.pendingItem = item;
                return false;
            }
            item = traverser.next();
        }
        return true;
    }

    protected final boolean emitFromTraverser(@Nonnull Traverser<?> traverser) {
        return this.emitFromTraverser(-1, traverser);
    }

    @CheckReturnValue
    protected final boolean tryEmitToSnapshot(@Nonnull Object key, @Nonnull Object value) {
        return this.outbox.offerToSnapshot(key, value);
    }

    protected final <T extends Map.Entry<?, ?>> boolean emitFromTraverserToSnapshot(@Nonnull Traverser<T> traverser) {
        Map.Entry item;
        if (this.pendingSnapshotItem != null) {
            item = this.pendingSnapshotItem;
            this.pendingSnapshotItem = null;
        } else {
            item = (Map.Entry)traverser.next();
        }
        while (item != null) {
            if (!this.tryEmitToSnapshot(item.getKey(), item.getValue())) {
                this.pendingSnapshotItem = item;
                return false;
            }
            item = (Map.Entry)traverser.next();
        }
        return true;
    }

    @Nonnull
    protected final <T, R> FlatMapper<T, R> flatMapper(int ordinal, @Nonnull Function<? super T, ? extends Traverser<? extends R>> mapper) {
        return ordinal != -1 ? this.flatMapper(new int[]{ordinal}, mapper) : this.flatMapper(mapper);
    }

    @Nonnull
    protected final <T, R> FlatMapper<T, R> flatMapper(@Nonnull Function<? super T, ? extends Traverser<? extends R>> mapper) {
        return new FlatMapper(null, mapper);
    }

    @Nonnull
    protected final <T, R> FlatMapper<T, R> flatMapper(@Nonnull int[] ordinals, @Nonnull Function<? super T, ? extends Traverser<? extends R>> mapper) {
        return new FlatMapper(ordinals, mapper);
    }

    protected void keyedWatermarkCheck(Watermark watermark) {
        if (watermark.key() != 0) {
            throw new UnsupportedOperationException("Keyed watermarks are not supported for " + this.getClass().getName());
        }
    }

    private void process0(@Nonnull Inbox inbox) throws Exception {
        Object item;
        while ((item = inbox.peek()) != null && this.tryProcess0(item)) {
            inbox.remove();
        }
    }

    private void process1(@Nonnull Inbox inbox) throws Exception {
        Object item;
        while ((item = inbox.peek()) != null && this.tryProcess1(item)) {
            inbox.remove();
        }
    }

    private void process2(@Nonnull Inbox inbox) throws Exception {
        Object item;
        while ((item = inbox.peek()) != null && this.tryProcess2(item)) {
            inbox.remove();
        }
    }

    private void process3(@Nonnull Inbox inbox) throws Exception {
        Object item;
        while ((item = inbox.peek()) != null && this.tryProcess3(item)) {
            inbox.remove();
        }
    }

    private void process4(@Nonnull Inbox inbox) throws Exception {
        Object item;
        while ((item = inbox.peek()) != null && this.tryProcess4(item)) {
            inbox.remove();
        }
    }

    private void processAny(int ordinal, @Nonnull Inbox inbox) throws Exception {
        Object item;
        while ((item = inbox.peek()) != null && this.tryProcess(ordinal, item)) {
            inbox.remove();
        }
    }

    protected final class FlatMapper<T, R> {
        private final int[] outputOrdinals;
        private final Function<? super T, ? extends Traverser<? extends R>> mapper;
        private Traverser<? extends R> outputTraverser;

        private FlatMapper(@Nonnull int[] outputOrdinals, Function<? super T, ? extends Traverser<? extends R>> mapper) {
            this.outputOrdinals = outputOrdinals;
            this.mapper = mapper;
        }

        public boolean tryProcess(@Nonnull T item) {
            if (this.outputTraverser == null) {
                this.outputTraverser = this.mapper.apply(item);
            }
            if (this.emit()) {
                this.outputTraverser = null;
                return true;
            }
            return false;
        }

        private boolean emit() {
            return this.outputOrdinals != null ? AbstractProcessor.this.emitFromTraverser(this.outputOrdinals, this.outputTraverser) : AbstractProcessor.this.emitFromTraverser(this.outputTraverser);
        }
    }
}

