/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.executor;

import com.hazelcast.internal.tpcengine.util.ReflectionUtil;
import com.hazelcast.spi.impl.DeserializingCompletableFuture;
import java.lang.invoke.VarHandle;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.RunnableFuture;

public class CompletableFutureTask<V>
extends DeserializingCompletableFuture<V>
implements RunnableFuture<V> {
    private static final VarHandle RUNNER = ReflectionUtil.findVarHandle("runner", Thread.class);
    private final Callable<V> callable;
    private volatile Thread runner;

    CompletableFutureTask(Callable<V> callable) {
        this.callable = callable;
    }

    CompletableFutureTask(Runnable runnable, V result) {
        this.callable = Executors.callable(runnable, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.isDone()) {
            return;
        }
        if (this.runner != null || !RUNNER.compareAndSet(this, null, Thread.currentThread())) {
            return;
        }
        try {
            Callable<V> c = this.callable;
            if (c != null) {
                Object result = null;
                try {
                    result = c.call();
                    this.complete(result);
                }
                catch (Throwable ex) {
                    this.completeExceptionally(ex);
                }
            }
        }
        finally {
            this.runner = null;
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Thread executingThread;
        boolean result = super.cancel(mayInterruptIfRunning);
        if (result && mayInterruptIfRunning && (executingThread = this.runner) != null) {
            executingThread.interrupt();
        }
        return result;
    }

    @Override
    public String toString() {
        return "CompletableFutureTask{callable=" + String.valueOf(this.callable) + ", runner=" + String.valueOf(this.runner) + "}";
    }
}

